/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.IOException;
import java.security.KeyStore;
import org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.PKCS12FileLoader;
import org.apache.zookeeper.common.X509KeyType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PKCS12FileLoaderTest
extends BaseX509ParameterizedTestCase {
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadKeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        KeyStore ks = ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        Assertions.assertEquals((int)1, (int)ks.size());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadKeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(Exception.class, () -> {
            String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword("wrong password").build()).loadKeyStore();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadKeyStoreWithWrongFilePath(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(IOException.class, () -> {
            String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path + ".does_not_exist").setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadKeyStoreWithNullFilePath(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(NullPointerException.class, () -> ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadKeyStoreWithWrongFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(IOException.class, () -> {
            String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadTrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        KeyStore ts = ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        Assertions.assertEquals((int)1, (int)ts.size());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadTrustStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(Exception.class, () -> {
            String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword("wrong password").build()).loadTrustStore();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadTrustStoreWithWrongFilePath(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(IOException.class, () -> {
            String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path + ".does_not_exist").setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadTrustStoreWithNullFilePath(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(NullPointerException.class, () -> ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadTrustStoreWithWrongFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(IOException.class, () -> {
            String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
            ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        });
    }
}

