/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.ScopeHandler;
import org.inferred.freebuilder.processor.source.TypeUsage;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ArrayListMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimap;

class ImportManager {
    private static final QualifiedName CONFLICT = QualifiedName.of("", "import", new String[0]);
    private final Deque<TypeUsage> todo = new ArrayDeque<TypeUsage>();
    private final Map<String, QualifiedName> namespace = new HashMap<String, QualifiedName>();
    private final Multimap<QualifiedName, TypeUsage> imports = ArrayListMultimap.create();
    private final Map<TypeUsage, QualifiedName> resolutions = new HashMap<TypeUsage, QualifiedName>();
    private final ScopeHandler scopeHandler;
    private final String pkg;

    static String shortenReferences(CharSequence codeWithQualifiedNames, String pkg, int importsIndex, List<TypeUsage> typeUsages, ScopeHandler scopeHandler) {
        ImportManager importManager = new ImportManager(typeUsages, scopeHandler, pkg);
        importManager.selectImports();
        StringBuilder result = new StringBuilder().append(codeWithQualifiedNames, 0, importsIndex);
        importManager.appendImports(result);
        int offset = importsIndex;
        for (TypeUsage usage : typeUsages) {
            result.append(codeWithQualifiedNames, offset, usage.start());
            importManager.appendUsage(result, usage);
            offset = usage.end();
        }
        return result.append(codeWithQualifiedNames, offset, codeWithQualifiedNames.length()).toString();
    }

    private ImportManager(List<TypeUsage> usages, ScopeHandler scopeHandler, String pkg) {
        this.scopeHandler = scopeHandler;
        this.pkg = pkg;
        this.todo.addAll(usages);
    }

    private void selectImports() {
        while (!this.todo.isEmpty()) {
            this.resolveUsage(this.todo.removeLast());
        }
        this.imports.asMap().forEach((name, usages) -> usages.forEach(usage -> this.resolutions.put((TypeUsage)usage, (QualifiedName)name)));
    }

    private void appendImports(StringBuilder result) {
        Preconditions.checkState(this.todo.isEmpty());
        if (!this.imports.isEmpty()) {
            result.append("\n");
            this.imports.keySet().stream().sorted().forEach(type -> result.append("import ").append(type).append(";\n"));
            result.append("\n");
        }
    }

    private void appendUsage(StringBuilder result, TypeUsage usage) {
        Preconditions.checkState(this.todo.isEmpty());
        QualifiedName name = this.resolutions.get(usage);
        if (name == null) {
            result.append(usage.type());
        } else {
            result.append(name.getSimpleName());
            usage.type().getSimpleNames().stream().skip(name.getSimpleNames().size()).forEach(simpleName -> result.append('.').append((String)simpleName));
        }
    }

    private boolean reserveName(QualifiedName name) {
        QualifiedName conflict = this.namespace.putIfAbsent(name.getSimpleName(), name);
        if (conflict != null && !conflict.equals(name)) {
            this.namespace.put(name.getSimpleName(), CONFLICT);
            this.todo.addAll(this.imports.removeAll(conflict));
            return false;
        }
        return true;
    }

    private void rejectName(QualifiedName name) {
        QualifiedName conflict = this.namespace.putIfAbsent(name.getSimpleName(), CONFLICT);
        this.todo.addAll(this.imports.removeAll(conflict));
    }

    private boolean addImport(QualifiedName name, TypeUsage usage) {
        if (this.reserveName(name)) {
            this.imports.put(name, usage);
            return true;
        }
        return false;
    }

    private void resolveUsage(TypeUsage usage) {
        Function<QualifiedName, ScopeHandler.ScopeState> visibility = this.visibilityIn(this.scopeHandler, usage);
        QualifiedName name = usage.type();
        while (true) {
            switch (visibility.apply(name)) {
                case IN_SCOPE: {
                    this.reserveName(name);
                    this.resolutions.put(usage, name);
                    return;
                }
                case IMPORTABLE: {
                    if (!ImportManager.isSensibleImport(name) || !this.addImport(name, usage)) break;
                    return;
                }
                case HIDDEN: {
                    this.rejectName(name);
                }
            }
            if (name.isTopLevel()) {
                return;
            }
            name = name.enclosingType();
        }
    }

    private Function<QualifiedName, ScopeHandler.ScopeState> visibilityIn(ScopeHandler scopeHandler, TypeUsage usage) {
        if (usage.scope().isPresent()) {
            return t -> scopeHandler.visibilityIn(usage.scope().get(), (QualifiedName)t);
        }
        return t -> scopeHandler.visibilityIn(this.pkg, (QualifiedName)t);
    }

    private static boolean isSensibleImport(QualifiedName name) {
        if (name.isTopLevel()) {
            return true;
        }
        String simpleName = name.getSimpleName();
        for (int i = 1; i < simpleName.length(); ++i) {
            if (Character.isLowerCase(simpleName.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

