/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.RateLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposableRequestLimiter<RequestT>
implements RequestLimiter<RequestT> {
    protected static final Logger LOG = LoggerFactory.getLogger(ComposableRequestLimiter.class);
    private final RateLimiter limiter;
    private final OverlimitFunction<RequestT> overlimitFunction;
    private final CostFunction<RequestT> costFunction;
    private final Counter overlimitCounter;

    public ComposableRequestLimiter(RateLimiter limiter, OverlimitFunction<RequestT> overlimitFunction, CostFunction<RequestT> costFunction, StatsLogger statsLogger) {
        Preconditions.checkNotNull((Object)limiter);
        Preconditions.checkNotNull(overlimitFunction);
        Preconditions.checkNotNull(costFunction);
        this.limiter = limiter;
        this.overlimitFunction = overlimitFunction;
        this.costFunction = costFunction;
        this.overlimitCounter = statsLogger.getCounter("overlimit");
    }

    @Override
    public void apply(RequestT request) throws OverCapacityException {
        int permits = this.costFunction.apply(request);
        if (!this.limiter.acquire(permits)) {
            this.overlimitCounter.inc();
            this.overlimitFunction.apply(request);
        }
    }

    public static interface CostFunction<RequestT> {
        public int apply(RequestT var1);
    }

    public static interface OverlimitFunction<RequestT> {
        public void apply(RequestT var1) throws OverCapacityException;
    }
}

