/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.util.List;
import java.util.stream.Collectors;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ArrayTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ClassTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ExpressionTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.MethodTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.Tree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.VariableTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.TreeDissector;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Wrap;

class Corraller {
    private final int index;
    private final String compileSource;
    private final TreeDissector dis;

    Corraller(int index, String compileSource, TreeDissector dis) {
        this.index = index;
        this.compileSource = compileSource;
        this.dis = dis;
    }

    Wrap corralTree(Tree tree, String enclosingType, int indent) {
        switch (tree.getKind()) {
            case VARIABLE: {
                return this.corralVariable((VariableTree)tree, indent);
            }
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return this.corralType((ClassTree)tree, indent);
            }
            case METHOD: {
                return this.corralMethod((MethodTree)tree, enclosingType, indent);
            }
        }
        return null;
    }

    Wrap corralMethod(MethodTree mt) {
        return this.corralMethod(mt, null, 1);
    }

    Wrap corralMethod(MethodTree mt, String enclosingType, int indent) {
        Wrap.Range modRange = this.dis.treeToRange(mt.getModifiers());
        Wrap.Range tpRange = this.dis.treeListToRange(mt.getTypeParameters());
        Wrap.Range typeRange = this.dis.treeToRange(mt.getReturnType());
        String name = mt.getName().toString();
        if ("<init>".equals(name)) {
            name = enclosingType;
        }
        Wrap.Range paramRange = this.dis.treeListToRange(mt.getParameters());
        Wrap.Range throwsRange = this.dis.treeListToRange(mt.getThrows());
        return Wrap.corralledMethod(this.compileSource, modRange, tpRange, typeRange, name, paramRange, throwsRange, this.index, indent);
    }

    Wrap corralVariable(VariableTree vt, int indent) {
        int nameMax;
        String name = vt.getName().toString();
        Wrap.Range modRange = this.dis.treeToRange(vt.getModifiers());
        Tree baseType = vt.getType();
        StringBuilder sbBrackets = new StringBuilder();
        while (baseType instanceof ArrayTypeTree) {
            baseType = ((ArrayTypeTree)baseType).getType();
            sbBrackets.append("[]");
        }
        Wrap.Range rtype = this.dis.treeToRange(baseType);
        Wrap.Range runit = this.dis.treeToRange(vt);
        runit = new Wrap.Range(runit.begin, runit.end - 1);
        ExpressionTree it = vt.getInitializer();
        if (it != null) {
            Wrap.Range rinit = this.dis.treeToRange(it);
            nameMax = rinit.begin - 1;
        } else {
            nameMax = runit.end - 1;
        }
        int nameStart = this.compileSource.lastIndexOf(name, nameMax);
        if (nameStart < 0) {
            throw new AssertionError((Object)("Name '" + name + "' not found"));
        }
        int nameEnd = nameStart + name.length();
        Wrap.Range rname = new Wrap.Range(nameStart, nameEnd);
        return Wrap.corralledVar(this.compileSource, modRange, rtype, sbBrackets.toString(), rname, indent);
    }

    Wrap corralType(ClassTree ct2, int indent) {
        boolean isClass;
        switch (ct2.getKind()) {
            case CLASS: {
                isClass = true;
                break;
            }
            case INTERFACE: {
                isClass = false;
                break;
            }
            default: {
                return null;
            }
        }
        Wrap.Range modRange = this.dis.treeToRange(ct2.getModifiers());
        String name = ct2.getSimpleName().toString();
        Wrap.Range tpRange = this.dis.treeListToRange(ct2.getTypeParameters());
        Wrap.Range extendsRange = this.dis.treeToRange(ct2.getExtendsClause());
        List<Wrap.Range> implementsRanges = ct2.getImplementsClause().stream().map(ic -> this.dis.treeToRange((Tree)ic)).collect(Collectors.toList());
        List<Wrap> members = ct2.getMembers().stream().map(t -> this.corralTree((Tree)t, name, indent + 1)).filter(w -> w != null).collect(Collectors.toList());
        boolean hasConstructor = ct2.getMembers().stream().anyMatch(t -> t.getKind() == Tree.Kind.METHOD && ((MethodTree)t).getName().toString().equals("<init>"));
        Wrap wrap = Wrap.corralledType(this.compileSource, modRange, ct2.getKind(), name, tpRange, extendsRange, implementsRanges, members, isClass && !hasConstructor, this.index, indent);
        return wrap;
    }
}

