/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.io;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.hyracks.api.io.IODeviceHandle;

public class FileReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final IODeviceHandle dev;
    private final String path;
    private long registrationTime = 0L;

    public FileReference(IODeviceHandle dev, String path) {
        this.file = new File(dev.getMount(), path);
        this.dev = dev;
        this.path = path;
    }

    public File getFile() {
        return this.file;
    }

    public IODeviceHandle getDeviceHandle() {
        return this.dev;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileReference)) {
            return false;
        }
        return this.file.getAbsolutePath().equals(((FileReference)o).getAbsolutePath());
    }

    public int hashCode() {
        return this.file.getAbsolutePath().hashCode();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String getRelativePath() {
        return this.path;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public FileReference getChild(String name) {
        return new FileReference(this.dev, this.getChildPath(name));
    }

    public String getChildPath(String name) {
        return this.path + File.separator + name;
    }

    public String getName() {
        return this.file.getName();
    }

    public void register() {
        if (this.registrationTime != 0L) {
            throw new IllegalStateException("File " + this + " was already registered at " + new Date(this.registrationTime));
        }
        this.registrationTime = System.currentTimeMillis();
    }

    public long registrationTime() {
        return this.registrationTime;
    }

    public void unregister() {
        if (this.registrationTime == 0L) {
            throw new IllegalStateException("File " + this + " wasn't registered before");
        }
        this.registrationTime = 0L;
    }

    public boolean isCompressed() {
        return false;
    }

    public FileReference getParent() {
        int parentIndex = this.path.lastIndexOf(File.separatorChar);
        if (parentIndex < 0) {
            return new FileReference(this.dev, "");
        }
        String parentPath = this.path.substring(0, parentIndex);
        return new FileReference(this.dev, parentPath);
    }
}

