/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.cloud.CloudCachePolicy;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;

public class CloudProperties
extends AbstractProperties {
    public CloudProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public String getStorageScheme() {
        return this.accessor.getString(Option.CLOUD_STORAGE_SCHEME);
    }

    public String getStorageBucket() {
        return this.accessor.getString(Option.CLOUD_STORAGE_BUCKET);
    }

    public String getStoragePrefix() {
        return this.accessor.getString(Option.CLOUD_STORAGE_PREFIX);
    }

    public String getStorageEndpoint() {
        return this.accessor.getString(Option.CLOUD_STORAGE_ENDPOINT);
    }

    public String getStorageRegion() {
        return this.accessor.getString(Option.CLOUD_STORAGE_REGION);
    }

    public boolean isStorageAnonymousAuth() {
        return this.accessor.getBoolean(Option.CLOUD_STORAGE_ANONYMOUS_AUTH);
    }

    public CloudCachePolicy getCloudCachePolicy() {
        return CloudCachePolicy.fromName(this.accessor.getString(Option.CLOUD_STORAGE_CACHE_POLICY));
    }

    public long getProfilerLogInterval() {
        long interval = TimeUnit.MINUTES.toNanos(this.accessor.getInt(Option.CLOUD_PROFILER_LOG_INTERVAL));
        return interval == 0L ? 0L : Math.max(interval, TimeUnit.MINUTES.toNanos(1L));
    }

    public static enum Option implements IOption
    {
        CLOUD_STORAGE_SCHEME(OptionTypes.STRING, ""),
        CLOUD_STORAGE_BUCKET(OptionTypes.STRING, ""),
        CLOUD_STORAGE_PREFIX(OptionTypes.STRING, ""),
        CLOUD_STORAGE_REGION(OptionTypes.STRING, ""),
        CLOUD_STORAGE_ENDPOINT(OptionTypes.STRING, ""),
        CLOUD_STORAGE_ANONYMOUS_AUTH(OptionTypes.BOOLEAN, false),
        CLOUD_STORAGE_CACHE_POLICY(OptionTypes.STRING, "lazy"),
        CLOUD_PROFILER_LOG_INTERVAL(OptionTypes.NONNEGATIVE_INTEGER, 0);

        private final IOptionType interpreter;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> interpreter, T defaultValue) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValue;
        }

        public Section section() {
            switch (this) {
                case CLOUD_STORAGE_SCHEME: 
                case CLOUD_STORAGE_BUCKET: 
                case CLOUD_STORAGE_PREFIX: 
                case CLOUD_STORAGE_REGION: 
                case CLOUD_STORAGE_ENDPOINT: 
                case CLOUD_STORAGE_ANONYMOUS_AUTH: 
                case CLOUD_STORAGE_CACHE_POLICY: 
                case CLOUD_PROFILER_LOG_INTERVAL: {
                    return Section.COMMON;
                }
            }
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case CLOUD_STORAGE_SCHEME: {
                    return "The cloud storage scheme e.g. (s3)";
                }
                case CLOUD_STORAGE_BUCKET: {
                    return "The cloud storage bucket name";
                }
                case CLOUD_STORAGE_PREFIX: {
                    return "The cloud storage path prefix";
                }
                case CLOUD_STORAGE_REGION: {
                    return "The cloud storage region";
                }
                case CLOUD_STORAGE_ENDPOINT: {
                    return "The cloud storage endpoint";
                }
                case CLOUD_STORAGE_ANONYMOUS_AUTH: {
                    return "Indicates whether or not anonymous auth should be used for the cloud storage";
                }
                case CLOUD_STORAGE_CACHE_POLICY: {
                    return "The caching policy (either eager or lazy). 'Eager' caching will download all partitions upon booting, whereas lazy caching will download a file upon request to open it. (default: 'lazy')";
                }
                case CLOUD_PROFILER_LOG_INTERVAL: {
                    return "The waiting time (in minutes) to log cloud request statistics (default: 0, which means the profiler is disabled by default). The minimum is 1 minute. NOTE: Enabling the profiler could perturb the performance of cloud requests";
                }
            }
            throw new IllegalStateException("NYI: " + this);
        }

        public IOptionType type() {
            return this.interpreter;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

