/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.FixedListLazyVisitablePointable;
import org.apache.asterix.om.lazy.FlatLazyVisitablePointable;
import org.apache.asterix.om.lazy.TypedRecordLazyVisitablePointable;
import org.apache.asterix.om.lazy.VariableListLazyVisitablePointable;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public abstract class AbstractLazyNestedVisitablePointable
extends AbstractLazyVisitablePointable {
    private final ATypeTag typeTag;
    protected final VoidPointable currentValue;
    protected byte currentChildTypeTag;

    AbstractLazyNestedVisitablePointable(boolean tagged, ATypeTag typeTag) {
        super(tagged);
        this.typeTag = typeTag;
        this.currentValue = new VoidPointable();
    }

    public abstract void nextChild() throws HyracksDataException;

    public abstract boolean isTaggedChild();

    public abstract int getNumberOfChildren();

    public abstract AbstractLazyVisitablePointable getChildVisitablePointable() throws HyracksDataException;

    public final IValueReference getChildValue() {
        return this.currentValue;
    }

    public final byte getChildSerializedTypeTag() {
        return this.currentChildTypeTag;
    }

    public final ATypeTag getChildTypeTag() {
        return ATypeTag.VALUE_TYPE_MAPPING[this.currentChildTypeTag];
    }

    @Override
    public final ATypeTag getTypeTag() {
        return ATypeTag.VALUE_TYPE_MAPPING[this.getSerializedTypeTag()];
    }

    @Override
    public final byte getSerializedTypeTag() {
        return this.typeTag.serialize();
    }

    static AbstractLazyVisitablePointable createVisitable(IAType type) {
        IAType actualType = TypeComputeUtils.getActualType(type);
        ATypeTag typeTag = actualType.getTypeTag();
        switch (typeTag) {
            case OBJECT: {
                return new TypedRecordLazyVisitablePointable(false, (ARecordType)actualType);
            }
            case ARRAY: 
            case MULTISET: {
                AbstractCollectionType listType = (AbstractCollectionType)actualType;
                return NonTaggedFormatUtil.isFixedSizedCollection(listType.getItemType()) ? new FixedListLazyVisitablePointable(false, listType) : new VariableListLazyVisitablePointable(false, listType);
            }
        }
        return new FlatLazyVisitablePointable(false, typeTag);
    }
}

