/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.APoint;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;

public class ACircleSerializerDeserializer
implements ISerializerDeserializer<ACircle> {
    private static final long serialVersionUID = 1L;
    public static final ACircleSerializerDeserializer INSTANCE = new ACircleSerializerDeserializer();

    private ACircleSerializerDeserializer() {
    }

    public ACircle deserialize(DataInput in) throws HyracksDataException {
        APoint center = APointSerializerDeserializer.read(in);
        double radius = DoubleSerializerDeserializer.read((DataInput)in);
        return new ACircle(center, radius);
    }

    public void serialize(ACircle instance, DataOutput out) throws HyracksDataException {
        APointSerializerDeserializer.write(instance.getP(), out);
        DoubleSerializerDeserializer.write((double)instance.getRadius(), (DataOutput)out);
    }

    public static final int getCenterPointCoordinateOffset(Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 0;
            }
            case Y: {
                return 8;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }

    public static final int getRadiusOffset() throws HyracksDataException {
        return 16;
    }
}

