/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader.value.key;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnKeyValueReader;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;

public final class StringKeyValueReader
extends AbstractValueReader
implements IColumnKeyValueReader {
    private final IPointable value = new VoidPointable();
    private ByteBuffer buffer;
    private int startOffset;
    private int tupleCount;

    @Override
    public void init(AbstractBytesInputStream in, int tupleCount) throws IOException {
        this.buffer = in.getBuffer();
        this.startOffset = this.buffer.position();
        this.tupleCount = tupleCount;
        this.value.set(null, 0, 0);
    }

    @Override
    public int reset(int startIndex, int skipCount) {
        this.getValue(startIndex);
        return 0;
    }

    @Override
    public IValueReference getValue(int index) {
        byte[] bytes = this.buffer.array();
        int indexOffset = this.startOffset + index * 4;
        int valueOffset = this.startOffset + this.tupleCount * 4 + IntegerPointable.getInteger((byte[])bytes, (int)indexOffset);
        int valueLength = UTF8StringUtil.getUTFLength((byte[])bytes, (int)valueOffset);
        valueLength += UTF8StringUtil.getNumBytesToStoreLength((int)valueLength);
        this.value.set(bytes, valueOffset, valueLength);
        return this.value;
    }

    @Override
    public IValueReference getBytes() {
        return this.value;
    }

    @Override
    public void nextValue() {
        if (this.value.getByteArray() == null) {
            this.getValue(0);
            return;
        }
        int offset = this.value.getStartOffset() + this.value.getLength();
        int length = UTF8StringUtil.getUTFLength((byte[])this.buffer.array(), (int)offset);
        length += UTF8StringUtil.getNumBytesToStoreLength((int)length);
        this.value.set(this.buffer.array(), offset, length);
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.STRING;
    }

    @Override
    public int compareTo(AbstractValueReader o) {
        return UTF8StringPointable.compare((IValueReference)this.getBytes(), (IValueReference)o.getBytes());
    }
}

