/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.column.assembler.AbstractPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.AssemblerBuilderVisitor;
import org.apache.asterix.column.assembler.AssemblerState;
import org.apache.asterix.column.assembler.ObjectValueAssembler;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.operation.query.QueryColumnMetadata;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

public final class ColumnAssembler {
    private final AbstractPrimitiveValueAssembler[] assemblers;
    private final ObjectValueAssembler rootAssembler;
    private final AssemblerState state;
    private int numberOfTuples;
    private int tupleIndex;
    private int numberOfSkips;

    public ColumnAssembler(AbstractSchemaNode node, ARecordType declaredType, QueryColumnMetadata columnMetadata, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory) throws HyracksDataException {
        AssemblerBuilderVisitor builderVisitor = new AssemblerBuilderVisitor(columnMetadata, readerFactory, valueGetterFactory);
        this.assemblers = builderVisitor.createValueAssemblers(node, declaredType);
        this.rootAssembler = (ObjectValueAssembler)builderVisitor.getRootAssembler();
        this.state = new AssemblerState();
    }

    public void reset(int numberOfTuples) {
        this.numberOfTuples = numberOfTuples;
        this.tupleIndex = 0;
        this.numberOfSkips = 0;
    }

    public void resetColumn(AbstractBytesInputStream stream, int ordinal) throws HyracksDataException {
        this.assemblers[ordinal].reset(stream, this.numberOfTuples);
    }

    public int getColumnIndex(int ordinal) {
        return this.assemblers[ordinal].getColumnIndex();
    }

    public boolean hasNext() {
        return this.tupleIndex < this.numberOfTuples;
    }

    public IValueReference nextValue() throws HyracksDataException {
        this.rootAssembler.start();
        if (this.tupleIndex == this.numberOfTuples) {
            this.rootAssembler.end();
            return this.rootAssembler.getValue();
        }
        int index = 0;
        while (index < this.assemblers.length) {
            int groupIndex;
            AbstractPrimitiveValueAssembler assembler = this.assemblers[index];
            try {
                groupIndex = assembler.next(this.state);
            }
            catch (ColumnarValueException e) {
                this.appendInformation(e);
                throw e;
            }
            if (groupIndex != -1) {
                index = groupIndex;
                continue;
            }
            ++index;
        }
        ++this.tupleIndex;
        this.rootAssembler.end();
        return this.rootAssembler.getValue();
    }

    public IValueReference getPreviousValue() {
        return this.rootAssembler.getValue();
    }

    public int getNumberOfColumns() {
        return this.assemblers.length;
    }

    public int skip(int count) throws HyracksDataException {
        if (this.numberOfTuples == 0) {
            return 0;
        }
        this.numberOfSkips += count;
        this.tupleIndex += count;
        for (int i = 0; i < this.assemblers.length; ++i) {
            this.assemblers[i].skip(count);
        }
        return this.tupleIndex;
    }

    public void setAt(int index) throws HyracksDataException {
        this.skip(index - this.tupleIndex);
    }

    private void appendInformation(ColumnarValueException e) {
        ObjectNode assemblerNode = e.createNode(this.getClass().getSimpleName());
        assemblerNode.put("tupleIndex", this.tupleIndex);
        assemblerNode.put("numberOfTuples", this.numberOfTuples);
        assemblerNode.put("numberOfSkips", this.numberOfSkips);
        this.state.appendStateInfo(e);
    }
}

