/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.dataflow;

import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.common.IIndexAccessParameters;

public class LSMIndexCompactOperatorNodePushable
extends AbstractOperatorNodePushable {
    private final IIndexDataflowHelper[] indexHelpers;

    public LSMIndexCompactOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[][] partitionsMap) throws HyracksDataException {
        int[] partitions = partitionsMap[partition];
        this.indexHelpers = new IIndexDataflowHelper[partitions.length];
        for (int i = 0; i < partitions.length; ++i) {
            this.indexHelpers[i] = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partitions[i]);
        }
    }

    public void deinitialize() throws HyracksDataException {
        Throwable failure = CleanupUtils.close((AutoCloseable[])this.indexHelpers, null);
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public int getInputArity() {
        return 0;
    }

    public IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    public void initialize() throws HyracksDataException {
        for (IIndexDataflowHelper indexHelper : this.indexHelpers) {
            indexHelper.open();
            ILSMIndex index = (ILSMIndex)indexHelper.getIndexInstance();
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleFullMerge();
        }
    }

    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
    }
}

