/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.IOException;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.util.bytes.HexPrinter;

public class ExternalLibraryUtils {
    private ExternalLibraryUtils() {
    }

    public static String digestToHexString(MessageDigest digest) throws IOException {
        byte[] hashBytes = digest.digest();
        StringWriter hashBuilder = new StringWriter();
        HexPrinter.printHexString((byte[])hashBytes, (int)0, (int)hashBytes.length, (Appendable)hashBuilder);
        return hashBuilder.toString();
    }

    public static Map<Namespace, Map<String, String>> produceLibraryListing(ILibraryManager libraryManager) throws IOException {
        List libs = libraryManager.getLibraryListing();
        TreeMap<Namespace, Map<String, String>> dvToLibHashes = new TreeMap<Namespace, Map<String, String>>();
        for (Pair lib : libs) {
            dvToLibHashes.computeIfAbsent((Namespace)lib.first, h -> new TreeMap()).put((String)lib.getSecond(), libraryManager.getLibraryHash((Namespace)lib.first, (String)lib.second));
        }
        return dvToLibHashes;
    }
}

