/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.library.msgpack.MessagePackUtils;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.aws.s3.S3Utils;
import org.apache.asterix.external.util.azure.blob_storage.AzureUtils;
import org.apache.asterix.external.util.google.gcs.GCSUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.asterix.runtime.projection.ExternalDatasetProjectionFiltrationInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.parsers.BooleanParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.DoubleParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.FloatParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IntegerParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.LongParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.UTF8StringParserFactory;
import org.apache.hyracks.util.StorageUtil;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;

public class ExternalDataUtils {
    private static final Map<ATypeTag, IValueParserFactory> valueParserFactoryMap = new EnumMap<ATypeTag, IValueParserFactory>(ATypeTag.class);
    private static final int DEFAULT_MAX_ARGUMENT_SZ = 0x100000;
    private static final int HEADER_FUDGE = 64;

    private ExternalDataUtils() {
    }

    public static int getOrDefaultBufferSize(Map<String, String> configuration) {
        String bufferSize = configuration.get("external-scan-buffer-size");
        return bufferSize != null ? Integer.parseInt(bufferSize) : ExternalDataConstants.DEFAULT_BUFFER_SIZE;
    }

    public static char validateGetDelimiter(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "delimiter", ",".charAt(0));
    }

    public static char validateGetQuote(Map<String, String> configuration, char delimiter) throws HyracksDataException {
        char quote = ExternalDataUtils.validateCharOrDefault(configuration, "quote", "\"".charAt(0));
        ExternalDataUtils.validateDelimiterAndQuote(delimiter, quote);
        return quote;
    }

    public static char validateGetEscape(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "escape", '\\');
    }

    public static char validateGetRecordStart(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-start", '{');
    }

    public static char validateGetRecordEnd(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-end", '}');
    }

    public static void validateDataParserParameters(Map<String, String> configuration) throws AsterixException {
        String parserFactory;
        String parser = configuration.get("format");
        if (parser == null && (parserFactory = configuration.get("parser-factory")) == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"format or parser-factory"});
        }
    }

    public static void validateDataSourceParameters(Map<String, String> configuration) throws AsterixException {
        String reader = configuration.get("reader");
        if (reader == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"reader"});
        }
    }

    public static IExternalDataSourceFactory.DataSourceType getDataSourceType(Map<String, String> configuration) {
        String reader = configuration.get("reader");
        if (reader != null && reader.equals("stream")) {
            return IExternalDataSourceFactory.DataSourceType.STREAM;
        }
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    public static boolean isExternal(String aString) {
        return aString != null && aString.contains("#") && aString.trim().length() > 1;
    }

    public static String getLibraryName(String aString) {
        return aString.trim().split("#")[0];
    }

    public static String getExternalClassName(String aString) {
        return aString.trim().split("#")[1];
    }

    public static IInputStreamFactory createExternalInputStreamFactory(ILibraryManager libraryManager, Namespace namespace, String stream) throws HyracksDataException {
        try {
            String libraryName = ExternalDataUtils.getLibraryName(stream);
            String className = ExternalDataUtils.getExternalClassName(stream);
            ILibrary lib = libraryManager.getLibrary(namespace, libraryName);
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new HyracksDataException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IInputStreamFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(ErrorCode.UTIL_EXTERNAL_DATA_UTILS_FAIL_CREATE_STREAM_FACTORY, (Throwable)e, new Serializable[0]);
        }
    }

    public static String getDatasetDatabase(Map<String, String> configuration) throws AsterixException {
        return configuration.get("dataset-database");
    }

    public static DataverseName getDatasetDataverse(Map<String, String> configuration) throws AsterixException {
        return DataverseName.createFromCanonicalForm((String)configuration.get("dataset-dataverse"));
    }

    public static String getParserFactory(Map<String, String> configuration) {
        String parserFactory = configuration.get("parser");
        if (parserFactory != null) {
            return parserFactory;
        }
        parserFactory = configuration.get("format");
        return parserFactory != null ? parserFactory : configuration.get("parser-factory");
    }

    public static IValueParserFactory[] getValueParserFactories(ARecordType recordType) {
        int n = recordType.getFieldTypes().length;
        IValueParserFactory[] fieldParserFactories = new IValueParserFactory[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = null;
            if (recordType.getFieldTypes()[i].getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)recordType.getFieldTypes()[i];
                if (!unionType.isUnknownableType()) {
                    throw new NotImplementedException("Non-optional UNION type is not supported.");
                }
                tag = unionType.getActualType().getTypeTag();
            } else {
                tag = recordType.getFieldTypes()[i].getTypeTag();
            }
            if (tag == null) {
                throw new NotImplementedException("Failed to get the type information for field " + i + ".");
            }
            fieldParserFactories[i] = ExternalDataUtils.getParserFactory(tag);
        }
        return fieldParserFactories;
    }

    public static IValueParserFactory getParserFactory(ATypeTag tag) {
        IValueParserFactory vpf = valueParserFactoryMap.get(tag);
        if (vpf == null) {
            throw new NotImplementedException("No value parser factory for fields of type " + tag);
        }
        return vpf;
    }

    public static boolean hasHeader(Map<String, String> configuration) {
        return ExternalDataUtils.isTrue(configuration, "header");
    }

    public static boolean isTrue(Map<String, String> configuration, String key) {
        String value = configuration.get(key);
        return value != null && Boolean.valueOf(value) != false;
    }

    public static IRecordReaderFactory<?> createExternalRecordReaderFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws AsterixException {
        ILibrary lib;
        String readerFactory = configuration.get("reader-factory");
        if (readerFactory == null) {
            throw new AsterixException("to use external reader, the parameter reader-factory must be specified.");
        }
        String[] libraryAndFactory = readerFactory.split("#");
        if (libraryAndFactory.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        String[] dataverseAndLibrary = libraryAndFactory[0].split("\\.");
        if (dataverseAndLibrary.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        DataverseName dataverseName = DataverseName.createSinglePartName((String)dataverseAndLibrary[0]);
        String libraryName = dataverseAndLibrary[1];
        try {
            lib = libraryManager.getLibrary(new Namespace("Default", dataverseName), libraryName);
        }
        catch (HyracksDataException e) {
            throw new AsterixException("Cannot load library", (Throwable)e);
        }
        if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
            throw new AsterixException("Unexpected library language: " + lib.getLanguage());
        }
        ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
        try {
            return (IRecordReaderFactory)classLoader.loadClass(libraryAndFactory[1]).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create record reader factory", (Throwable)e);
        }
    }

    public static IDataParserFactory createExternalParserFactory(ILibraryManager libraryManager, DataverseName dataverse, String parserFactoryName) throws AsterixException {
        try {
            ILibrary lib;
            String library = parserFactoryName.substring(0, parserFactoryName.indexOf("#"));
            try {
                lib = libraryManager.getLibrary(new Namespace("Default", dataverse), library);
            }
            catch (HyracksDataException e) {
                throw new AsterixException("Cannot load library", (Throwable)e);
            }
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new AsterixException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IDataParserFactory)classLoader.loadClass(parserFactoryName.substring(parserFactoryName.indexOf("#") + 1)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create an external parser factory", (Throwable)e);
        }
    }

    public static boolean isFeed(Map<String, String> configuration) {
        if (!configuration.containsKey("is-feed")) {
            return false;
        }
        return Boolean.parseBoolean(configuration.get("is-feed"));
    }

    public static boolean isLogIngestionEvents(Map<String, String> configuration) {
        if (!ExternalDataUtils.isFeed(configuration)) {
            return false;
        }
        if (!configuration.containsKey("log-ingestion-events")) {
            return true;
        }
        return Boolean.parseBoolean(configuration.get("log-ingestion-events"));
    }

    public static void prepareFeed(Map<String, String> configuration, String databaseName, DataverseName dataverseName, String feedName) {
        if (!configuration.containsKey("is-feed")) {
            configuration.put("is-feed", "true");
        }
        configuration.computeIfAbsent("log-ingestion-events", k -> "true");
        configuration.put("dataset-database", databaseName);
        configuration.put("dataset-dataverse", dataverseName.getCanonicalForm());
        configuration.put("feed", feedName);
    }

    public static boolean keepDataSourceOpen(Map<String, String> configuration) {
        if (!configuration.containsKey("wait-for-data")) {
            return true;
        }
        return Boolean.parseBoolean(configuration.get("wait-for-data"));
    }

    public static String getFeedName(Map<String, String> configuration) {
        return configuration.get("feed");
    }

    public static boolean isRecordWithMeta(Map<String, String> configuration) {
        return configuration.containsKey("meta-type-name");
    }

    public static void setRecordWithMeta(Map<String, String> configuration, String booleanString) {
        configuration.put("record-with-metadata", booleanString);
    }

    public static boolean isChangeFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("change-feed"));
    }

    public static boolean isInsertFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("insert-feed"));
    }

    public static int getNumberOfKeys(Map<String, String> configuration) throws AsterixException {
        String keyIndexes = configuration.get("key-indexes");
        if (keyIndexes == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"key-indexes"});
        }
        return keyIndexes.split(",").length;
    }

    public static void setNumberOfKeys(Map<String, String> configuration, int value) {
        configuration.put("key-size", String.valueOf(value));
    }

    public static void setChangeFeed(Map<String, String> configuration, String booleanString) {
        configuration.put("change-feed", booleanString);
    }

    public static int[] getPKIndexes(Map<String, String> configuration) {
        String keyIndexes = configuration.get("key-indexes");
        String[] stringIndexes = keyIndexes.split(",");
        int[] intIndexes = new int[stringIndexes.length];
        for (int i = 0; i < stringIndexes.length; ++i) {
            intIndexes[i] = Integer.parseInt(stringIndexes[i]);
        }
        return intIndexes;
    }

    public static int[] getPKSourceIndicators(Map<String, String> configuration) {
        String keyIndicators = configuration.get("key-indicators");
        String[] stringIndicators = keyIndicators.split(",");
        int[] intIndicators = new int[stringIndicators.length];
        for (int i = 0; i < stringIndicators.length; ++i) {
            intIndicators[i] = Integer.parseInt(stringIndicators[i]);
        }
        return intIndicators;
    }

    public static void defaultConfiguration(Map<String, String> configuration) {
        String format = configuration.get("format");
        if (format != null) {
            if (format.equals("csv")) {
                configuration.putIfAbsent("delimiter", ",");
                configuration.putIfAbsent("quote", "\"");
                configuration.putIfAbsent("escape", "\"");
            } else if (format.equals("tsv")) {
                configuration.putIfAbsent("delimiter", "\t");
                configuration.putIfAbsent("quote", "\u0000");
                configuration.putIfAbsent("escape", "\u0000");
            }
        }
    }

    public static void prepare(String adapterName, Map<String, String> configuration) throws AlgebricksException {
        String inputFormat;
        if (!configuration.containsKey("reader")) {
            configuration.put("reader", adapterName);
        }
        if ("parquet-input-format".equals(inputFormat = configuration.get("input-format"))) {
            configuration.put("parser", "noop");
            configuration.put("format", "parquet");
        }
        if (!configuration.containsKey("parser") && configuration.containsKey("format")) {
            configuration.put("parser", configuration.get("format"));
        }
        if (configuration.containsKey("table-format")) {
            ExternalDataUtils.prepareTableFormat(configuration);
        }
    }

    public static void prepareTableFormat(Map<String, String> configuration) throws AlgebricksException {
        block16: {
            if (configuration.get("table-format").equals("apache-iceberg")) {
                Configuration conf = new Configuration();
                Object metadata_path = configuration.get("metadata-path");
                if (configuration.get("reader").equals("S3")) {
                    conf.set("fs.s3a.access.key", configuration.get("accessKeyId"));
                    conf.set("fs.s3a.secret.key", configuration.get("secretAccessKey"));
                    metadata_path = "s3a://" + configuration.get("container") + "/" + configuration.get("definition");
                } else if (configuration.get("reader").equals("hdfs")) {
                    conf.set("fs.defaultFS", configuration.get("hdfs"));
                    metadata_path = configuration.get("hdfs") + "/" + (String)metadata_path;
                }
                HadoopTables tables = new HadoopTables(conf);
                Table icebergTable = tables.load((String)metadata_path);
                if (icebergTable instanceof BaseTable) {
                    BaseTable baseTable = (BaseTable)icebergTable;
                    if (baseTable.operations().current().formatVersion() != 1) {
                        throw new AsterixException(ErrorCode.UNSUPPORTED_ICEBERG_FORMAT_VERSION, new Serializable[]{"AsterixDB only supports Iceberg version up to 1"});
                    }
                    try (CloseableIterable fileScanTasks = baseTable.newScan().planFiles();){
                        StringBuilder builder = new StringBuilder();
                        for (FileScanTask task : fileScanTasks) {
                            builder.append(",");
                            String path = ((DataFile)task.file()).path().toString();
                            builder.append(path);
                        }
                        if (builder.length() > 0) {
                            builder.deleteCharAt(0);
                        }
                        configuration.put("path", builder.toString());
                        break block16;
                    }
                    catch (IOException e) {
                        throw new AsterixException(ErrorCode.ERROR_READING_ICEBERG_METADATA, (Throwable)e, new Serializable[0]);
                    }
                }
                throw new AsterixException(ErrorCode.UNSUPPORTED_ICEBERG_TABLE, new Serializable[]{"Invalid iceberg base table. Please remove metadata specifiers"});
            }
        }
    }

    public static void normalize(Map<String, String> configuration) {
        String lowerCaseFormat;
        String paramValue = configuration.get("format");
        if (paramValue != null && ExternalDataConstants.ALL_FORMATS.contains(lowerCaseFormat = paramValue.toLowerCase().trim())) {
            configuration.put("format", lowerCaseFormat);
        }
        ExternalDataUtils.putToLowerIfExists(configuration, "header");
        ExternalDataUtils.putToLowerIfExists(configuration, "redact-warnings");
    }

    public static void validate(Map<String, String> configuration) throws HyracksDataException {
        String format = configuration.get("format");
        String header = configuration.get("header");
        if (format != null && ExternalDataUtils.isHeaderRequiredFor(format) && header == null) {
            throw new RuntimeDataException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"header"});
        }
        if (header != null && !ExternalDataUtils.isBoolean(header)) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{"header", header});
        }
        char delimiter = ExternalDataUtils.validateGetDelimiter(configuration);
        ExternalDataUtils.validateGetQuote(configuration, delimiter);
        ExternalDataUtils.validateGetEscape(configuration);
        String value = configuration.get("redact-warnings");
        if (value != null && !ExternalDataUtils.isBoolean(value)) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{"redact-warnings", value});
        }
    }

    private static boolean isHeaderRequiredFor(String format) {
        return format.equals("csv") || format.equals("tsv");
    }

    private static boolean isBoolean(String value) {
        return value.equals("true") || value.equals("false");
    }

    private static void validateDelimiterAndQuote(char delimiter, char quote) throws RuntimeDataException {
        if (quote == delimiter) {
            throw new RuntimeDataException(ErrorCode.QUOTE_DELIMITER_MISMATCH, new Serializable[]{Character.valueOf(quote), Character.valueOf(delimiter)});
        }
    }

    private static char validateCharOrDefault(Map<String, String> configuration, String key, char defaultValue) throws HyracksDataException {
        String value = configuration.get(key);
        if (value == null) {
            return defaultValue;
        }
        ExternalDataUtils.validateChar(value, key);
        return value.charAt(0);
    }

    public static void validateChar(String parameterValue, String parameterName) throws RuntimeDataException {
        if (parameterValue.length() != 1) {
            throw new RuntimeDataException(ErrorCode.INVALID_CHAR_LENGTH, new Serializable[]{parameterValue, parameterName});
        }
    }

    private static void putToLowerIfExists(Map<String, String> configuration, String key) {
        String paramValue = configuration.get(key);
        if (paramValue != null) {
            configuration.put(key, paramValue.toLowerCase().trim());
        }
    }

    public static void validateAdapterSpecificProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
        String type;
        switch (type = configuration.get("type")) {
            case "S3": {
                S3Utils.validateProperties(configuration, srcLoc, collector);
                break;
            }
            case "AZUREBLOB": {
                AzureUtils.validateAzureBlobProperties(configuration, srcLoc, collector, appCtx);
                break;
            }
            case "AZUREDATALAKE": {
                AzureUtils.validateAzureDataLakeProperties(configuration, srcLoc, collector, appCtx);
                break;
            }
            case "GCS": {
                GCSUtils.validateProperties(configuration, srcLoc, collector);
                break;
            }
        }
    }

    public static boolean matchPatterns(List<Matcher> matchers, String path) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(path).matches()) continue;
            return true;
        }
        return false;
    }

    public static String patternToRegex(String pattern) {
        int charPosition = 0;
        int patternLength = pattern.length();
        StringBuilder stuffBuilder = new StringBuilder();
        StringBuilder result = new StringBuilder();
        block5: while (charPosition < patternLength) {
            char c = pattern.charAt(charPosition);
            ++charPosition;
            switch (c) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '[': {
                    int closingBracketPosition = charPosition;
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == '!') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == ']') {
                        ++closingBracketPosition;
                    }
                    while (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) != ']') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition >= patternLength) {
                        result.append("\\[");
                        continue block5;
                    }
                    String stuff = pattern.substring(charPosition, closingBracketPosition);
                    stuffBuilder.setLength(0);
                    int stuffCharPos = 0;
                    if (stuff.charAt(0) == '!') {
                        stuffBuilder.append('^');
                        ++stuffCharPos;
                    }
                    while (stuffCharPos < stuff.length()) {
                        char stuffChar = stuff.charAt(stuffCharPos);
                        if (stuffChar != '-' && Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, stuffChar) >= 0) {
                            stuffBuilder.append("\\");
                        }
                        stuffBuilder.append(stuffChar);
                        ++stuffCharPos;
                    }
                    String stuffEscaped = stuffBuilder.toString();
                    stuffEscaped = stuffEscaped.replace("&&", "\\&\\&").replace("~~", "\\~\\~").replace("||", "\\|\\|").replace("--", "\\-\\-");
                    result.append("[").append(stuffEscaped).append("]");
                    charPosition = closingBracketPosition + 1;
                    continue block5;
                }
            }
            if (Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, c) >= 0) {
                result.append("\\");
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String getPrefix(Map<String, String> configuration) {
        return ExternalDataUtils.getPrefix(configuration, true);
    }

    public static String getPrefix(Map<String, String> configuration, boolean appendSlash) {
        boolean hasSubPath;
        String root = configuration.get("prefix-root");
        Object definition = configuration.get("definition");
        String subPath = configuration.get("subpath");
        boolean hasRoot = root != null;
        boolean hasDefinition = definition != null && !((String)definition).isEmpty();
        boolean bl = hasSubPath = subPath != null && !subPath.isEmpty();
        if (hasRoot && hasDefinition && !root.equals(definition)) {
            return ExternalDataUtils.appendSlash(root, appendSlash);
        }
        if (hasDefinition && !hasSubPath) {
            return ExternalDataUtils.appendSlash((String)definition, appendSlash);
        }
        Object fullPath = "";
        if (hasSubPath) {
            if (!hasDefinition) {
                fullPath = subPath.startsWith("/") ? subPath.substring(1) : subPath;
            } else {
                if (((String)definition).endsWith("/") && subPath.startsWith("/")) {
                    subPath = subPath.substring(1);
                } else if (!((String)definition).endsWith("/") && !subPath.startsWith("/")) {
                    definition = (String)definition + "/";
                }
                fullPath = (String)definition + subPath;
            }
            fullPath = ExternalDataUtils.appendSlash((String)fullPath, appendSlash);
        }
        return fullPath;
    }

    public static String appendSlash(String string, boolean appendSlash) {
        return appendSlash && !string.isEmpty() ? string + (!string.endsWith("/") ? "/" : "") : string;
    }

    public static void validateIncludeExclude(Map<String, String> configuration) throws CompilationException {
        ArrayList<Map.Entry<String, String>> includes = new ArrayList<Map.Entry<String, String>>();
        ArrayList<Map.Entry<String, String>> excludes = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String key = entry.getKey();
            if (key.equals("include")) {
                includes.add(entry);
                continue;
            }
            if (key.equals("exclude")) {
                excludes.add(entry);
                continue;
            }
            if (!key.startsWith("include") && !key.startsWith("exclude")) continue;
            String[] splits = key.split("#");
            if (key.startsWith("include") && splits.length == 2 && splits[0].equals("include") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                includes.add(entry);
                continue;
            }
            if (key.startsWith("exclude") && splits.length == 2 && splits[0].equals("exclude") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                excludes.add(entry);
                continue;
            }
            throw new CompilationException(ErrorCode.INVALID_PROPERTY_FORMAT, new Serializable[]{key});
        }
        if (!includes.isEmpty() && !excludes.isEmpty()) {
            throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"include", "exclude"});
        }
    }

    public static AbstractExternalInputStreamFactory.IncludeExcludeMatcher getIncludeExcludeMatchers(Map<String, String> configuration) throws CompilationException {
        ExternalDataUtils.validateIncludeExclude(configuration);
        ArrayList<Matcher> includeMatchers = new ArrayList<Matcher>();
        ArrayList<Matcher> excludeMatchers = new ArrayList<Matcher>();
        String pattern = null;
        try {
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                if (entry.getKey().startsWith("include")) {
                    pattern = entry.getValue();
                    includeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
                    continue;
                }
                if (!entry.getKey().startsWith("exclude")) continue;
                pattern = entry.getValue();
                excludeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new CompilationException(ErrorCode.INVALID_REGEX_PATTERN, new Serializable[]{pattern});
        }
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = !includeMatchers.isEmpty() ? new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(includeMatchers, (matchers1, key) -> ExternalDataUtils.matchPatterns(matchers1, key)) : (!excludeMatchers.isEmpty() ? new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(excludeMatchers, (matchers1, key) -> !ExternalDataUtils.matchPatterns(matchers1, key)) : new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(Collections.emptyList(), (matchers1, key) -> true));
        return includeExcludeMatcher;
    }

    public static boolean supportsPushdown(Map<String, String> properties) {
        return ExternalDataUtils.isParquetFormat(properties);
    }

    public static void validateParquetTypeAndConfiguration(Map<String, String> properties, ARecordType datasetRecordType) throws CompilationException {
        if (ExternalDataUtils.isParquetFormat(properties)) {
            if (datasetRecordType.getFieldTypes().length != 0) {
                throw new CompilationException(ErrorCode.UNSUPPORTED_TYPE_FOR_PARQUET, new Serializable[]{datasetRecordType.getTypeName()});
            }
            if (properties.containsKey("timezone") && !ExternalDataConstants.ParquetOptions.VALID_TIME_ZONES.contains(properties.get("timezone"))) {
                throw new CompilationException(ErrorCode.INVALID_TIMEZONE, new Serializable[]{(Serializable)((Object)properties.get("timezone"))});
            }
        }
    }

    public static boolean isParquetFormat(Map<String, String> properties) {
        String inputFormat = properties.get("input-format");
        return "org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat".equals(inputFormat) || "parquet-input-format".equals(inputFormat) || "parquet".equals(properties.get("format"));
    }

    public static void setExternalDataProjectionInfo(ExternalDatasetProjectionFiltrationInfo projectionInfo, Map<String, String> properties) throws IOException {
        properties.put("requested-fields", ExternalDataUtils.serializeExpectedTypeToString(projectionInfo.getProjectedType()));
        properties.put("org.apache.asterix.function.info", ExternalDataUtils.serializeFunctionCallInfoToString(projectionInfo.getFunctionCallInfoMap()));
    }

    private static String serializeExpectedTypeToString(ARecordType expectedType) throws IOException {
        if (expectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE || expectedType == ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            return expectedType.getTypeName();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        ExternalDatasetProjectionFiltrationInfo.writeTypeField((ARecordType)expectedType, (DataOutput)dataOutputStream);
        return encoder.encodeToString(byteArrayOutputStream.toByteArray());
    }

    static String serializeFunctionCallInfoToString(Map<String, FunctionCallInformation> functionCallInfoMap) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        ExternalDatasetProjectionFiltrationInfo.writeFunctionCallInformationMapField(functionCallInfoMap, (DataOutput)dataOutputStream);
        return encoder.encodeToString(byteArrayOutputStream.toByteArray());
    }

    public static int roundUpToNearestFrameSize(int size, int framesize) {
        return (size / framesize + 1) * framesize;
    }

    public static int getArgBufferSize() {
        long parsedSize;
        int maxArgSz = 0x100040;
        String userArgSz = System.getProperty("udf.buf.size");
        if (userArgSz != null && (parsedSize = StorageUtil.getByteValue((String)userArgSz) + 64L) < Integer.MAX_VALUE && parsedSize > 0L) {
            maxArgSz = (int)parsedSize;
        }
        return maxArgSz;
    }

    public static Optional<String> getFirstNotNull(Map<String, String> configuration, String ... parameters) {
        return Arrays.stream(parameters).filter(field -> configuration.get(field) != null).findFirst();
    }

    public static ATypeTag peekArgument(IAType type, IValueReference valueReference, TaggedValuePointable pointy) throws HyracksDataException {
        ATypeTag tag = type.getTypeTag();
        if (tag == ATypeTag.ANY) {
            pointy.set(valueReference);
            ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(pointy.getTag());
            IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
            return MessagePackUtils.peekUnknown(rtType);
        }
        return MessagePackUtils.peekUnknown(type);
    }

    public static void setVoidArgument(ArrayBackedValueStorage argHolder) throws IOException {
        argHolder.getDataOutput().writeByte(-36);
        argHolder.getDataOutput().writeShort(0);
    }

    public static boolean evaluate(String key, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        return !key.endsWith("/") && predicate.test(matchers, key) && externalDataPrefix.evaluate(key, evaluator, warningCollector);
    }

    public static String getDefinitionOrPath(Map<String, String> configuration) {
        return configuration.getOrDefault("definition", configuration.get("path"));
    }

    public static String getProtocolContainerPair(Map<String, String> configurations) {
        String protocol;
        String type;
        String container = configurations.getOrDefault("container", "");
        switch (type = configurations.getOrDefault("type", "")) {
            case "S3": {
                protocol = "s3a";
                break;
            }
            case "AZUREBLOB": {
                protocol = "wasbs";
                break;
            }
            case "AZUREDATALAKE": {
                protocol = "abfss";
                break;
            }
            case "GCS": {
                protocol = "gs";
                break;
            }
            case "localfs": {
                String path = ExternalDataUtils.getDefinitionOrPath(configurations);
                String[] nodePathPair = path.trim().split("://");
                protocol = nodePathPair[0];
                break;
            }
            case "hdfs": {
                protocol = "hdfs";
                break;
            }
            default: {
                return "";
            }
        }
        return protocol + "://" + container + "/";
    }

    public static void validateType(Map<String, String> properties, ARecordType itemType) throws CompilationException {
        boolean embedValues = Boolean.parseBoolean(properties.getOrDefault("embed-filter-values", "false"));
        if (ExternalDataPrefix.containsComputedFields(properties) && embedValues && !itemType.isOpen()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"A closed type cannot be used when 'embed-filter-values' is enabled"});
        }
    }

    public static String getPathKey(String adapter) {
        String normalizedAdapter;
        switch (normalizedAdapter = adapter.toUpperCase()) {
            case "S3": 
            case "AZUREBLOB": 
            case "AZUREDATALAKE": 
            case "GCS": {
                return "definition";
            }
        }
        return "path";
    }

    static {
        valueParserFactoryMap.put(ATypeTag.INTEGER, IntegerParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.FLOAT, FloatParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.DOUBLE, DoubleParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BIGINT, LongParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.STRING, UTF8StringParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BOOLEAN, BooleanParserFactory.INSTANCE);
    }
}

