/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractStreamRecordReader<T>
implements IRecordReader<T> {
    private Supplier<String> dataSourceName = ExternalDataConstants.EMPTY_STRING;
    private Supplier<String> previousDataSourceName = ExternalDataConstants.EMPTY_STRING;

    protected final void setSuppliers(Map<String, String> config, Supplier<String> dataSourceName, Supplier<String> previousDataSourceName) {
        if (!ExternalDataUtils.isTrue(config, "redact-warnings")) {
            this.dataSourceName = dataSourceName;
            this.previousDataSourceName = previousDataSourceName;
        }
    }

    @Override
    public final Supplier<String> getDataSourceName() {
        return this.dataSourceName;
    }

    protected final String getPreviousStreamName() {
        return this.previousDataSourceName.get();
    }

    public abstract List<String> getRecordReaderFormats();

    public abstract void configure(IHyracksTaskContext var1, AsterixInputStream var2, Map<String, String> var3) throws HyracksDataException;
}

