/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.gcs.parquet;

import com.google.cloud.storage.Blob;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.HDFSDataSourceFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.google.gcs.GCSUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class GCSParquetReaderFactory
extends HDFSDataSourceFactory {
    private static final long serialVersionUID = -6140824803254158253L;
    private static final List<String> recordReaderNames = Collections.singletonList("GCS");

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException, HyracksDataException {
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        IExternalFilterEvaluator evaluator = filterEvaluatorFactory.create(serviceCtx, warningCollector);
        ExternalDataPrefix externalDataPrefix = new ExternalDataPrefix(configuration);
        configuration.put("prefix-root", externalDataPrefix.getRoot());
        String container = configuration.get("container");
        List<Blob> filesOnly = GCSUtils.listItems(configuration, includeExcludeMatcher, warningCollector, externalDataPrefix, evaluator);
        String path = GCSParquetReaderFactory.buildPathURIs(container, filesOnly);
        GCSParquetReaderFactory.putGCSConfToHadoopConf(configuration, path);
        JobConf conf = this.prepareHDFSConf(serviceCtx, configuration, filterEvaluatorFactory);
        int numberOfPartitions = this.getPartitionConstraint().getLocations().length;
        GCSUtils.configureHdfsJobConf(conf, configuration, numberOfPartitions);
        this.configureHdfsConf(conf, configuration);
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public Set<String> getReaderSupportedFormats() {
        return Collections.singleton("parquet");
    }

    private static void putGCSConfToHadoopConf(Map<String, String> configuration, String path) {
        configuration.put("path", path);
        configuration.put("input-format", "parquet-input-format");
        configuration.put("parser", "noop");
    }

    private static String buildPathURIs(String container, List<Blob> filesOnly) {
        StringBuilder builder = new StringBuilder();
        if (!filesOnly.isEmpty()) {
            GCSParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(0));
            for (int i = 1; i < filesOnly.size(); ++i) {
                builder.append(',');
                GCSParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(i));
            }
        }
        return builder.toString();
    }

    private static void appendFileURI(StringBuilder builder, String container, Blob file) {
        builder.append("gs");
        builder.append("://");
        builder.append(container);
        builder.append('/');
        builder.append(file.getName());
    }
}

