/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.filter;

import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.external.input.filter.IExternalFilterValueEvaluator;
import org.apache.asterix.external.input.filter.NoOpExternalFilterValueEvaluator;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;

class ExternalFilterEvaluator
implements IExternalFilterEvaluator {
    private final IScalarEvaluator evaluator;
    private final IExternalFilterValueEvaluator[] valueEvaluators;
    private final VoidPointable booleanResult;

    ExternalFilterEvaluator(IScalarEvaluator evaluator, IExternalFilterValueEvaluator[] valueEvaluators) {
        this.evaluator = evaluator;
        this.valueEvaluators = valueEvaluators;
        this.booleanResult = new VoidPointable();
    }

    public boolean isEmpty() {
        return this.valueEvaluators.length == 0;
    }

    public boolean isComputedFieldUsed(int index) {
        return this.valueEvaluators[index] != NoOpExternalFilterValueEvaluator.INSTANCE;
    }

    public void setValue(int index, String stringValue) throws HyracksDataException {
        this.valueEvaluators[index].setValue(stringValue);
    }

    public boolean evaluate() throws HyracksDataException {
        this.evaluator.evaluate(null, (IPointable)this.booleanResult);
        return BinaryBooleanInspector.getBooleanValue((byte[])this.booleanResult.getByteArray(), (int)this.booleanResult.getStartOffset(), (int)this.booleanResult.getLength());
    }
}

