/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.DatasetEntity;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class InternalDatasetDetails
implements IDatasetDetails {
    private static final long serialVersionUID = 1L;
    private final FileStructure fileStructure;
    private final PartitioningStrategy partitioningStrategy;
    private final List<List<String>> partitioningKeys;
    private final List<List<String>> primaryKeys;
    private final List<IAType> primaryKeyTypes;
    private final boolean autogenerated;
    private final Integer filterSourceIndicator;
    private final List<String> filterField;
    private final List<Integer> keySourceIndicators;
    private final boolean isDatasetWithoutTypeSpecification;
    public static final String FILTER_FIELD_NAME = "FilterField";
    public static final String FILTER_SOURCE_INDICATOR_FIELD_NAME = "FilterSourceIndicator";
    public static final String KEY_FILD_SOURCE_INDICATOR_FIELD_NAME = "KeySourceIndicator";
    public static final String PRIMARY_KEY_TYPES_FIELD_NAME = "PrimaryKeyTypes";

    public InternalDatasetDetails(FileStructure fileStructure, PartitioningStrategy partitioningStrategy, List<List<String>> partitioningKey, List<List<String>> primaryKey, List<Integer> keyFieldIndicators, List<IAType> primaryKeyType, boolean autogenerated, Integer filterSourceIndicator, List<String> filterField, boolean isDatasetWithoutTypeSpecification) {
        this.fileStructure = fileStructure;
        this.partitioningStrategy = partitioningStrategy;
        this.partitioningKeys = partitioningKey;
        this.primaryKeys = primaryKey;
        if (keyFieldIndicators == null) {
            keyFieldIndicators = new ArrayList<Integer>();
            for (int index = 0; index < partitioningKey.size(); ++index) {
                keyFieldIndicators.add(0);
            }
        }
        this.keySourceIndicators = keyFieldIndicators;
        this.primaryKeyTypes = primaryKeyType;
        this.autogenerated = autogenerated;
        if (filterSourceIndicator != null) {
            this.filterSourceIndicator = filterSourceIndicator;
            this.filterField = Objects.requireNonNull(filterField);
        } else {
            this.filterSourceIndicator = null;
            this.filterField = null;
        }
        this.isDatasetWithoutTypeSpecification = isDatasetWithoutTypeSpecification;
    }

    public InternalDatasetDetails(FileStructure fileStructure, PartitioningStrategy partitioningStrategy, List<List<String>> partitioningKey, List<List<String>> primaryKey, List<Integer> keyFieldIndicators, List<IAType> primaryKeyType, boolean autogenerated, Integer filterSourceIndicator, List<String> filterField) {
        this(fileStructure, partitioningStrategy, partitioningKey, primaryKey, keyFieldIndicators, primaryKeyType, autogenerated, filterSourceIndicator, filterField, false);
    }

    public List<List<String>> getPartitioningKey() {
        return this.partitioningKeys;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public List<List<String>> getPrimaryKey() {
        return this.primaryKeys;
    }

    public List<Integer> getKeySourceIndicator() {
        return this.keySourceIndicators;
    }

    public List<IAType> getPrimaryKeyType() {
        return this.primaryKeyTypes;
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public List<String> getFilterField() {
        return this.filterField;
    }

    public Integer getFilterSourceIndicator() {
        return this.filterSourceIndicator;
    }

    public boolean isDatasetWithoutTypeSpecification() {
        return this.isDatasetWithoutTypeSpecification;
    }

    @Override
    public DatasetConfig.DatasetType getDatasetType() {
        return DatasetConfig.DatasetType.INTERNAL;
    }

    @Override
    public void writeDatasetDetailsRecordType(DataOutput out, DatasetEntity datasetEntity) throws HyracksDataException {
        RecordBuilder internalRecordBuilder = new RecordBuilder();
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        OrderedListBuilder primaryKeyListBuilder = new OrderedListBuilder();
        AOrderedListType stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
        AOrderedListType int8List = new AOrderedListType((IAType)BuiltinType.AINT8, null);
        AOrderedListType heterogeneousList = new AOrderedListType((IAType)BuiltinType.ANY, null);
        internalRecordBuilder.reset(MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        AMutableInt8 aInt8 = new AMutableInt8(0);
        ISerializerDeserializer booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
        fieldValue.reset();
        aString.setValue(this.getFileStructure().toString());
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        internalRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(this.getPartitioningStrategy().toString());
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        internalRecordBuilder.addField(1, (IValueReference)fieldValue);
        primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE.getFieldTypes()[2]));
        for (List<String> field : this.partitioningKeys) {
            listBuilder.reset((AbstractCollectionType)stringList);
            for (String subField : field) {
                itemValue.reset();
                aString.setValue(subField);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            listBuilder.write(itemValue.getDataOutput(), true);
            primaryKeyListBuilder.addItem((IValueReference)itemValue);
        }
        fieldValue.reset();
        primaryKeyListBuilder.write(fieldValue.getDataOutput(), true);
        internalRecordBuilder.addField(2, (IValueReference)fieldValue);
        primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE.getFieldTypes()[3]));
        for (List<String> field : this.primaryKeys) {
            listBuilder.reset((AbstractCollectionType)stringList);
            for (String subField : field) {
                itemValue.reset();
                aString.setValue(subField);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            listBuilder.write(itemValue.getDataOutput(), true);
            primaryKeyListBuilder.addItem((IValueReference)itemValue);
        }
        fieldValue.reset();
        primaryKeyListBuilder.write(fieldValue.getDataOutput(), true);
        internalRecordBuilder.addField(3, (IValueReference)fieldValue);
        fieldValue.reset();
        ABoolean b = this.isAutogenerated() ? ABoolean.TRUE : ABoolean.FALSE;
        booleanSerde.serialize((Object)b, fieldValue.getDataOutput());
        internalRecordBuilder.addField(4, (IValueReference)fieldValue);
        if (this.isDatasetWithoutTypeSpecification && this.primaryKeyTypes != null && !this.primaryKeyTypes.isEmpty()) {
            ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
            nameValue.reset();
            aString.setValue(PRIMARY_KEY_TYPES_FIELD_NAME);
            stringSerde.serialize((Object)aString, nameValue.getDataOutput());
            listBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            for (IAType keyType : this.primaryKeyTypes) {
                itemValue.reset();
                aString.setValue(keyType.getTypeName());
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            listBuilder.write(fieldValue.getDataOutput(), true);
            internalRecordBuilder.addField((IValueReference)nameValue, (IValueReference)fieldValue);
        }
        Integer filterSourceIndicator = this.getFilterSourceIndicator();
        List<String> filterField = this.getFilterField();
        if (filterField != null) {
            ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
            nameValue.reset();
            aString.setValue(FILTER_SOURCE_INDICATOR_FIELD_NAME);
            stringSerde.serialize((Object)aString, nameValue.getDataOutput());
            fieldValue.reset();
            aInt8.setValue(filterSourceIndicator.byteValue());
            int8Serde.serialize((Object)aInt8, fieldValue.getDataOutput());
            internalRecordBuilder.addField((IValueReference)nameValue, (IValueReference)fieldValue);
            listBuilder.reset((AbstractCollectionType)heterogeneousList);
            nameValue.reset();
            aString.setValue(FILTER_FIELD_NAME);
            stringSerde.serialize((Object)aString, nameValue.getDataOutput());
            for (String string : filterField) {
                itemValue.reset();
                aString.setValue(string);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            listBuilder.write(fieldValue.getDataOutput(), true);
            internalRecordBuilder.addField((IValueReference)nameValue, (IValueReference)fieldValue);
        }
        List<Integer> keySourceIndicator = this.getKeySourceIndicator();
        boolean needSerialization = false;
        if (keySourceIndicator != null) {
            for (int source : keySourceIndicator) {
                if (source == 0) continue;
                needSerialization = true;
                break;
            }
        }
        if (needSerialization) {
            listBuilder.reset((AbstractCollectionType)int8List);
            ArrayBackedValueStorage arrayBackedValueStorage = new ArrayBackedValueStorage();
            arrayBackedValueStorage.reset();
            aString.setValue(KEY_FILD_SOURCE_INDICATOR_FIELD_NAME);
            stringSerde.serialize((Object)aString, arrayBackedValueStorage.getDataOutput());
            for (int source : keySourceIndicator) {
                itemValue.reset();
                aInt8.setValue((byte)source);
                int8Serde.serialize((Object)aInt8, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            listBuilder.write(fieldValue.getDataOutput(), true);
            internalRecordBuilder.addField((IValueReference)arrayBackedValueStorage, (IValueReference)fieldValue);
        }
        internalRecordBuilder.write(out, true);
    }

    protected void writePropertyTypeRecord(String name, String value, DataOutput out, ARecordType recordType) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(recordType);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }

    public static enum FileStructure {
        BTREE;

    }

    public static enum PartitioningStrategy {
        HASH;

    }
}

