/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FunctionEntity {
    private static final FunctionEntity FUNCTION = new FunctionEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FUNCTION, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("Name"), List.of("Arity")), 0, FunctionEntity.functionType(), true, new int[]{0, 1, 2}), 3, -1);
    private static final FunctionEntity DB_FUNCTION = new FunctionEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FUNCTION, 5, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("Name"), List.of("Arity")), 0, FunctionEntity.databaseFunctionType(), true, new int[]{0, 1, 2, 3}), 4, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int functionNameIndex;
    private final int functionArityIndex;
    private final int functionParamListIndex;
    private final int functionReturnTypeIndex;
    private final int functionDefinitionIndex;
    private final int functionLanguageIndex;
    private final int functionKindIndex;
    private final int functionDependenciesIndex;

    private FunctionEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.functionNameIndex = startIndex++;
        this.functionArityIndex = startIndex++;
        this.functionParamListIndex = startIndex++;
        this.functionReturnTypeIndex = startIndex++;
        this.functionDefinitionIndex = startIndex++;
        this.functionLanguageIndex = startIndex++;
        this.functionKindIndex = startIndex++;
        this.functionDependenciesIndex = startIndex++;
    }

    public static FunctionEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FUNCTION : FUNCTION;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int functionNameIndex() {
        return this.functionNameIndex;
    }

    public int functionArityIndex() {
        return this.functionArityIndex;
    }

    public int functionParamListIndex() {
        return this.functionParamListIndex;
    }

    public int functionReturnTypeIndex() {
        return this.functionReturnTypeIndex;
    }

    public int functionLanguageIndex() {
        return this.functionLanguageIndex;
    }

    public int functionDefinitionIndex() {
        return this.functionDefinitionIndex;
    }

    public int functionKindIndex() {
        return this.functionKindIndex;
    }

    public int functionDependenciesIndex() {
        return this.functionDependenciesIndex;
    }

    private static ARecordType functionType() {
        return MetadataRecordTypes.createRecordType("FunctionRecordType", new String[]{"DataverseName", "Name", "Arity", "Params", "ReturnType", "Definition", "Language", "Kind", "Dependencies"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)BuiltinType.ASTRING, null), BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null), null)}, true);
    }

    private static ARecordType databaseFunctionType() {
        return MetadataRecordTypes.createRecordType("FunctionRecordType", new String[]{"DatabaseName", "DataverseName", "Name", "Arity", "Params", "ReturnType", "Definition", "Language", "Kind", "Dependencies"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)BuiltinType.ASTRING, null), BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null), null)}, true);
    }
}

