/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.translator;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.algebra.extension.ExtensionStatement;
import org.apache.asterix.api.common.APIFramework;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.active.FeedEventsListener;
import org.apache.asterix.app.external.ExternalLibraryJobUtils;
import org.apache.asterix.app.result.ExecutionError;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.app.result.fields.ErrorsPrinter;
import org.apache.asterix.app.result.fields.ResultHandlePrinter;
import org.apache.asterix.app.result.fields.ResultsPrinter;
import org.apache.asterix.app.result.fields.StatusPrinter;
import org.apache.asterix.column.validation.ColumnPropertiesValidationUtil;
import org.apache.asterix.column.validation.ColumnSupportedTypesValidator;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.ICommonRequestParameters;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.api.IRequestTracker;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.api.ISchedulableClientRequest;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.IGlobalTxManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.exceptions.WarningCollector;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.metadata.IMetadataLockUtil;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.common.utils.StorageConstants;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.WriterValidationUtil;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.IStatementRewriter;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.AdapterDropStatement;
import org.apache.asterix.lang.common.statement.AnalyzeDropStatement;
import org.apache.asterix.lang.common.statement.AnalyzeStatement;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CopyFromStatement;
import org.apache.asterix.lang.common.statement.CopyToStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDatabaseStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextConfigStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextFilterStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.statement.DatabaseDropStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FullTextConfigDropStatement;
import org.apache.asterix.lang.common.statement.FullTextFilterDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LibraryDropStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.SynonymDropStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.statement.ViewDropStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.util.ViewUtil;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.dataset.DatasetFormatInfo;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Database;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.entities.ViewDetails;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.functions.ExternalFunctionCompilerUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.fulltext.AbstractFullTextFilterDescriptor;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;
import org.apache.asterix.runtime.fulltext.StopwordsFullTextFilterDescriptor;
import org.apache.asterix.runtime.operators.DatasetStreamStats;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.asterix.transaction.management.service.transaction.GlobalTxInfo;
import org.apache.asterix.translator.AbstractLangTranslator;
import org.apache.asterix.translator.ClientRequest;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.ExecutionPlansHtmlPrintUtil;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.ResultMetadata;
import org.apache.asterix.translator.SchedulableClientRequest;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.asterix.translator.TypeTranslator;
import org.apache.asterix.translator.util.ValidateUtil;
import org.apache.asterix.utils.DataverseUtil;
import org.apache.asterix.utils.FeedOperations;
import org.apache.asterix.utils.FlushDatasetUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexInsertUpdateDeleteOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryTranslator
extends AbstractLangTranslator
implements IStatementExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean IS_DEBUG_MODE = false;
    protected final List<Statement> statements;
    protected final ICcApplicationContext appCtx;
    protected final SessionOutput sessionOutput;
    protected final SessionConfig sessionConfig;
    protected Namespace activeNamespace;
    protected final List<FunctionDecl> declaredFunctions;
    protected final ILangCompilationProvider compilationProvider;
    protected final APIFramework apiFramework;
    protected final IRewriterFactory rewriterFactory;
    protected final ExecutorService executorService;
    protected final EnumSet<JobFlag> jobFlags = EnumSet.noneOf(JobFlag.class);
    protected final IMetadataLockManager lockManager;
    protected final IMetadataLockUtil lockUtil;
    protected final IResponsePrinter responsePrinter;
    protected final WarningCollector warningCollector;
    protected final ReentrantReadWriteLock compilationLock;
    protected final IGlobalTxManager globalTxManager;
    protected final INamespaceResolver namespaceResolver;

    public QueryTranslator(ICcApplicationContext appCtx, List<Statement> statements, SessionOutput output, ILangCompilationProvider compilationProvider, ExecutorService executorService, IResponsePrinter responsePrinter) {
        this.appCtx = appCtx;
        this.lockManager = appCtx.getMetadataLockManager();
        this.lockUtil = appCtx.getMetadataLockUtil();
        this.statements = statements;
        this.sessionOutput = output;
        this.sessionConfig = output.config();
        this.compilationProvider = compilationProvider;
        this.declaredFunctions = new ArrayList<FunctionDecl>();
        this.apiFramework = new APIFramework(compilationProvider);
        this.rewriterFactory = compilationProvider.getRewriterFactory();
        this.activeNamespace = MetadataBuiltinEntities.DEFAULT_NAMESPACE;
        this.executorService = executorService;
        this.responsePrinter = responsePrinter;
        this.warningCollector = new WarningCollector();
        this.compilationLock = appCtx.getCompilationLock();
        if (appCtx.getServiceContext().getAppConfig().getBoolean((IOption)CCConfig.Option.ENFORCE_FRAME_WRITER_PROTOCOL)) {
            this.jobFlags.add(JobFlag.ENFORCE_CONTRACT);
        }
        this.globalTxManager = appCtx.getGlobalTxManager();
        this.namespaceResolver = appCtx.getNamespaceResolver();
    }

    public SessionOutput getSessionOutput() {
        return this.sessionOutput;
    }

    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndExecute(IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        this.validateStatements(requestParameters);
        this.trackRequest(requestParameters);
        Counter resultSetIdCounter = new Counter(0);
        FileSplit outputFile = null;
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryTranslator.class.getSimpleName() + ":" + requestParameters.getRequestReference().getUuid());
        HashMap<String, String> config = new HashMap<String, String>();
        IResultSet resultSet = requestParameters.getResultSet();
        IStatementExecutor.ResultDelivery resultDelivery = requestParameters.getResultProperties().getDelivery();
        long maxResultReads = requestParameters.getResultProperties().getMaxReads();
        IStatementExecutor.Stats stats = requestParameters.getStats();
        IStatementExecutor.StatementProperties statementProperties = requestParameters.getStatementProperties();
        IStatementExecutor.ResultMetadata outMetadata = requestParameters.getOutMetadata();
        Map stmtParams = requestParameters.getStatementParameters();
        this.warningCollector.setMaxWarnings(this.sessionConfig.getMaxWarnings());
        try {
            block52: for (Statement stmt : this.statements) {
                if (this.sessionConfig.is("format-html")) {
                    this.sessionOutput.out().println("<!-- BEGIN -->");
                }
                this.validateOperation(this.appCtx, this.activeNamespace, stmt);
                MetadataProvider metadataProvider = MetadataProvider.create((ICcApplicationContext)this.appCtx, (Namespace)this.activeNamespace);
                this.configureMetadataProvider(metadataProvider, config, resultSetIdCounter, outputFile, requestParameters, stmt);
                IStatementRewriter stmtRewriter = this.rewriterFactory.createStatementRewriter();
                this.rewriteStatement(stmt, stmtRewriter, metadataProvider);
                Statement.Kind kind = stmt.getKind();
                statementProperties.setKind(kind);
                switch (kind) {
                    case SET: {
                        this.handleSetStatement(stmt, config);
                        continue block52;
                    }
                    case DATAVERSE_DECL: {
                        this.activeNamespace = this.handleUseDataverseStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_DATABASE: {
                        this.handleCreateDatabaseStatement(metadataProvider, stmt, requestParameters);
                        continue block52;
                    }
                    case CREATE_DATAVERSE: {
                        this.handleCreateDataverseStatement(metadataProvider, stmt, requestParameters);
                        continue block52;
                    }
                    case DATASET_DECL: {
                        this.handleCreateDatasetStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case CREATE_INDEX: {
                        this.handleCreateIndexStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case CREATE_FULL_TEXT_FILTER: {
                        this.handleCreateFullTextFilterStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_FULL_TEXT_CONFIG: {
                        this.handleCreateFullTextConfigStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case TYPE_DECL: {
                        this.handleCreateTypeStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case NODEGROUP_DECL: {
                        this.handleCreateNodeGroupStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case DATABASE_DROP: {
                        this.handleDatabaseDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case DATAVERSE_DROP: {
                        this.handleDataverseDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case DATASET_DROP: {
                        this.handleDatasetDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case INDEX_DROP: {
                        this.handleIndexDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case FULL_TEXT_FILTER_DROP: {
                        this.handleFullTextFilterDrop(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case FULL_TEXT_CONFIG_DROP: {
                        this.handleFullTextConfigDrop(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case TYPE_DROP: {
                        this.handleTypeDropStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case NODEGROUP_DROP: {
                        this.handleNodegroupDropStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_ADAPTER: {
                        this.handleCreateAdapterStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case ADAPTER_DROP: {
                        this.handleAdapterDropStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_FUNCTION: {
                        this.handleCreateFunctionStatement(metadataProvider, stmt, stmtRewriter, requestParameters);
                        continue block52;
                    }
                    case FUNCTION_DROP: {
                        this.handleFunctionDropStatement(metadataProvider, stmt, requestParameters);
                        continue block52;
                    }
                    case CREATE_LIBRARY: {
                        this.handleCreateLibraryStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case LIBRARY_DROP: {
                        this.handleLibraryDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case CREATE_SYNONYM: {
                        this.handleCreateSynonymStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case SYNONYM_DROP: {
                        this.handleDropSynonymStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_VIEW: {
                        this.handleCreateViewStatement(metadataProvider, stmt, stmtRewriter, requestParameters);
                        continue block52;
                    }
                    case VIEW_DROP: {
                        this.handleViewDropStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case LOAD: {
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleLoadStatement(metadataProvider, stmt, hcc);
                        continue block52;
                    }
                    case COPY_FROM: {
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleCopyFromStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case COPY_TO: {
                        metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter.getAndInc()));
                        metadataProvider.setMaxResultReads(1L);
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleCopyToStatement(metadataProvider, stmt, hcc, resultSet, resultDelivery, outMetadata, requestParameters, stmtParams, stats);
                        continue block52;
                    }
                    case INSERT: 
                    case UPSERT: {
                        if (((InsertStatement)stmt).getReturnExpression() != null) {
                            metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter.getAndInc()));
                            metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                            metadataProvider.setMaxResultReads(maxResultReads);
                        }
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleInsertUpsertStatement(metadataProvider, stmt, hcc, resultSet, resultDelivery, outMetadata, stats, requestParameters, stmtParams, stmtRewriter);
                        continue block52;
                    }
                    case DELETE: {
                        this.handleDeleteStatement(metadataProvider, stmt, hcc, stmtParams, stmtRewriter, requestParameters);
                        continue block52;
                    }
                    case CREATE_FEED: {
                        this.handleCreateFeedStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case DROP_FEED: {
                        this.handleDropFeedStatement(metadataProvider, stmt, hcc);
                        continue block52;
                    }
                    case DROP_FEED_POLICY: {
                        this.handleDropFeedPolicyStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CONNECT_FEED: {
                        this.handleConnectFeedStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case DISCONNECT_FEED: {
                        this.handleDisconnectFeedStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case START_FEED: {
                        this.handleStartFeedStatement(metadataProvider, stmt, hcc);
                        continue block52;
                    }
                    case STOP_FEED: {
                        this.handleStopFeedStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case CREATE_FEED_POLICY: {
                        this.handleCreateFeedPolicyStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case QUERY: {
                        metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter.getAndInc()));
                        metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                        metadataProvider.setMaxResultReads(maxResultReads);
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleQuery(metadataProvider, (Query)stmt, hcc, resultSet, resultDelivery, outMetadata, stats, requestParameters, stmtParams, stmtRewriter);
                        continue block52;
                    }
                    case ANALYZE: {
                        this.handleAnalyzeStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case ANALYZE_DROP: {
                        this.handleAnalyzeDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block52;
                    }
                    case COMPACT: {
                        this.handleCompactStatement(metadataProvider, stmt, hcc);
                        continue block52;
                    }
                    case FUNCTION_DECL: {
                        this.handleDeclareFunctionStatement(metadataProvider, stmt);
                        continue block52;
                    }
                    case EXTENSION: {
                        ExtensionStatement extStmt = (ExtensionStatement)stmt;
                        statementProperties.setName(extStmt.getName());
                        if (this.isCompileOnly()) continue block52;
                        extStmt.handle(hcc, (IStatementExecutor)this, requestParameters, metadataProvider, resultSetIdCounter.getAndInc());
                        continue block52;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, stmt.getSourceLocation(), new Serializable[]{"Unexpected statement: " + kind});
            }
        }
        finally {
            if (IStatementExecutor.ResultDelivery.ASYNC != resultDelivery) {
                this.appCtx.getRequestTracker().complete(requestParameters.getRequestReference().getUuid());
            }
            Thread.currentThread().setName(threadName);
        }
    }

    protected void configureMetadataProvider(MetadataProvider metadataProvider, Map<String, String> config, Counter resultSetIdCounter, FileSplit outputFile, IRequestParameters requestParameters, Statement statement) {
        if (statement.getKind() == Statement.Kind.QUERY && requestParameters.isSQLCompatMode()) {
            metadataProvider.getConfig().put("sql_compat", Boolean.TRUE.toString());
        }
        metadataProvider.getConfig().putAll(config);
        metadataProvider.setResultSetIdCounter(resultSetIdCounter);
        metadataProvider.setOutputFile(outputFile);
    }

    protected DataverseDecl getRequestDataverseDecl(IRequestParameters requestParameters) throws AlgebricksException {
        String requestDataverseName = requestParameters.getDefaultDataverseName();
        if (requestDataverseName == null) {
            return null;
        }
        Namespace requestNamespace = this.namespaceResolver.resolve(requestDataverseName);
        return new DataverseDecl(requestNamespace, true);
    }

    protected void handleSetStatement(Statement stmt, Map<String, String> config) throws CompilationException {
        SetStatement ss = (SetStatement)stmt;
        String pname = ss.getPropName();
        String pvalue = ss.getPropValue();
        if (pname.startsWith("_internal")) {
            throw new CompilationException(ErrorCode.ILLEGAL_SET_PARAMETER, new Serializable[]{pname});
        }
        config.put(pname, pvalue);
    }

    protected LangRewritingContext createLangRewritingContext(MetadataProvider metadataProvider, List<FunctionDecl> declaredFunctions, List<ViewDecl> declaredViews, IWarningCollector warningCollector, int varCounter) {
        return new LangRewritingContext(metadataProvider, declaredFunctions, declaredViews, warningCollector, varCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Namespace handleUseDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DataverseDecl dvd = (DataverseDecl)stmt;
        DataverseName dvName = dvd.getDataverseName();
        String database = dvd.getDatabaseName();
        metadataProvider.validateNamespaceName(dvd.getNamespace(), dvd.getSourceLocation());
        this.lockManager.acquireDataverseReadLock(metadataProvider.getLocks(), database, dvName);
        try {
            Namespace namespace = this.doUseDataverseStatement(metadataProvider, dvd);
            return namespace;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected Namespace doUseDataverseStatement(MetadataProvider metadataProvider, DataverseDecl stmtUseDataverse) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            DataverseName dvName = stmtUseDataverse.getDataverseName();
            String dbName = stmtUseDataverse.getDatabaseName();
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dbName, dvName);
            if (dv == null) {
                if (stmtUseDataverse.getIfExists()) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)stmtUseDataverse.getSourceLocation(), (IError)ErrorCode.UNKNOWN_DATAVERSE, (Serializable[])new Serializable[]{MetadataUtil.dataverseName((String)dbName, (DataverseName)dvName, (boolean)metadataProvider.isUsingDatabase())}));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return this.activeNamespace;
                }
                throw new MetadataException(ErrorCode.UNKNOWN_DATAVERSE, stmtUseDataverse.getSourceLocation(), new Serializable[]{MetadataUtil.dataverseName((String)dbName, (DataverseName)dvName, (boolean)metadataProvider.isUsingDatabase())});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return new Namespace(dv.getDatabaseName(), dv.getDataverseName());
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateDatabaseStatement(MetadataProvider metadataProvider, Statement stmt, IRequestParameters requestParameters) throws Exception {
        CreateDatabaseStatement stmtCreateDatabase = (CreateDatabaseStatement)stmt;
        String database = stmtCreateDatabase.getDatabaseName().getValue();
        metadataProvider.validateDatabaseName(database, stmt.getSourceLocation());
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createDatabaseBegin(this.lockManager, metadataProvider.getLocks(), database);
        try {
            this.doCreateDatabaseStatement(metadataProvider, stmtCreateDatabase, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doCreateDatabaseStatement(MetadataProvider mdProvider, CreateDatabaseStatement stmtCreateDatabase, IRequestParameters requestParameters) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        mdProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            String databaseName = stmtCreateDatabase.getDatabaseName().getValue();
            Database database = MetadataManager.INSTANCE.getDatabase(mdTxnCtx, databaseName);
            if (database != null) {
                if (stmtCreateDatabase.ifNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.DATABASE_EXISTS, stmtCreateDatabase.getSourceLocation(), new Serializable[]{databaseName});
            }
            MetadataManager.INSTANCE.addDatabase(mdTxnCtx, new Database(databaseName, false, 0));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateDataverseStatement(MetadataProvider metadataProvider, Statement stmt, IRequestParameters requestParameters) throws Exception {
        CreateDataverseStatement stmtCreateDataverse = (CreateDataverseStatement)stmt;
        DataverseName dvName = stmtCreateDataverse.getDataverseName();
        String dbName = stmtCreateDataverse.getDatabaseName();
        Namespace stmtNamespace = stmtCreateDataverse.getNamespace();
        metadataProvider.validateNamespaceName(stmtNamespace, stmtCreateDataverse.getSourceLocation());
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createDataverseBegin(this.lockManager, metadataProvider.getLocks(), dbName, dvName);
        try {
            this.doCreateDataverseStatement(metadataProvider, stmtCreateDataverse, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doCreateDataverseStatement(MetadataProvider metadataProvider, CreateDataverseStatement stmtCreateDataverse, IRequestParameters requestParameters) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            DataverseName dvName = stmtCreateDataverse.getDataverseName();
            String dbName = stmtCreateDataverse.getDatabaseName();
            Database db = MetadataManager.INSTANCE.getDatabase(mdTxnCtx, dbName);
            if (db == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATABASE, stmtCreateDataverse.getSourceLocation(), new Serializable[]{dbName});
            }
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dbName, dvName);
            if (dv != null) {
                if (stmtCreateDataverse.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.DATAVERSE_EXISTS, stmtCreateDataverse.getSourceLocation(), new Serializable[]{dvName});
            }
            MetadataManager.INSTANCE.addDataverse(metadataProvider.getMetadataTxnContext(), new Dataverse(dbName, dvName, stmtCreateDataverse.getFormat(), 0));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected static void validateCompactionPolicy(String compactionPolicy, Map<String, String> compactionPolicyProperties, MetadataTransactionContext mdTxnCtx, boolean isExternalDataset, SourceLocation sourceLoc) throws Exception {
        CompactionPolicy compactionPolicyEntity = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, "System", MetadataConstants.METADATA_DATAVERSE_NAME, compactionPolicy);
        if (compactionPolicyEntity == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unknown compaction policy: " + compactionPolicy});
        }
        String compactionPolicyFactoryClassName = compactionPolicyEntity.getClassName();
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
        if (isExternalDataset && mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The correlated-prefix merge policy cannot be used with external " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL)});
        }
        if (compactionPolicyProperties == null) {
            if (mergePolicyFactory.getName().compareTo("no-merge") != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Compaction policy properties are missing."});
            }
        } else {
            for (Map.Entry<String, String> entry : compactionPolicyProperties.entrySet()) {
                if (mergePolicyFactory.getPropertiesNames().contains(entry.getKey())) continue;
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Invalid compaction policy property: " + entry.getKey()});
            }
            for (String p : mergePolicyFactory.getPropertiesNames()) {
                if (compactionPolicyProperties.containsKey(p)) continue;
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Missing compaction policy property: " + p});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateDatasetStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        boolean defaultCompactionPolicy;
        boolean metaItemTypeAnonymous;
        DatasetDecl dd = (DatasetDecl)stmt;
        String datasetName = dd.getName().getValue();
        metadataProvider.validateDatabaseObjectName(dd.getNamespace(), datasetName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(dd.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        TypeExpression itemTypeExpr = dd.getItemType();
        org.apache.hyracks.algebricks.common.utils.Triple<Namespace, String, Boolean> itemTypeQualifiedName = this.extractDatasetItemTypeName(stmtActiveNamespace, datasetName, itemTypeExpr, false, stmt.getSourceLocation());
        Namespace itemTypeNamespace = (Namespace)itemTypeQualifiedName.first;
        DataverseName itemTypeDataverseName = itemTypeNamespace.getDataverseName();
        String itemTypeDatabase = itemTypeNamespace.getDatabaseName();
        String itemTypeName = (String)itemTypeQualifiedName.second;
        boolean itemTypeAnonymous = (Boolean)itemTypeQualifiedName.third;
        TypeExpression metaItemTypeExpr = dd.getMetaItemType();
        Namespace metaItemTypeNamespace = null;
        DataverseName metaItemTypeDataverseName = null;
        String metaItemTypeDatabase = null;
        String metaItemTypeName = null;
        if (metaItemTypeExpr != null) {
            org.apache.hyracks.algebricks.common.utils.Triple<Namespace, String, Boolean> metaItemTypeQualifiedName = this.extractDatasetItemTypeName(stmtActiveNamespace, datasetName, metaItemTypeExpr, true, stmt.getSourceLocation());
            metaItemTypeNamespace = (Namespace)metaItemTypeQualifiedName.first;
            metaItemTypeDataverseName = metaItemTypeNamespace.getDataverseName();
            metaItemTypeDatabase = metaItemTypeNamespace.getDatabaseName();
            metaItemTypeName = (String)metaItemTypeQualifiedName.second;
            metaItemTypeAnonymous = (Boolean)metaItemTypeQualifiedName.third;
        } else {
            metaItemTypeAnonymous = true;
        }
        String nodegroupName = dd.getNodegroupName();
        String compactionPolicy = dd.getCompactionPolicy();
        boolean bl = defaultCompactionPolicy = compactionPolicy == null;
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName, itemTypeDatabase, itemTypeDataverseName, itemTypeName, itemTypeAnonymous, metaItemTypeDatabase, metaItemTypeDataverseName, metaItemTypeName, metaItemTypeAnonymous, nodegroupName, compactionPolicy, defaultCompactionPolicy, dd.getDatasetType(), (Object)dd.getDatasetDetailsDecl());
        try {
            this.doCreateDatasetStatement(metadataProvider, dd, stmtActiveNamespace, datasetName, itemTypeNamespace, itemTypeExpr, itemTypeName, metaItemTypeExpr, metaItemTypeNamespace, metaItemTypeName, hcc, requestParameters);
            if (dd.getQuery() != null) {
                IResultSet resultSet = requestParameters.getResultSet();
                IStatementExecutor.ResultDelivery resultDelivery = requestParameters.getResultProperties().getDelivery();
                IStatementExecutor.Stats stats = requestParameters.getStats();
                IStatementRewriter stmtRewriter = this.rewriterFactory.createStatementRewriter();
                IStatementExecutor.ResultMetadata outMetadata = requestParameters.getOutMetadata();
                Map stmtParams = requestParameters.getStatementParameters();
                UpsertStatement upsertStmt = new UpsertStatement(stmtActiveNamespace, datasetName, dd.getQuery(), -1, null, null);
                this.handleInsertUpsertStatement(metadataProvider, (Statement)upsertStmt, hcc, resultSet, resultDelivery, outMetadata, stats, requestParameters, stmtParams, stmtRewriter);
            }
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected Optional<? extends Dataset> doCreateDatasetStatement(MetadataProvider metadataProvider, DatasetDecl dd, Namespace namespace, String datasetName, Namespace itemTypeNamespace, TypeExpression itemTypeExpr, String itemTypeName, TypeExpression metaItemTypeExpr, Namespace metaItemTypeNamespace, String metaItemTypeName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DataverseName dataverseName = namespace.getDataverseName();
        String databaseName = namespace.getDatabaseName();
        DataverseName itemTypeDataverseName = null;
        String itemTypeDatabaseName = null;
        if (itemTypeNamespace != null) {
            itemTypeDataverseName = itemTypeNamespace.getDataverseName();
            itemTypeDatabaseName = itemTypeNamespace.getDatabaseName();
        }
        DataverseName metaItemTypeDataverseName = null;
        String metaItemTypeDatabaseName = null;
        if (metaItemTypeNamespace != null) {
            metaItemTypeDataverseName = metaItemTypeNamespace.getDataverseName();
            metaItemTypeDatabaseName = metaItemTypeNamespace.getDatabaseName();
        }
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        SourceLocation sourceLoc = dd.getSourceLocation();
        DatasetConfig.DatasetType dsType = dd.getDatasetType();
        String ngNameId = dd.getNodegroupName();
        String compactionPolicy = dd.getCompactionPolicy();
        Map compactionPolicyProperties = dd.getCompactionPolicyProperties();
        String compressionScheme = metadataProvider.getCompressionManager().getDdlOrDefaultCompressionScheme(dd.getDatasetCompressionScheme());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        Dataset dataset = null;
        Datatype itemTypeEntity = null;
        Datatype metaItemTypeEntity = null;
        boolean itemTypeAdded = false;
        boolean metaItemTypeAdded = false;
        StorageProperties storageProperties = metadataProvider.getStorageProperties();
        DatasetFormatInfo datasetFormatInfo = dd.getDatasetFormatInfo(storageProperties.getStorageFormat(), storageProperties.getColumnMaxTupleCount(), storageProperties.getColumnFreeSpaceTolerance(), storageProperties.getColumnMaxLeafNodeSize());
        try {
            ExternalDatasetDetails datasetDetails;
            String ngName;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName, true);
            if (ds != null) {
                if (ds.getDatasetType() == DatasetConfig.DatasetType.VIEW) {
                    throw new CompilationException(ErrorCode.VIEW_EXISTS, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((Dataset)ds)});
                }
                if (dd.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return Optional.empty();
                }
                throw new CompilationException(ErrorCode.DATASET_EXISTS, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            List partitioningExprTypes = null;
            if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                partitioningExprTypes = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprTypes();
            }
            Pair<Datatype, Boolean> itemTypePair = this.fetchDatasetItemType(mdTxnCtx, dsType, datasetFormatInfo.getFormat(), partitioningExprTypes, itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, itemTypeExpr, false, metadataProvider, sourceLoc);
            itemTypeEntity = (Datatype)itemTypePair.first;
            IAType itemType = itemTypeEntity.getDatatype();
            boolean itemTypeIsInline = (Boolean)itemTypePair.second;
            String string = ngName = ngNameId != null ? ngNameId : QueryTranslator.configureNodegroupForDataset(this.appCtx, dd.getHints(), databaseName, dataverseName, datasetName, metadataProvider, sourceLoc);
            if (compactionPolicy == null) {
                compactionPolicy = "concurrent";
                compactionPolicyProperties = StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES;
            } else {
                QueryTranslator.validateCompactionPolicy(compactionPolicy, compactionPolicyProperties, mdTxnCtx, false, sourceLoc);
            }
            IAType metaItemType = null;
            boolean metaItemTypeIsInline = false;
            switch (dsType) {
                case INTERNAL: {
                    if (metaItemTypeExpr != null) {
                        Pair<Datatype, Boolean> metaItemTypePair = this.fetchDatasetItemType(mdTxnCtx, dsType, datasetFormatInfo.getFormat(), partitioningExprTypes, metaItemTypeDatabaseName, metaItemTypeDataverseName, metaItemTypeName, metaItemTypeExpr, true, metadataProvider, sourceLoc);
                        metaItemTypeEntity = (Datatype)metaItemTypePair.first;
                        metaItemType = metaItemTypeEntity.getDatatype();
                        metaItemTypeIsInline = (Boolean)metaItemTypePair.second;
                    }
                    ARecordType metaRecType = (ARecordType)metaItemType;
                    List partitioningExprs = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs();
                    List keySourceIndicators = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getKeySourceIndicators();
                    boolean autogenerated = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated();
                    ARecordType aRecordType = (ARecordType)itemType;
                    List<IAType> partitioningTypes = this.validatePartitioningExpressions(aRecordType, metaRecType, partitioningExprs, keySourceIndicators, autogenerated, sourceLoc, partitioningExprTypes);
                    List filterField = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterField();
                    Integer filterSourceIndicator = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterSourceIndicator();
                    if (filterField != null) {
                        ValidateUtil.validateFilterField((ARecordType)aRecordType, (ARecordType)metaRecType, (Integer)filterSourceIndicator, (List)filterField, (SourceLocation)sourceLoc);
                    }
                    if (compactionPolicy == null && filterField != null) {
                        compactionPolicy = "correlated-prefix";
                        compactionPolicyProperties = StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES;
                    }
                    boolean isDatasetWithoutTypeSpec = this.isDatasetWithoutTypeSpec(dd, aRecordType, metaRecType);
                    ColumnPropertiesValidationUtil.validate((SourceLocation)sourceLoc, (DatasetConfig.DatasetFormat)datasetFormatInfo.getFormat(), (String)compactionPolicy, (List)filterField);
                    datasetDetails = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, partitioningExprs, partitioningExprs, keySourceIndicators, partitioningTypes, autogenerated, filterSourceIndicator, filterField, isDatasetWithoutTypeSpec);
                    break;
                }
                case EXTERNAL: {
                    ExternalDetailsDecl externalDetails = (ExternalDetailsDecl)dd.getDatasetDetailsDecl();
                    Map<String, String> properties = this.createExternalDatasetProperties(databaseName, dataverseName, dd, itemTypeEntity, metadataProvider, mdTxnCtx);
                    ExternalDataUtils.normalize(properties);
                    ExternalDataUtils.validate(properties);
                    ExternalDataUtils.validateType(properties, (ARecordType)((ARecordType)itemType));
                    this.validateExternalDatasetProperties(externalDetails, properties, dd.getSourceLocation(), mdTxnCtx, (IApplicationContext)this.appCtx);
                    datasetDetails = new ExternalDatasetDetails(externalDetails.getAdapter(), properties, new Date(), DatasetConfig.TransactionState.COMMIT);
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_DATASET_TYPE, new Serializable[]{dataset.getDatasetType().toString()});
                }
            }
            if (!DatasetIdFactory.isInitialized()) {
                DatasetIdFactory.initialize((int)MetadataManager.INSTANCE.getMostRecentDatasetId());
            }
            dataset = (Dataset)this.createDataset(dd, databaseName, dataverseName, datasetName, itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, metaItemTypeDatabaseName, metaItemTypeDataverseName, metaItemTypeName, dsType, compactionPolicy, compactionPolicyProperties, compressionScheme, datasetFormatInfo, (IDatasetDetails)datasetDetails, ngName);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            if (itemTypeIsInline) {
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, itemTypeEntity);
                itemTypeAdded = true;
            }
            if (metaItemTypeIsInline) {
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, metaItemTypeEntity);
                metaItemTypeAdded = true;
            }
            if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                JobSpecification jobSpec = DatasetUtil.createDatasetJobSpec((Dataset)dataset, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
                this.runJob(hcc, jobSpec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
            }
            MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, requestParameters.isForceDropDataset());
            dataset.setPendingOp(0);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block30: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = DatasetUtil.dropDatasetJobSpec(dataset, (MetadataProvider)metadataProvider, EnumSet.of(IndexDropOperatorDescriptor.DropOption.IF_EXISTS));
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        this.runJob(hcc, jobSpec);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block30;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropDataset(mdTxnCtx, databaseName, dataverseName, datasetName, requestParameters.isForceDropDataset());
                    if (itemTypeAdded) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, itemTypeEntity.getDatabaseName(), itemTypeEntity.getDataverseName(), itemTypeEntity.getDatatypeName());
                    }
                    if (metaItemTypeAdded) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, metaItemTypeEntity.getDatabaseName(), metaItemTypeEntity.getDataverseName(), metaItemTypeEntity.getDatatypeName());
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        return Optional.of(dataset);
    }

    protected boolean isDatasetWithoutTypeSpec(DatasetDecl datasetDecl, ARecordType aRecordType, ARecordType metaRecType) {
        return aRecordType.getFieldNames().length == 0 && metaRecType == null;
    }

    protected IDataset createDataset(DatasetDecl dd, String database, DataverseName dataverseName, String datasetName, String itemTypeDatabase, DataverseName itemTypeDataverseName, String itemTypeName, String metaItemTypeDatabase, DataverseName metaItemTypeDataverseName, String metaItemTypeName, DatasetConfig.DatasetType dsType, String compactionPolicy, Map<String, String> compactionPolicyProperties, String compressionScheme, DatasetFormatInfo datasetFormatInfo, IDatasetDetails datasetDetails, String ngName) throws AlgebricksException {
        return new Dataset(database, dataverseName, datasetName, itemTypeDatabase, itemTypeDataverseName, itemTypeName, metaItemTypeDatabase, metaItemTypeDataverseName, metaItemTypeName, ngName, compactionPolicy, compactionPolicyProperties, datasetDetails, dd.getHints(), dsType, DatasetIdFactory.generateDatasetId(), 1, compressionScheme, datasetFormatInfo);
    }

    protected org.apache.hyracks.algebricks.common.utils.Triple<Namespace, String, Boolean> extractDatasetItemTypeName(Namespace datasetNamespace, String datasetName, TypeExpression itemTypeExpr, boolean isMetaItemType, SourceLocation sourceLoc) throws CompilationException {
        switch (itemTypeExpr.getTypeKind()) {
            case TYPEREFERENCE: {
                TypeReferenceExpression itemTypeRefExpr = (TypeReferenceExpression)itemTypeExpr;
                Pair itemTypeIdent = itemTypeRefExpr.getIdent();
                Namespace typeNamespace = itemTypeIdent.first != null ? (Namespace)itemTypeIdent.first : datasetNamespace;
                String typeName = ((Identifier)itemTypeRefExpr.getIdent().second).getValue();
                return new org.apache.hyracks.algebricks.common.utils.Triple((Object)typeNamespace, (Object)typeName, (Object)false);
            }
            case RECORD: {
                String inlineTypeName = TypeUtil.createDatasetInlineTypeName((String)datasetName, (boolean)isMetaItemType);
                return new org.apache.hyracks.algebricks.common.utils.Triple((Object)datasetNamespace, (Object)inlineTypeName, (Object)true);
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{String.valueOf(itemTypeExpr.getTypeKind())});
    }

    protected Pair<Datatype, Boolean> fetchDatasetItemType(MetadataTransactionContext mdTxnCtx, DatasetConfig.DatasetType datasetType, DatasetConfig.DatasetFormat format, List<TypeExpression> partitioningExprTypes, String itemTypeDatabaseName, DataverseName itemTypeDataverseName, String itemTypeName, TypeExpression itemTypeExpr, boolean isMetaItemType, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        switch (itemTypeExpr.getTypeKind()) {
            case TYPEREFERENCE: {
                Datatype itemTypeEntity = metadataProvider.findTypeEntity(itemTypeDatabaseName, itemTypeDataverseName, itemTypeName);
                if (itemTypeEntity == null || itemTypeEntity.getIsAnonymous()) {
                    throw new AsterixException(ErrorCode.UNKNOWN_TYPE, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)itemTypeDataverseName, (String)itemTypeName)});
                }
                IAType itemType = itemTypeEntity.getDatatype();
                this.validateDatasetItemType(datasetType, format, partitioningExprTypes, itemType, isMetaItemType, sourceLoc);
                return new Pair((Object)itemTypeEntity, (Object)false);
            }
            case RECORD: {
                IAType itemType = this.translateType(itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, itemTypeExpr, mdTxnCtx);
                this.validateDatasetItemType(datasetType, format, partitioningExprTypes, itemType, isMetaItemType, sourceLoc);
                Datatype itemTypeEntity = new Datatype(itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, itemType, true);
                return new Pair((Object)itemTypeEntity, (Object)true);
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{String.valueOf(itemTypeExpr.getTypeKind())});
    }

    protected void validateDatasetItemType(DatasetConfig.DatasetType datasetType, DatasetConfig.DatasetFormat format, List<TypeExpression> partitioningExprTypes, IAType itemType, boolean isMetaItemType, SourceLocation sourceLoc) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{String.format("%s %s has to be a record type.", datasetType == DatasetConfig.DatasetType.VIEW ? "view" : StringUtils.capitalize((String)IdentifierUtil.dataset()), isMetaItemType ? "meta type" : "type")});
        }
        if (datasetType == DatasetConfig.DatasetType.VIEW) {
            ViewUtil.validateViewItemType((ARecordType)((ARecordType)itemType), (SourceLocation)sourceLoc);
        }
        if (datasetType == DatasetConfig.DatasetType.INTERNAL) {
            ColumnSupportedTypesValidator.validate((DatasetConfig.DatasetFormat)format, (IAType)itemType, (SourceLocation)sourceLoc);
            if (partitioningExprTypes != null) {
                for (TypeExpression typeExpr : partitioningExprTypes) {
                    String typeName = ((Identifier)((TypeReferenceExpression)typeExpr).getIdent().second).getValue();
                    BuiltinType type = BuiltinTypeMap.getBuiltinType((String)typeName);
                    if (type == null) continue;
                    ColumnSupportedTypesValidator.validate((DatasetConfig.DatasetFormat)format, (IAType)type, (SourceLocation)sourceLoc);
                }
            }
        }
    }

    protected Map<String, String> createExternalDatasetProperties(String databaseName, DataverseName dataverseName, DatasetDecl dd, Datatype itemType, MetadataProvider metadataProvider, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ExternalDetailsDecl externalDetails = (ExternalDetailsDecl)dd.getDatasetDetailsDecl();
        Map properties = externalDetails.getProperties();
        ExternalDataUtils.validateParquetTypeAndConfiguration((Map)properties, (ARecordType)((ARecordType)itemType.getDatatype()));
        return properties;
    }

    protected static void validateIfResourceIsActiveInFeed(ICcApplicationContext appCtx, Dataset dataset, SourceLocation sourceLoc) throws CompilationException {
        IActiveEntityEventsListener[] listeners;
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        for (IActiveEntityEventsListener listener : listeners = activeEventHandler.getEventListeners()) {
            if (!listener.isEntityUsingDataset((IDataset)dataset) || !listener.isActive()) continue;
            throw new CompilationException(ErrorCode.COMPILATION_CANT_DROP_ACTIVE_DATASET, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((Dataset)dataset), listener.getEntityId().toString()});
        }
    }

    protected static String configureNodegroupForDataset(ICcApplicationContext appCtx, Map<String, String> hints, String databaseName, DataverseName dataverseName, String datasetName, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws Exception {
        IClusterStateManager csm = appCtx.getClusterStateManager();
        Set allNodes = csm.getParticipantNodes(true);
        LinkedHashSet selectedNodes = new LinkedHashSet();
        String hintValue = hints.get("NODEGROUP_CARDINALITY");
        if (hintValue == null) {
            selectedNodes.addAll(allNodes);
        } else {
            Pair validation = DatasetHints.validate((ICcApplicationContext)appCtx, (String)"NODEGROUP_CARDINALITY", (String)hints.get("NODEGROUP_CARDINALITY"));
            boolean valid = (Boolean)validation.first;
            if (!valid) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Incorrect use of hint 'NODEGROUP_CARDINALITY': " + (String)validation.second});
            }
            int nodegroupCardinality = Integer.parseInt(hints.get("NODEGROUP_CARDINALITY"));
            ArrayList allNodeList = new ArrayList(allNodes);
            Collections.shuffle(allNodeList);
            selectedNodes.addAll(allNodeList.subList(0, nodegroupCardinality));
        }
        return DatasetUtil.createNodeGroupForNewDataset((String)databaseName, (DataverseName)dataverseName, (String)datasetName, selectedNodes, (MetadataProvider)metadataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateIndexStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        CreateIndexStatement stmtCreateIndex = (CreateIndexStatement)stmt;
        String datasetName = stmtCreateIndex.getDatasetName().getValue();
        String indexName = stmtCreateIndex.getIndexName().getValue();
        String fullTextConfigName = stmtCreateIndex.getFullTextConfigName();
        metadataProvider.validateDatabaseObjectName(stmtCreateIndex.getNamespace(), indexName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtCreateIndex.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createIndexBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName, fullTextConfigName);
        try {
            this.doCreateIndex(metadataProvider, stmtCreateIndex, databaseName, dataverseName, datasetName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateIndex(MetadataProvider metadataProvider, CreateIndexStatement stmtCreateIndex, String databaseName, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtCreateIndex.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Index.ArrayIndexDetails indexDetails;
            boolean castDefaultNullAllowed;
            boolean unknownKeyOptionAllowed;
            List projectList;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            DatasetConfig.DatasetType datasetType = ds.getDatasetType();
            DatasetConfig.IndexType indexType = stmtCreateIndex.getIndexType();
            List indexedElements = stmtCreateIndex.getIndexedElements();
            int indexedElementsCount = indexedElements.size();
            boolean isSecondaryPrimary = indexedElementsCount == 0;
            this.validateIndexType(datasetType, indexType, isSecondaryPrimary, sourceLoc);
            String indexName = stmtCreateIndex.getIndexName().getValue();
            Index index = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, indexName);
            if (index != null) {
                if (stmtCreateIndex.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.INDEX_EXISTS, sourceLoc, new Serializable[]{indexName});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getItemTypeDatabaseName(), ds.getItemTypeDataverseName(), ds.getItemTypeName());
            ARecordType aRecordType = (ARecordType)dt.getDatatype();
            if (!ds.hasMetaPart()) {
                aRecordType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)aRecordType, null, ds);
            }
            ArrayList indexFieldTypes = new ArrayList(indexedElementsCount);
            boolean hadUnnest = false;
            boolean overridesFieldTypes = false;
            HashSet<org.apache.hyracks.algebricks.common.utils.Triple> indexKeysSet = new HashSet<org.apache.hyracks.algebricks.common.utils.Triple>();
            for (CreateIndexStatement.IndexedElement indexedElement : indexedElements) {
                boolean inputTypeNullable;
                boolean inputTypeMissable;
                ARecordType inputTypePrime;
                if (indexedElement.getSourceIndicator() != 0) {
                    throw new AsterixException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"Cannot create index on meta fields"});
                }
                ARecordType sourceRecordType = aRecordType;
                projectList = indexedElement.getProjectList();
                int projectCount = projectList.size();
                if (indexedElement.hasUnnest()) {
                    if (indexType != DatasetConfig.IndexType.ARRAY) {
                        throw new CompilationException(ErrorCode.COMPILATION_INCOMPATIBLE_INDEX_TYPE, indexedElement.getSourceLocation(), new Serializable[]{String.valueOf(indexType)});
                    }
                    if (hadUnnest) {
                        throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"Cannot create composite index with multiple array fields using different arrays"});
                    }
                    hadUnnest = true;
                    if (projectCount == 0) {
                        throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"Invalid index element"});
                    }
                    org.apache.hyracks.algebricks.common.utils.Triple unnestTypeResult = KeyFieldTypeUtil.getKeyUnnestType((ARecordType)sourceRecordType, (List)indexedElement.getUnnestList(), (SourceLocation)indexedElement.getSourceLocation());
                    if (unnestTypeResult == null) {
                        inputTypePrime = null;
                        inputTypeMissable = true;
                        inputTypeNullable = true;
                    } else {
                        inputTypePrime = (IAType)unnestTypeResult.first;
                        inputTypeNullable = (Boolean)unnestTypeResult.second;
                        inputTypeMissable = (Boolean)unnestTypeResult.third;
                    }
                } else {
                    if (projectCount != 1) {
                        throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"Invalid index element"});
                    }
                    inputTypePrime = sourceRecordType;
                    inputTypeMissable = false;
                    inputTypeNullable = false;
                }
                ArrayList<IAType> fieldTypes = new ArrayList<IAType>(projectCount);
                for (int i = 0; i < projectCount; ++i) {
                    boolean fieldTypeMissable;
                    boolean fieldTypeNullable;
                    ARecordType fieldTypePrime;
                    boolean isFieldFromSchema;
                    boolean projectTypeMissable;
                    boolean projectTypeNullable;
                    ARecordType projectTypePrime;
                    Pair projectPair = (Pair)projectList.get(i);
                    List projectPath = (List)projectPair.first;
                    IndexedTypeExpression projectTypeExpr = (IndexedTypeExpression)projectPair.second;
                    if (projectPath == null) {
                        boolean emptyPathOk;
                        boolean bl = emptyPathOk = indexedElement.hasUnnest() && i == 0;
                        if (!emptyPathOk) {
                            throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"Invalid index element"});
                        }
                        projectTypePrime = inputTypePrime;
                        projectTypeNullable = inputTypeNullable;
                        projectTypeMissable = inputTypeMissable;
                    } else if (inputTypePrime == null) {
                        projectTypePrime = null;
                        projectTypeMissable = true;
                        projectTypeNullable = true;
                    } else {
                        if (inputTypePrime.getTypeTag() != ATypeTag.OBJECT) {
                            throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{ATypeTag.OBJECT, inputTypePrime.getTypeTag()});
                        }
                        ARecordType inputTypePrimeRecord = inputTypePrime;
                        org.apache.hyracks.algebricks.common.utils.Triple projectTypeResult = KeyFieldTypeUtil.getKeyProjectType((ARecordType)inputTypePrimeRecord, (List)projectPath, (SourceLocation)indexedElement.getSourceLocation());
                        if (projectTypeResult != null) {
                            projectTypePrime = (IAType)projectTypeResult.first;
                            projectTypeNullable = inputTypeNullable || (Boolean)projectTypeResult.second != false;
                            projectTypeMissable = inputTypeMissable || (Boolean)projectTypeResult.third != false;
                        } else {
                            projectTypePrime = null;
                            projectTypeMissable = true;
                            projectTypeNullable = true;
                        }
                    }
                    boolean bl = isFieldFromSchema = projectTypePrime != null;
                    if (projectTypeExpr == null) {
                        if (stmtCreateIndex.hasCastDefaultNull()) {
                            throw new CompilationException(ErrorCode.COMPILATION_ERROR, stmtCreateIndex.getSourceLocation(), new Serializable[]{"CAST modifier is used without specifying the type of the indexed field"});
                        }
                        fieldTypePrime = projectTypePrime;
                        fieldTypeNullable = projectTypeNullable;
                        fieldTypeMissable = projectTypeMissable;
                    } else {
                        Map typeMap = TypeTranslator.computeTypes((String)databaseName, (DataverseName)dataverseName, (String)indexName, (TypeExpression)projectTypeExpr.getType(), (String)databaseName, (DataverseName)dataverseName, (MetadataTransactionContext)mdTxnCtx);
                        TypeSignature typeSignature = new TypeSignature(databaseName, dataverseName, indexName);
                        fieldTypePrime = (IAType)typeMap.get(typeSignature);
                        fieldTypeMissable = false;
                        fieldTypeNullable = false;
                        overridesFieldTypes = true;
                        if (stmtCreateIndex.isEnforced()) {
                            if (!projectTypeExpr.isUnknownable()) {
                                throw new CompilationException(ErrorCode.INDEX_ILLEGAL_ENFORCED_NON_OPTIONAL, indexedElement.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)String.valueOf(projectPath))});
                            }
                            if (isFieldFromSchema) {
                                if (fieldTypePrime == null) {
                                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, indexedElement.getSourceLocation(), new Serializable[]{"cannot find type of field"});
                                }
                                if (!projectTypePrime.deepEqual((IAObject)fieldTypePrime)) {
                                    throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{projectTypePrime.getTypeTag(), fieldTypePrime.getTypeTag()});
                                }
                            }
                        } else {
                            if (indexType != DatasetConfig.IndexType.BTREE && indexType != DatasetConfig.IndexType.ARRAY) {
                                throw new CompilationException(ErrorCode.INDEX_ILLEGAL_NON_ENFORCED_TYPED, indexedElement.getSourceLocation(), new Serializable[]{indexType});
                            }
                            if (isFieldFromSchema && !stmtCreateIndex.hasCastDefaultNull()) {
                                if (fieldTypePrime == null) {
                                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, indexedElement.getSourceLocation(), new Serializable[]{"cannot find type of field"});
                                }
                                if (!projectTypePrime.deepEqual((IAObject)fieldTypePrime)) {
                                    throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{projectTypePrime.getTypeTag(), fieldTypePrime.getTypeTag()});
                                }
                            }
                        }
                    }
                    if (fieldTypePrime == null) {
                        if (projectPath != null) {
                            String fieldName = LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName((List)projectPath));
                            throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"cannot find type of field '" + fieldName + "'"});
                        }
                        if (indexedElement.hasUnnest()) {
                            List unnestList = indexedElement.getUnnestList();
                            List arrayField = (List)unnestList.get(unnestList.size() - 1);
                            String fieldName = LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName((List)arrayField));
                            throw new CompilationException(ErrorCode.COMPILATION_ERROR, indexedElement.getSourceLocation(), new Serializable[]{"cannot find type of elements of field '" + fieldName + "'"});
                        }
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, indexedElement.getSourceLocation(), new Serializable[]{"cannot find type of field"});
                    }
                    this.validateIndexFieldType(indexType, (IAType)fieldTypePrime, projectPath, indexedElement.getSourceLocation());
                    IAType fieldType = KeyFieldTypeUtil.makeUnknownableType((IAType)fieldTypePrime, (boolean)fieldTypeNullable, (boolean)fieldTypeMissable);
                    fieldTypes.add(fieldType);
                }
                if (!indexKeysSet.add(indexedElement.toIdentifier())) {
                    throw new AsterixException(ErrorCode.INDEX_ILLEGAL_REPETITIVE_FIELD, indexedElement.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)indexedElement.getProjectListDisplayForm())});
                }
                indexFieldTypes.add(fieldTypes);
            }
            boolean bl = unknownKeyOptionAllowed = (indexType == DatasetConfig.IndexType.BTREE || indexType == DatasetConfig.IndexType.ARRAY) && !isSecondaryPrimary;
            if (stmtCreateIndex.hasExcludeUnknownKey() && !unknownKeyOptionAllowed) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"can only specify exclude/include unknown key for B-Tree & Array indexes"});
            }
            boolean bl2 = castDefaultNullAllowed = indexType == DatasetConfig.IndexType.BTREE && !isSecondaryPrimary;
            if (stmtCreateIndex.hasCastDefaultNull() && !castDefaultNullAllowed) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"CAST modifier is only allowed for B-Tree indexes"});
            }
            if (stmtCreateIndex.getCastDefaultNull().getOrElse(false) && stmtCreateIndex.isEnforced()) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"CAST modifier cannot be specified together with ENFORCED"});
            }
            if (Index.IndexCategory.of((DatasetConfig.IndexType)indexType) == Index.IndexCategory.ARRAY) {
                if (!stmtCreateIndex.hasExcludeUnknownKey() || !stmtCreateIndex.getExcludeUnknownKey().getOrElse(false)) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Array indexes must specify EXCLUDE UNKNOWN KEY."});
                }
                if (!hadUnnest) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
                }
                if (stmtCreateIndex.isEnforced()) {
                    throw new CompilationException(ErrorCode.COMPILATION_INCOMPATIBLE_INDEX_TYPE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
                }
                ArrayList<Index.ArrayIndexElement> indexElementList = new ArrayList<Index.ArrayIndexElement>(indexedElementsCount);
                for (int i = 0; i < indexedElementsCount; ++i) {
                    CreateIndexStatement.IndexedElement indexedElement = (CreateIndexStatement.IndexedElement)indexedElements.get(i);
                    projectList = indexedElement.getProjectList().stream().map(Pair::getFirst).collect(Collectors.toList());
                    indexElementList.add(new Index.ArrayIndexElement(indexedElement.getUnnestList(), projectList, (List)indexFieldTypes.get(i), indexedElement.getSourceIndicator()));
                }
                indexDetails = new Index.ArrayIndexDetails(indexElementList, overridesFieldTypes);
            } else {
                ArrayList<List> keyFieldNames = new ArrayList<List>(indexedElementsCount);
                ArrayList<IAType> keyFieldTypes = new ArrayList<IAType>(indexedElementsCount);
                ArrayList<Integer> keyFieldSourceIndicators = new ArrayList<Integer>(indexedElementsCount);
                if (!isSecondaryPrimary) {
                    for (int i = 0; i < indexedElementsCount; ++i) {
                        CreateIndexStatement.IndexedElement indexedElement = (CreateIndexStatement.IndexedElement)indexedElements.get(i);
                        keyFieldNames.add((List)((Pair)indexedElement.getProjectList().get((int)0)).first);
                        keyFieldTypes.add((IAType)((List)indexFieldTypes.get(i)).get(0));
                        keyFieldSourceIndicators.add(indexedElement.getSourceIndicator());
                    }
                }
                switch (Index.IndexCategory.of((DatasetConfig.IndexType)indexType)) {
                    case VALUE: {
                        Map castConfig = TypeUtil.validateConfiguration((Map)stmtCreateIndex.getCastConfig(), (SourceLocation)stmtCreateIndex.getSourceLocation());
                        String datetimeFormat = TypeUtil.getDatetimeFormat((Map)castConfig);
                        String dateFormat = TypeUtil.getDateFormat((Map)castConfig);
                        String timeFormat = TypeUtil.getTimeFormat((Map)castConfig);
                        indexDetails = new Index.ValueIndexDetails(keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, overridesFieldTypes, stmtCreateIndex.getExcludeUnknownKey(), stmtCreateIndex.getCastDefaultNull(), datetimeFormat, dateFormat, timeFormat);
                        break;
                    }
                    case TEXT: {
                        indexDetails = new Index.TextIndexDetails(keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, overridesFieldTypes, stmtCreateIndex.getGramLength(), stmtCreateIndex.getFullTextConfigName());
                        break;
                    }
                    default: {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
                    }
                }
            }
            Index newIndex = new Index(databaseName, dataverseName, datasetName, indexName, indexType, (Index.IIndexDetails)indexDetails, stmtCreateIndex.isEnforced(), false, 1);
            bActiveTxn = false;
            this.doCreateIndexImpl(hcc, metadataProvider, ds, newIndex, this.jobFlags, sourceLoc);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateFullTextFilterStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFullTextFilterStatement stmtCreateFilter = (CreateFullTextFilterStatement)stmt;
        String fullTextFilterName = stmtCreateFilter.getFilterName();
        metadataProvider.validateDatabaseObjectName(stmtCreateFilter.getNamespace(), fullTextFilterName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtCreateFilter.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createFullTextFilterBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, fullTextFilterName);
        try {
            this.doCreateFullTextFilter(metadataProvider, stmtCreateFilter, databaseName, dataverseName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateFullTextFilter(MetadataProvider metadataProvider, CreateFullTextFilterStatement stmtCreateFilter, String databaseName, DataverseName dataverseName) throws Exception {
        String filterType = stmtCreateFilter.getFilterType();
        if (filterType == null) {
            throw new CompilationException(ErrorCode.PARSE_ERROR, stmtCreateFilter.getSourceLocation(), new Serializable[]{"full-text filter type is null"});
        }
        if (!"stopwords".equals(filterType)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, stmtCreateFilter.getSourceLocation(), new Serializable[]{"Unexpected full-text filter type: " + filterType});
        }
        StopwordsFullTextFilterDescriptor filterDescriptor = new StopwordsFullTextFilterDescriptor(databaseName, dataverseName, stmtCreateFilter.getFilterName(), stmtCreateFilter.getStopwordsList());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, stmtCreateFilter.getSourceLocation(), new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            String filterName = stmtCreateFilter.getFilterName();
            FullTextFilterMetadataEntity existingFilter = MetadataManager.INSTANCE.getFullTextFilter(mdTxnCtx, databaseName, dataverseName, filterName);
            if (existingFilter != null) {
                if (stmtCreateFilter.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.FULL_TEXT_FILTER_ALREADY_EXISTS, stmtCreateFilter.getSourceLocation(), new Serializable[]{filterName});
            }
            MetadataManager.INSTANCE.addFullTextFilter(mdTxnCtx, new FullTextFilterMetadataEntity((AbstractFullTextFilterDescriptor)filterDescriptor));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateFullTextConfigStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFullTextConfigStatement stmtCreateConfig = (CreateFullTextConfigStatement)stmt;
        String configName = stmtCreateConfig.getConfigName();
        metadataProvider.validateDatabaseObjectName(stmtCreateConfig.getNamespace(), configName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtCreateConfig.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        ImmutableList filterNames = stmtCreateConfig.getFilterNames();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createFullTextConfigBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, configName, filterNames);
        try {
            this.doCreateFullTextConfig(metadataProvider, stmtCreateConfig, databaseName, dataverseName, configName, (ImmutableList<String>)filterNames);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateFullTextConfig(MetadataProvider metadataProvider, CreateFullTextConfigStatement stmtCreateConfig, String databaseName, DataverseName dataverseName, String configName, ImmutableList<String> filterNames) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            FullTextConfigMetadataEntity existingConfig = MetadataManager.INSTANCE.getFullTextConfig(mdTxnCtx, databaseName, dataverseName, configName);
            if (existingConfig != null) {
                if (stmtCreateConfig.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.FULL_TEXT_CONFIG_ALREADY_EXISTS, stmtCreateConfig.getSourceLocation(), new Serializable[]{configName});
            }
            for (String filterName : filterNames) {
                FullTextFilterMetadataEntity filterMetadataEntity = MetadataManager.INSTANCE.getFullTextFilter(mdTxnCtx, databaseName, dataverseName, filterName);
                if (filterMetadataEntity != null) continue;
                throw new CompilationException(ErrorCode.FULL_TEXT_FILTER_NOT_FOUND, stmtCreateConfig.getSourceLocation(), new Serializable[]{filterName});
            }
            TokenizerCategory tokenizerCategory = stmtCreateConfig.getTokenizerCategory();
            FullTextConfigDescriptor configDescriptor = new FullTextConfigDescriptor(databaseName, dataverseName, configName, tokenizerCategory, filterNames);
            FullTextConfigMetadataEntity configMetadataEntity = new FullTextConfigMetadataEntity(configDescriptor);
            MetadataManager.INSTANCE.addFullTextConfig(mdTxnCtx, configMetadataEntity);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private void doCreateIndexImpl(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Dataset ds, Index index, EnumSet<JobFlag> jobFlags, SourceLocation sourceLoc) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        boolean bActiveTxn = true;
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        try {
            index.setPendingOp(1);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                this.validateDatasetState(metadataProvider, ds, sourceLoc);
            } else if (ds.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{IdentifierUtil.dataset() + " using " + ((ExternalDatasetDetails)ds.getDatasetDetails()).getAdapter() + " adapter can't be indexed"});
            }
            if (index.isEnforced()) {
                List indexKeyFieldTypes;
                List indexKeyFieldNames;
                switch (Index.IndexCategory.of((DatasetConfig.IndexType)index.getIndexType())) {
                    case VALUE: {
                        Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                        indexKeyFieldNames = valueIndexDetails.getKeyFieldNames();
                        indexKeyFieldTypes = valueIndexDetails.getKeyFieldTypes();
                        break;
                    }
                    case TEXT: {
                        Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                        indexKeyFieldNames = textIndexDetails.getKeyFieldNames();
                        indexKeyFieldTypes = textIndexDetails.getKeyFieldTypes();
                        break;
                    }
                    default: {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{""});
                    }
                }
                List indexes = MetadataManager.INSTANCE.getDatasetIndexes(metadataProvider.getMetadataTxnContext(), index.getDatabaseName(), index.getDataverseName(), index.getDatasetName());
                for (Index existingIndex : indexes) {
                    List existingIndexKeyFieldTypes;
                    List existingIndexKeyFieldNames;
                    if (!existingIndex.isEnforced()) continue;
                    switch (Index.IndexCategory.of((DatasetConfig.IndexType)existingIndex.getIndexType())) {
                        case VALUE: {
                            Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)existingIndex.getIndexDetails();
                            existingIndexKeyFieldNames = valueIndexDetails.getKeyFieldNames();
                            existingIndexKeyFieldTypes = valueIndexDetails.getKeyFieldTypes();
                            break;
                        }
                        case TEXT: {
                            Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)existingIndex.getIndexDetails();
                            existingIndexKeyFieldNames = textIndexDetails.getKeyFieldNames();
                            existingIndexKeyFieldTypes = textIndexDetails.getKeyFieldTypes();
                            break;
                        }
                        default: {
                            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{""});
                        }
                    }
                    if (!existingIndexKeyFieldNames.equals(indexKeyFieldNames) || existingIndexKeyFieldTypes.equals(indexKeyFieldTypes)) continue;
                    String fieldNames = indexKeyFieldNames.stream().map(RecordUtil::toFullyQualifiedName).collect(Collectors.joining(","));
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Cannot create index " + index.getIndexName() + " , enforced index " + existingIndex.getIndexName() + " on field(s) '" + LogRedactionUtil.userData((String)fieldNames) + "' is already defined with type(s) '" + StringUtils.join((Iterable)existingIndexKeyFieldTypes, (char)',') + "'"});
                }
            }
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            JobSpecification spec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            if (spec == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Failed to create job spec for creating index '" + ds.getDatasetName() + "." + index.getIndexName() + "'"});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                FlushDatasetUtil.flushDataset(hcc, metadataProvider, index.getDatabaseName(), index.getDataverseName(), index.getDatasetName());
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            spec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDatabaseName(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
            index.setPendingOp(0);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block23: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        QueryTranslator.runJob(hcc, jobSpec, jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block23;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDatabaseName(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is in inconsistent state: pending index(" + index.getDataverseName() + "." + index.getDatasetName() + "." + index.getIndexName() + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    protected void validateIndexType(DatasetConfig.DatasetType datasetType, DatasetConfig.IndexType indexType, boolean isSecondaryPrimaryIndex, SourceLocation sourceLoc) throws AlgebricksException {
        if (datasetType == DatasetConfig.DatasetType.EXTERNAL && isSecondaryPrimaryIndex) {
            throw new CompilationException(ErrorCode.CANNOT_CREATE_SEC_PRIMARY_IDX_ON_EXT_DATASET, new Serializable[0]);
        }
        if (indexType != DatasetConfig.IndexType.BTREE && isSecondaryPrimaryIndex) {
            throw new CompilationException(ErrorCode.COMPILATION_INCOMPATIBLE_INDEX_TYPE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
        }
    }

    protected void validateIndexFieldType(DatasetConfig.IndexType indexType, IAType fieldType, List<String> displayFieldName, SourceLocation sourceLoc) throws AlgebricksException {
        ValidateUtil.validateIndexFieldType((DatasetConfig.IndexType)indexType, (IAType)fieldType, displayFieldName, (SourceLocation)sourceLoc);
    }

    protected List<IAType> validatePartitioningExpressions(ARecordType recType, ARecordType metaRecType, List<List<String>> partitioningExprs, List<Integer> keySourceIndicators, boolean autogenerated, SourceLocation sourceLoc, List<TypeExpression> partitioningExprTypes) throws AlgebricksException {
        return ValidateUtil.validatePartitioningExpressions((ARecordType)recType, (ARecordType)metaRecType, partitioningExprs, keySourceIndicators, (boolean)autogenerated, (SourceLocation)sourceLoc, partitioningExprTypes);
    }

    protected void handleCreateTypeStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDecl stmtCreateType = (TypeDecl)stmt;
        SourceLocation sourceLoc = stmtCreateType.getSourceLocation();
        String typeName = stmtCreateType.getIdent().getValue();
        metadataProvider.validateDatabaseObjectName(stmtCreateType.getNamespace(), typeName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtCreateType.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.createTypeBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, typeName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, databaseName, dataverseName, typeName);
            if (dt != null) {
                if (!stmtCreateType.getIfNotExists()) {
                    throw new CompilationException(ErrorCode.TYPE_EXISTS, sourceLoc, new Serializable[]{typeName});
                }
            } else {
                if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Cannot redefine builtin type " + typeName + "."});
                }
                if (TypeUtil.isReservedInlineTypeName((String)typeName)) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Reserved type name " + typeName + "."});
                }
                IAType type = this.translateType(databaseName, dataverseName, typeName, stmtCreateType.getTypeDef(), mdTxnCtx);
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(databaseName, dataverseName, typeName, type, false));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private IAType translateType(String databaseName, DataverseName dataverseName, String typeName, TypeExpression typeDef, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        Map typeMap = TypeTranslator.computeTypes((String)databaseName, (DataverseName)dataverseName, (String)typeName, (TypeExpression)typeDef, (String)databaseName, (DataverseName)dataverseName, (MetadataTransactionContext)mdTxnCtx);
        TypeSignature typeSignature = new TypeSignature(databaseName, dataverseName, typeName);
        return (IAType)typeMap.get(typeSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDatabaseDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DatabaseDropStatement stmtDropDatabase = (DatabaseDropStatement)stmt;
        SourceLocation sourceLoc = stmtDropDatabase.getSourceLocation();
        String databaseName = stmtDropDatabase.getDatabaseName().getValue();
        metadataProvider.validateDatabaseName(databaseName, sourceLoc);
        if (QueryTranslator.isSystemDatabase((String)databaseName) || QueryTranslator.isDefaultDatabase((String)databaseName)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{databaseName + " database can't be dropped"});
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropDatabaseBegin(this.lockManager, metadataProvider.getLocks(), databaseName);
        try {
            this.doDropDatabase(stmtDropDatabase, metadataProvider, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropDatabase(DatabaseDropStatement stmtDropDatabase, MetadataProvider mdProvider, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation srcLoc = stmtDropDatabase.getSourceLocation();
        String databaseName = stmtDropDatabase.getDatabaseName().getValue();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        mdProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<FeedEventsListener> stopFeeds = new ArrayList<FeedEventsListener>();
        ArrayList<JobSpecification> dropJobs = new ArrayList<JobSpecification>();
        try {
            Database database = MetadataManager.INSTANCE.getDatabase(mdTxnCtx, databaseName);
            if (database == null) {
                if (stmtDropDatabase.ifExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATABASE, srcLoc, new Serializable[]{databaseName});
            }
            this.validateDatabaseStateBeforeDrop(mdProvider, database, srcLoc);
            List<Dataset> datasets = this.prepareDatabaseDropJobs(mdProvider, srcLoc, databaseName, mdTxnCtx, stopFeeds, dropJobs);
            MetadataManager.INSTANCE.dropDatabase(mdTxnCtx, databaseName);
            MetadataManager.INSTANCE.addDatabase(mdTxnCtx, new Database(databaseName, database.isSystemDatabase(), 2));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            this.runDropJobs(mdProvider, hcc, stopFeeds, dropJobs);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            mdProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropDatabase(mdTxnCtx, databaseName);
            for (Dataset dataset : datasets) {
                String nodeGroup = dataset.getNodeGroupName();
                this.lockManager.acquireNodeGroupWriteLock(mdProvider.getLocks(), nodeGroup);
                if (MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup) == null) continue;
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodeGroup, true);
            }
            if (this.activeNamespace.getDatabaseName().equals(databaseName)) {
                this.activeNamespace = MetadataBuiltinEntities.DEFAULT_NAMESPACE;
            }
            this.validateDatasetsStateAfterNamespaceDrop(mdProvider, mdTxnCtx, datasets);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                if (this.activeNamespace.getDatabaseName().equals(databaseName)) {
                    this.activeNamespace = MetadataBuiltinEntities.DEFAULT_NAMESPACE;
                }
                try {
                    for (JobSpecification jobSpec : dropJobs) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropDatabase(mdTxnCtx, databaseName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending database(" + databaseName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataverseDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DataverseDropStatement stmtDropDataverse = (DataverseDropStatement)stmt;
        SourceLocation sourceLoc = stmtDropDataverse.getSourceLocation();
        DataverseName dataverseName = stmtDropDataverse.getDataverseName();
        String databaseName = stmtDropDataverse.getDatabaseName();
        metadataProvider.validateNamespaceName(stmtDropDataverse.getNamespace(), sourceLoc);
        if (QueryTranslator.isDefaultDataverse((DataverseName)dataverseName) || QueryTranslator.isMetadataDataverse((DataverseName)dataverseName)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{dataverseName + " " + IdentifierUtil.dataverse() + " can't be dropped"});
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropDataverseBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName);
        try {
            this.doDropDataverse(stmtDropDataverse, metadataProvider, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropDataverse(DataverseDropStatement stmtDropDataverse, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtDropDataverse.getSourceLocation();
        DataverseName dataverseName = stmtDropDataverse.getDataverseName();
        String databaseName = stmtDropDataverse.getDatabaseName();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<FeedEventsListener> feedsToStop = new ArrayList<FeedEventsListener>();
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        try {
            IActiveEntityEventsListener[] activeListeners;
            Database db = MetadataManager.INSTANCE.getDatabase(mdTxnCtx, databaseName);
            if (db == null) {
                if (stmtDropDataverse.getIfExists()) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)sourceLoc, (IError)ErrorCode.UNKNOWN_DATABASE, (Serializable[])new Serializable[]{databaseName}));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATABASE, sourceLoc, new Serializable[]{databaseName});
            }
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                if (stmtDropDataverse.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (stmtDropDataverse.getIfEmpty() && this.isDataverseNotEmpty(databaseName, dataverseName, mdTxnCtx)) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return false;
            }
            this.validateDataverseStateBeforeDrop(metadataProvider, dv, sourceLoc);
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            for (IActiveEntityEventsListener listener : activeListeners = activeEventHandler.getEventListeners()) {
                EntityId activeEntityId = listener.getEntityId();
                if (!activeEntityId.getExtensionName().equals("Feed") || !activeEntityId.getDatabaseName().equals(databaseName) || !activeEntityId.getDataverseName().equals((Object)dataverseName)) continue;
                FeedEventsListener feedListener = (FeedEventsListener)listener;
                feedsToStop.add(feedListener);
                jobsToExecute.add(FeedOperations.buildRemoveFeedStorageJob(metadataProvider, feedListener.getFeed()));
            }
            List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, databaseName, dataverseName);
            block10: for (Dataset dataset : datasets) {
                String datasetName = dataset.getDatasetName();
                DatasetConfig.DatasetType dsType = dataset.getDatasetType();
                switch (dsType) {
                    case INTERNAL: {
                        List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, databaseName, dataverseName, datasetName);
                        for (Index index : indexes) {
                            jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, (SourceLocation)sourceLoc));
                        }
                        continue block10;
                    }
                }
            }
            List libraries = MetadataManager.INSTANCE.getDataverseLibraries(mdTxnCtx, databaseName, dataverseName);
            for (Library library : libraries) {
                jobsToExecute.add(ExternalLibraryJobUtils.buildDropLibraryJobSpec(stmtDropDataverse.getNamespace(), library.getName(), metadataProvider));
            }
            jobsToExecute.add(DataverseUtil.dropDataverseJobSpec(dv, metadataProvider));
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, databaseName, dataverseName);
            MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(databaseName, dataverseName, dv.getDataFormat(), 2));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            this.runDropJobs(metadataProvider, hcc, feedsToStop, jobsToExecute);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, databaseName, dataverseName);
            for (Dataset dataset : datasets) {
                String nodeGroup = dataset.getNodeGroupName();
                this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
                if (MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup) == null) continue;
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodeGroup, true);
            }
            if (this.activeNamespace.getDataverseName().equals((Object)dataverseName)) {
                this.activeNamespace = MetadataBuiltinEntities.DEFAULT_NAMESPACE;
            }
            this.validateDatasetsStateAfterNamespaceDrop(metadataProvider, mdTxnCtx, datasets);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                if (this.activeNamespace.getDataverseName().equals((Object)dataverseName)) {
                    this.activeNamespace = MetadataBuiltinEntities.DEFAULT_NAMESPACE;
                }
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, databaseName, dataverseName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataverse(" + dataverseName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    protected boolean isDataverseNotEmpty(String database, DataverseName dataverseName, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        return MetadataManager.INSTANCE.isDataverseNotEmpty(mdTxnCtx, database, dataverseName);
    }

    protected void validateDatabaseStateBeforeDrop(MetadataProvider metadataProvider, Database database, SourceLocation sourceLoc) throws AlgebricksException, HyracksDataException {
    }

    protected void validateDataverseStateBeforeDrop(MetadataProvider metadataProvider, Dataverse dataverse, SourceLocation sourceLoc) throws AlgebricksException, HyracksDataException {
    }

    protected void validateDatasetsStateAfterNamespaceDrop(MetadataProvider metadataProvider, MetadataTransactionContext mdTxnCtx, List<Dataset> datasets) throws AlgebricksException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDatasetDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DropDatasetStatement stmtDelete = (DropDatasetStatement)stmt;
        SourceLocation sourceLoc = stmtDelete.getSourceLocation();
        String datasetName = stmtDelete.getDatasetName().getValue();
        metadataProvider.validateDatabaseObjectName(stmtDelete.getNamespace(), datasetName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDelete.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            this.doDropDataset(databaseName, dataverseName, datasetName, metadataProvider, stmtDelete.getIfExists(), hcc, requestParameters, true, sourceLoc);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropDataset(String databaseName, DataverseName dataverseName, String datasetName, MetadataProvider metadataProvider, boolean ifExists, IHyracksClientConnection hcc, IRequestParameters requestParameters, boolean dropCorrespondingNodeGroup, SourceLocation sourceLoc) throws Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        MutableObject mdTxnCtx = new MutableObject((Object)MetadataManager.INSTANCE.beginTransaction());
        MutableBoolean bActiveTxn = new MutableBoolean(true);
        metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        ArrayList jobsToExecute = new ArrayList();
        Dataset ds = null;
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse((MetadataTransactionContext)mdTxnCtx.getValue(), databaseName, dataverseName);
            if (dv == null) {
                if (ifExists) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)sourceLoc, (IError)ErrorCode.UNKNOWN_DATAVERSE, (Serializable[])new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())}));
                    }
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName, true);
            if (ds == null) {
                if (ifExists) {
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.VIEW) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            this.validateDatasetState(metadataProvider, ds, sourceLoc);
            ds.drop(metadataProvider, mdTxnCtx, jobsToExecute, bActiveTxn, progress, hcc, dropCorrespondingNodeGroup, sourceLoc, EnumSet.of(IndexDropOperatorDescriptor.DropOption.IF_EXISTS), requestParameters.isForceDropDataset());
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("failed to drop dataset; executing compensating operations", (Throwable)e);
            if (bActiveTxn.booleanValue()) {
                QueryTranslator.abort(e, e, (MetadataTransactionContext)mdTxnCtx.getValue());
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    if (ds != null) {
                        jobsToExecute.clear();
                        mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
                        bActiveTxn.setValue(true);
                        metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
                        ds.drop(metadataProvider, mdTxnCtx, jobsToExecute, bActiveTxn, progress, hcc, dropCorrespondingNodeGroup, sourceLoc, EnumSet.of(IndexDropOperatorDescriptor.DropOption.IF_EXISTS), requestParameters.isForceDropDataset());
                    }
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
                metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, requestParameters.isForceDropDataset());
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, (MetadataTransactionContext)mdTxnCtx.getValue());
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIndexDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        IndexDropStatement stmtIndexDrop = (IndexDropStatement)stmt;
        metadataProvider.validateDatabaseObjectName(stmtIndexDrop.getNamespace(), stmtIndexDrop.getIndexName().getValue(), stmtIndexDrop.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtIndexDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = stmtIndexDrop.getDatasetName().getValue();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropIndexBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            this.doDropIndex(metadataProvider, stmtIndexDrop, databaseName, dataverseName, datasetName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropIndex(MetadataProvider metadataProvider, IndexDropStatement stmtIndexDrop, String databaseName, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtIndexDrop.getSourceLocation();
        String indexName = stmtIndexDrop.getIndexName().getValue();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                Index index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return false;
                    }
                    throw new CompilationException(ErrorCode.UNKNOWN_INDEX, sourceLoc, new Serializable[]{indexName});
                }
                this.ensureNonPrimaryIndexDrop(index, sourceLoc);
                this.validateDatasetState(metadataProvider, ds, sourceLoc);
                this.prepareIndexDrop(metadataProvider, databaseName, dataverseName, datasetName, sourceLoc, indexName, jobsToExecute, mdTxnCtx, ds, index);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    this.runJob(hcc, jobSpec);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, indexName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + indexName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFullTextFilterDrop(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        FullTextFilterDropStatement stmtFilterDrop = (FullTextFilterDropStatement)stmt;
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtFilterDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String fullTextFilterName = stmtFilterDrop.getFilterName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropFullTextFilterBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, fullTextFilterName);
        try {
            this.doDropFullTextFilter(metadataProvider, stmtFilterDrop, databaseName, dataverseName, fullTextFilterName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doDropFullTextFilter(MetadataProvider metadataProvider, FullTextFilterDropStatement stmtFilterDrop, String databaseName, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException, RemoteException {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            FullTextFilterMetadataEntity filter = MetadataManager.INSTANCE.getFullTextFilter(mdTxnCtx, databaseName, dataverseName, fullTextFilterName);
            if (filter == null) {
                if (stmtFilterDrop.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.FULL_TEXT_FILTER_NOT_FOUND, stmtFilterDrop.getSourceLocation(), new Serializable[]{fullTextFilterName});
            }
            MetadataManager.INSTANCE.dropFullTextFilter(mdTxnCtx, databaseName, dataverseName, fullTextFilterName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFullTextConfigDrop(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws AlgebricksException, RemoteException {
        FullTextConfigDropStatement stmtConfigDrop = (FullTextConfigDropStatement)stmt;
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtConfigDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String configName = stmtConfigDrop.getConfigName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropFullTextConfigBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, configName);
        try {
            this.doDropFullTextConfig(metadataProvider, stmtConfigDrop, databaseName, dataverseName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void doDropFullTextConfig(MetadataProvider metadataProvider, FullTextConfigDropStatement stmtConfigDrop, String databaseName, DataverseName dataverseName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws RemoteException, AlgebricksException {
        if (Strings.isNullOrEmpty((String)stmtConfigDrop.getConfigName())) {
            throw new CompilationException(ErrorCode.FULL_TEXT_DEFAULT_CONFIG_CANNOT_BE_DELETED_OR_CREATED, stmtConfigDrop.getSourceLocation(), new Serializable[0]);
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        String fullTextConfigName = stmtConfigDrop.getConfigName();
        try {
            FullTextConfigMetadataEntity configMetadataEntity = MetadataManager.INSTANCE.getFullTextConfig(mdTxnCtx, databaseName, dataverseName, fullTextConfigName);
            if (configMetadataEntity == null) {
                if (stmtConfigDrop.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.FULL_TEXT_CONFIG_NOT_FOUND, stmtConfigDrop.getSourceLocation(), new Serializable[]{fullTextConfigName});
            }
            MetadataManager.INSTANCE.dropFullTextConfig(mdTxnCtx, databaseName, dataverseName, fullTextConfigName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected void handleTypeDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDropStatement stmtTypeDrop = (TypeDropStatement)stmt;
        SourceLocation sourceLoc = stmtTypeDrop.getSourceLocation();
        String typeName = stmtTypeDrop.getTypeName().getValue();
        metadataProvider.validateDatabaseObjectName(stmtTypeDrop.getNamespace(), typeName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtTypeDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.dropTypeBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, typeName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                if (stmtTypeDrop.getIfExists()) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)sourceLoc, (IError)ErrorCode.UNKNOWN_DATAVERSE, (Serializable[])new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())}));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, databaseName, dataverseName, typeName);
            if (dt == null) {
                if (!stmtTypeDrop.getIfExists()) {
                    throw new CompilationException(ErrorCode.UNKNOWN_TYPE, sourceLoc, new Serializable[]{typeName});
                }
            } else {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, databaseName, dataverseName, typeName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleNodegroupDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodeGroupDropStatement stmtDelete = (NodeGroupDropStatement)stmt;
        SourceLocation sourceLoc = stmtDelete.getSourceLocation();
        String nodegroupName = stmtDelete.getNodeGroupName().getValue();
        metadataProvider.validateDatabaseObjectName(null, nodegroupName, sourceLoc);
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodegroupName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodegroupName);
            if (ng == null) {
                if (!stmtDelete.getIfExists()) {
                    throw new CompilationException(ErrorCode.UNKNOWN_NODEGROUP, sourceLoc, new Serializable[]{nodegroupName});
                }
            } else {
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodegroupName, false);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateViewStatement(MetadataProvider metadataProvider, Statement stmt, IStatementRewriter stmtRewriter, IRequestParameters requestParameters) throws Exception {
        boolean viewItemTypeAnonymous;
        String viewItemTypeName;
        DataverseName viewItemTypeDataverseName;
        String itemTypeDatabaseName;
        CreateViewStatement cvs = (CreateViewStatement)stmt;
        String viewName = cvs.getViewName();
        metadataProvider.validateDatabaseObjectName(cvs.getNamespace(), viewName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(cvs.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (cvs.hasItemType()) {
            org.apache.hyracks.algebricks.common.utils.Triple<Namespace, String, Boolean> viewTypeQualifiedName = this.extractDatasetItemTypeName(stmtActiveNamespace, viewName, cvs.getItemType(), false, stmt.getSourceLocation());
            itemTypeDatabaseName = ((Namespace)viewTypeQualifiedName.first).getDatabaseName();
            viewItemTypeDataverseName = ((Namespace)viewTypeQualifiedName.first).getDataverseName();
            viewItemTypeName = (String)viewTypeQualifiedName.second;
            viewItemTypeAnonymous = (Boolean)viewTypeQualifiedName.third;
        } else {
            itemTypeDatabaseName = MetadataBuiltinEntities.ANY_OBJECT_DATATYPE.getDatabaseName();
            viewItemTypeDataverseName = MetadataBuiltinEntities.ANY_OBJECT_DATATYPE.getDataverseName();
            viewItemTypeName = MetadataBuiltinEntities.ANY_OBJECT_DATATYPE.getDatatypeName();
            viewItemTypeAnonymous = false;
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, viewName, itemTypeDatabaseName, viewItemTypeDataverseName, viewItemTypeName, viewItemTypeAnonymous, null, null, null, false, null, null, true, DatasetConfig.DatasetType.VIEW, null);
        try {
            this.doCreateView(metadataProvider, cvs, databaseName, dataverseName, viewName, itemTypeDatabaseName, viewItemTypeDataverseName, viewItemTypeName, stmtRewriter, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
            metadataProvider.setDefaultNamespace(this.activeNamespace);
        }
    }

    protected CreateResult doCreateView(MetadataProvider metadataProvider, CreateViewStatement cvs, String databaseName, DataverseName dataverseName, String viewName, String itemTypeDatabaseName, DataverseName itemTypeDataverseName, String itemTypeName, IStatementRewriter stmtRewriter, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = cvs.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Namespace ns = new Namespace(dv.getDatabaseName(), dv.getDataverseName());
            Dataset existingDataset = MetadataManager.INSTANCE.getDataset(mdTxnCtx, databaseName, dataverseName, viewName);
            if (existingDataset != null) {
                if (DatasetUtil.isNotView((Dataset)existingDataset)) {
                    throw new CompilationException(ErrorCode.DATASET_EXISTS, sourceLoc, new Serializable[]{existingDataset.getDatasetName(), existingDataset.getDataverseName()});
                }
                if (cvs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return CreateResult.NOOP;
                }
                if (!cvs.getReplaceIfExists()) {
                    throw new CompilationException(ErrorCode.VIEW_EXISTS, sourceLoc, new Serializable[]{existingDataset.getDatasetFullyQualifiedName()});
                }
            }
            DatasetFullyQualifiedName viewQualifiedName = new DatasetFullyQualifiedName(databaseName, dataverseName, viewName);
            Datatype itemTypeEntity = null;
            boolean itemTypeIsInline = false;
            CreateViewStatement.KeyDecl primaryKeyDecl = cvs.getPrimaryKeyDecl();
            List primaryKeyFields = null;
            List foreignKeyDecls = cvs.getForeignKeyDecls();
            ArrayList<ViewDetails.ForeignKey> foreignKeys = null;
            String datetimeFormat = null;
            String dateFormat = null;
            String timeFormat = null;
            if (cvs.hasItemType()) {
                Pair<Datatype, Boolean> itemTypePair = this.fetchDatasetItemType(mdTxnCtx, DatasetConfig.DatasetType.VIEW, DatasetConfig.DatasetFormat.ROW, null, itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, cvs.getItemType(), false, metadataProvider, sourceLoc);
                itemTypeEntity = (Datatype)itemTypePair.first;
                itemTypeIsInline = (Boolean)itemTypePair.second;
                ARecordType itemType = (ARecordType)itemTypeEntity.getDatatype();
                if (primaryKeyDecl != null) {
                    primaryKeyFields = ValidateUtil.validateViewKeyFields((CreateViewStatement.KeyDecl)primaryKeyDecl, (ARecordType)itemType, (boolean)false, (SourceLocation)sourceLoc);
                }
                if (foreignKeyDecls != null) {
                    foreignKeys = new ArrayList<ViewDetails.ForeignKey>(foreignKeyDecls.size());
                    for (CreateViewStatement.ForeignKeyDecl foreignKeyDecl : foreignKeyDecls) {
                        List refPrimaryKeyFields;
                        DatasetFullyQualifiedName refQualifiedName;
                        DatasetConfig.DatasetType refDatasetType;
                        boolean isSelfRef;
                        List foreignKeyFields = ValidateUtil.validateViewKeyFields((CreateViewStatement.KeyDecl)foreignKeyDecl, (ARecordType)itemType, (boolean)true, (SourceLocation)sourceLoc);
                        DataverseName refDataverseName = foreignKeyDecl.getReferencedDataverseName();
                        String refDatabaseName = foreignKeyDecl.getReferencedDatabaseName();
                        if (refDataverseName == null) {
                            refDataverseName = dataverseName;
                            refDatabaseName = databaseName;
                        } else {
                            Dataverse refDataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, refDatabaseName, refDataverseName);
                            if (refDataverse == null) {
                                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)refDatabaseName, (DataverseName)refDataverseName, (boolean)metadataProvider.isUsingDatabase())});
                            }
                        }
                        String refDatasetName = foreignKeyDecl.getReferencedDatasetName().getValue();
                        boolean bl = isSelfRef = refDatabaseName.equals(databaseName) && refDataverseName.equals((Object)dataverseName) && refDatasetName.equals(viewName);
                        if (isSelfRef) {
                            refDatasetType = DatasetConfig.DatasetType.VIEW;
                            refQualifiedName = viewQualifiedName;
                            refPrimaryKeyFields = primaryKeyFields;
                        } else {
                            Dataset refDataset = metadataProvider.findDataset(refDatabaseName, refDataverseName, refDatasetName, true);
                            if (refDataset == null || DatasetUtil.isNotView((Dataset)refDataset)) {
                                throw new CompilationException(ErrorCode.UNKNOWN_VIEW, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)refDataverseName, (String)refDatasetName)});
                            }
                            ViewDetails refViewDetails = (ViewDetails)refDataset.getDatasetDetails();
                            refDatasetType = refDataset.getDatasetType();
                            refQualifiedName = new DatasetFullyQualifiedName(refDatabaseName, refDataverseName, refDatasetName);
                            refPrimaryKeyFields = refViewDetails.getPrimaryKeyFields();
                        }
                        if (refPrimaryKeyFields == null) {
                            throw new CompilationException(ErrorCode.INVALID_FOREIGN_KEY_DEFINITION_REF_PK_NOT_FOUND, sourceLoc, new Serializable[]{DatasetUtil.getDatasetTypeDisplayName((DatasetConfig.DatasetType)refDatasetType), DatasetUtil.getFullyQualifiedDisplayName((DataverseName)refDataverseName, (String)refDatasetName)});
                        }
                        if (refPrimaryKeyFields.size() != foreignKeyFields.size()) {
                            throw new CompilationException(ErrorCode.INVALID_FOREIGN_KEY_DEFINITION_REF_PK_MISMATCH, sourceLoc, new Serializable[]{DatasetUtil.getDatasetTypeDisplayName((DatasetConfig.DatasetType)refDatasetType), DatasetUtil.getFullyQualifiedDisplayName((DataverseName)refDataverseName, (String)refDatasetName)});
                        }
                        if (isSelfRef && !OperatorPropertiesUtil.disjoint((Collection)refPrimaryKeyFields, (Collection)foreignKeyFields)) {
                            throw new CompilationException(ErrorCode.INVALID_FOREIGN_KEY_DEFINITION, sourceLoc, new Serializable[0]);
                        }
                        foreignKeys.add(new ViewDetails.ForeignKey(foreignKeyFields, refQualifiedName));
                    }
                }
                Map viewConfig = TypeUtil.validateConfiguration((Map)cvs.getViewConfiguration(), (SourceLocation)cvs.getSourceLocation());
                datetimeFormat = TypeUtil.getDatetimeFormat((Map)viewConfig);
                dateFormat = TypeUtil.getDateFormat((Map)viewConfig);
                timeFormat = TypeUtil.getTimeFormat((Map)viewConfig);
            } else {
                if (primaryKeyDecl != null) {
                    throw new CompilationException(ErrorCode.INVALID_PRIMARY_KEY_DEFINITION, cvs.getSourceLocation(), new Serializable[0]);
                }
                if (foreignKeyDecls != null) {
                    throw new CompilationException(ErrorCode.INVALID_FOREIGN_KEY_DEFINITION, cvs.getSourceLocation(), new Serializable[0]);
                }
                if (cvs.getViewConfiguration() != null) {
                    throw new CompilationException(ErrorCode.ILLEGAL_SET_PARAMETER, cvs.getSourceLocation(), new Serializable[]{(Serializable)cvs.getViewConfiguration().keySet().iterator().next()});
                }
            }
            if (existingDataset != null) {
                boolean allowToReplace;
                ViewDetails existingViewDetails = (ViewDetails)existingDataset.getDatasetDetails();
                List existingPrimaryKeyFields = existingViewDetails.getPrimaryKeyFields();
                boolean bl = allowToReplace = existingPrimaryKeyFields == null || existingPrimaryKeyFields.equals(primaryKeyFields);
                if (!allowToReplace) {
                    throw new CompilationException(ErrorCode.CANNOT_CHANGE_PRIMARY_KEY, cvs.getSourceLocation(), new Serializable[]{DatasetUtil.getDatasetTypeDisplayName((DatasetConfig.DatasetType)existingDataset.getDatasetType()), DatasetUtil.getFullyQualifiedDisplayName((Dataset)existingDataset)});
                }
            }
            ViewDecl viewDecl = new ViewDecl(viewQualifiedName, cvs.getViewBodyExpression());
            viewDecl.setSourceLocation(sourceLoc);
            IQueryRewriter queryRewriter = this.rewriterFactory.createQueryRewriter();
            Query wrappedQuery = queryRewriter.createViewAccessorQuery(viewDecl, metadataProvider.getNamespaceResolver());
            metadataProvider.setDefaultNamespace(ns);
            LangRewritingContext langRewritingContext = this.createLangRewritingContext(metadataProvider, this.declaredFunctions, Collections.singletonList(viewDecl), (IWarningCollector)this.warningCollector, wrappedQuery.getVarCounter());
            this.apiFramework.reWriteQuery(langRewritingContext, (IReturningStatement)wrappedQuery, this.sessionOutput, false, false, Collections.emptyList());
            List dependencies = ViewUtil.getViewDependencies((ViewDecl)viewDecl, foreignKeys, (IQueryRewriter)queryRewriter);
            ViewDetails viewDetails = new ViewDetails(cvs.getViewBody(), dependencies, cvs.getDefaultNull(), primaryKeyFields, foreignKeys, datetimeFormat, dateFormat, timeFormat);
            Dataset view = new Dataset(databaseName, dataverseName, viewName, itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, "MetadataGroup", "", Collections.emptyMap(), (IDatasetDetails)viewDetails, Collections.emptyMap(), DatasetConfig.DatasetType.VIEW, 0, 0);
            if (existingDataset == null) {
                if (itemTypeIsInline) {
                    MetadataManager.INSTANCE.addDatatype(mdTxnCtx, itemTypeEntity);
                }
                MetadataManager.INSTANCE.addDataset(mdTxnCtx, view);
            } else {
                if (itemTypeIsInline) {
                    MetadataManager.INSTANCE.updateDatatype(mdTxnCtx, itemTypeEntity);
                }
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, view);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return existingDataset != null ? CreateResult.REPLACED : CreateResult.CREATED;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        ViewDropStatement stmtDrop = (ViewDropStatement)stmt;
        SourceLocation sourceLoc = stmtDrop.getSourceLocation();
        String viewName = stmtDrop.getViewName().getValue();
        metadataProvider.validateDatabaseObjectName(stmtDrop.getNamespace(), viewName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, viewName);
        try {
            this.doDropView(metadataProvider, stmtDrop, databaseName, dataverseName, viewName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropView(MetadataProvider metadataProvider, ViewDropStatement stmtViewDrop, String databaseName, DataverseName dataverseName, String viewName) throws Exception {
        SourceLocation sourceLoc = stmtViewDrop.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                if (stmtViewDrop.getIfExists()) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)stmtViewDrop.getSourceLocation(), (IError)ErrorCode.UNKNOWN_DATAVERSE, (Serializable[])new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())}));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Dataset dataset = metadataProvider.findDataset(databaseName, dataverseName, viewName, true);
            if (dataset == null) {
                if (stmtViewDrop.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_VIEW, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)dataverseName, (String)viewName)});
            }
            if (DatasetUtil.isNotView((Dataset)dataset)) {
                throw new CompilationException(ErrorCode.UNKNOWN_VIEW, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)dataverseName, (String)viewName)});
            }
            MetadataManager.INSTANCE.dropDataset(mdTxnCtx, databaseName, dataverseName, viewName, false);
            String itemTypeDatabaseName = dataset.getItemTypeDatabaseName();
            if (TypeUtil.isDatasetInlineTypeName((Dataset)dataset, (String)itemTypeDatabaseName, (DataverseName)dataset.getItemTypeDataverseName(), (String)dataset.getItemTypeName())) {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, itemTypeDatabaseName, dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected void handleDeclareFunctionStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        FunctionDecl fds = (FunctionDecl)stmt;
        FunctionSignature signature = fds.getSignature();
        DataverseName funDataverse = signature.getDataverseName();
        Namespace funNamespace = signature.getNamespace();
        metadataProvider.validateDatabaseObjectName(funNamespace, signature.getName(), stmt.getSourceLocation());
        if (funDataverse == null) {
            signature.setDataverseName(this.activeNamespace.getDatabaseName(), this.activeNamespace.getDataverseName());
        }
        this.declaredFunctions.add(fds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateFunctionStatement(MetadataProvider metadataProvider, Statement stmt, IStatementRewriter stmtRewriter, IRequestParameters requestParameters) throws Exception {
        String databaseName;
        DataverseName dataverseName;
        CreateFunctionStatement cfs = (CreateFunctionStatement)stmt;
        FunctionSignature signature = cfs.getFunctionSignature();
        DataverseName funDataverse = signature.getDataverseName();
        Namespace funNamespace = signature.getNamespace();
        metadataProvider.validateDatabaseObjectName(funNamespace, signature.getName(), stmt.getSourceLocation());
        if (funDataverse == null) {
            dataverseName = this.activeNamespace.getDataverseName();
            databaseName = this.activeNamespace.getDatabaseName();
            signature.setDataverseName(databaseName, dataverseName);
        } else {
            dataverseName = funDataverse;
            databaseName = signature.getDatabaseName();
        }
        DataverseName libraryDataverseName = null;
        String libraryDatabaseName = null;
        String libraryName = cfs.getLibraryName();
        if (libraryName != null) {
            libraryDataverseName = cfs.getLibraryDataverseName();
            libraryDatabaseName = cfs.getLibraryDatabaseName();
            if (libraryDataverseName == null) {
                libraryDataverseName = dataverseName;
                libraryDatabaseName = databaseName;
            }
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createFunctionBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, signature.getName(), libraryDatabaseName, libraryDataverseName, libraryName);
        try {
            this.doCreateFunction(metadataProvider, cfs, signature, stmtRewriter, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
            metadataProvider.setDefaultNamespace(this.activeNamespace);
        }
    }

    protected CreateResult doCreateFunction(MetadataProvider metadataProvider, CreateFunctionStatement cfs, FunctionSignature functionSignature, IStatementRewriter stmtRewriter, IRequestParameters requestParameters) throws Exception {
        DataverseName dataverseName = functionSignature.getDataverseName();
        String databaseName = functionSignature.getDatabaseName();
        SourceLocation sourceLoc = cfs.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Function function;
            Map newInlineTypes;
            int paramCount;
            List paramList;
            List existingInlineTypes;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Namespace ns = new Namespace(dv.getDatabaseName(), dv.getDataverseName());
            Function existingFunction = MetadataManager.INSTANCE.getFunction(mdTxnCtx, functionSignature);
            if (existingFunction != null) {
                if (cfs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return CreateResult.NOOP;
                }
                if (!cfs.getReplaceIfExists()) {
                    throw new CompilationException(ErrorCode.FUNCTION_EXISTS, cfs.getSourceLocation(), new Serializable[]{functionSignature.toString(false)});
                }
                existingInlineTypes = TypeUtil.getFunctionInlineTypes((Function)existingFunction);
            } else {
                existingInlineTypes = Collections.emptyList();
            }
            IQueryRewriter queryRewriter = this.rewriterFactory.createQueryRewriter();
            if (cfs.isExternal()) {
                String libraryName;
                Library library;
                Datatype returnInlineTypeEntity;
                TypeSignature returnDepTypeSignature;
                TypeSignature returnTypeSignature;
                if (functionSignature.getArity() == -1) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, cfs.getSourceLocation(), new Serializable[]{"Variable number of parameters is not supported for external functions"});
                }
                paramList = cfs.getParameters();
                paramCount = paramList.size();
                ArrayList<String> paramNames = new ArrayList<String>(paramCount);
                ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>(paramCount);
                LinkedHashSet depTypes = new LinkedHashSet();
                newInlineTypes = new HashMap<TypeSignature, Datatype>();
                for (int i = 0; i < paramCount; ++i) {
                    Datatype paramInlineTypeEntity;
                    TypeSignature paramDepTypeSignature;
                    TypeSignature paramTypeSignature;
                    Pair paramPair = (Pair)paramList.get(i);
                    TypeExpression paramTypeExpr = (TypeExpression)paramPair.getSecond();
                    if (paramTypeExpr != null) {
                        org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> paramTypeInfo = this.translateFunctionParameterType(functionSignature, i, paramTypeExpr, sourceLoc, metadataProvider, mdTxnCtx);
                        paramTypeSignature = (TypeSignature)paramTypeInfo.first;
                        paramDepTypeSignature = (TypeSignature)paramTypeInfo.second;
                        paramInlineTypeEntity = (Datatype)paramTypeInfo.third;
                    } else {
                        paramTypeSignature = null;
                        paramDepTypeSignature = null;
                        paramInlineTypeEntity = null;
                    }
                    paramTypes.add(paramTypeSignature);
                    if (paramDepTypeSignature != null) {
                        depTypes.add(paramDepTypeSignature);
                    }
                    if (paramInlineTypeEntity != null) {
                        newInlineTypes.put(paramTypeSignature, paramInlineTypeEntity);
                    }
                    VarIdentifier paramName = (VarIdentifier)paramPair.getFirst();
                    paramNames.add(queryRewriter.toFunctionParameterName(paramName));
                }
                TypeExpression returnTypeExpr = cfs.getReturnType();
                if (returnTypeExpr != null) {
                    org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> returnTypeInfo = this.translateFunctionParameterType(functionSignature, -1, returnTypeExpr, sourceLoc, metadataProvider, mdTxnCtx);
                    returnTypeSignature = (TypeSignature)returnTypeInfo.first;
                    returnDepTypeSignature = (TypeSignature)returnTypeInfo.second;
                    returnInlineTypeEntity = (Datatype)returnTypeInfo.third;
                } else {
                    returnTypeSignature = null;
                    returnDepTypeSignature = null;
                    returnInlineTypeEntity = null;
                }
                if (returnDepTypeSignature != null) {
                    depTypes.add(returnDepTypeSignature);
                }
                if (returnInlineTypeEntity != null) {
                    newInlineTypes.put(returnTypeSignature, returnInlineTypeEntity);
                }
                DataverseName libraryDataverseName = cfs.getLibraryDataverseName();
                String libraryDatabaseName = cfs.getLibraryDatabaseName();
                if (libraryDataverseName == null) {
                    libraryDataverseName = dataverseName;
                    libraryDatabaseName = databaseName;
                }
                if ((library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, libraryDatabaseName, libraryDataverseName, libraryName = cfs.getLibraryName())) == null) {
                    throw new CompilationException(ErrorCode.UNKNOWN_LIBRARY, sourceLoc, new Serializable[]{libraryName});
                }
                ExternalFunctionLanguage language = ExternalFunctionCompilerUtil.getExternalFunctionLanguage((String)library.getLanguage());
                List externalIdentifier = cfs.getExternalIdentifier();
                ExternalFunctionCompilerUtil.validateExternalIdentifier((List)externalIdentifier, (ExternalFunctionLanguage)language, (SourceLocation)cfs.getSourceLocation());
                List dependencies = FunctionUtil.getExternalFunctionDependencies((Collection)depTypes);
                function = new Function(functionSignature, paramNames, paramTypes, returnTypeSignature, null, AbstractFunctionCallExpression.FunctionKind.SCALAR.toString(), library.getLanguage(), libraryDatabaseName, libraryDataverseName, libraryName, externalIdentifier, Boolean.valueOf(cfs.getNullCall()), Boolean.valueOf(cfs.getDeterministic()), cfs.getResources(), dependencies);
            } else {
                paramList = cfs.getParameters();
                paramCount = paramList.size();
                ArrayList<VarIdentifier> paramVars = new ArrayList<VarIdentifier>(paramCount);
                ArrayList<String> paramNames = new ArrayList<String>(paramCount);
                for (Pair paramPair : paramList) {
                    VarIdentifier paramName = (VarIdentifier)paramPair.getFirst();
                    paramVars.add(paramName);
                    paramNames.add(queryRewriter.toFunctionParameterName(paramName));
                    if (paramPair.getSecond() == null) continue;
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{paramName.toString()});
                }
                FunctionDecl fd = new FunctionDecl(functionSignature, paramVars, cfs.getFunctionBodyExpression(), true);
                fd.setSourceLocation(sourceLoc);
                Query wrappedQuery = queryRewriter.createFunctionAccessorQuery(fd);
                ArrayList<FunctionDecl> fdList = new ArrayList<FunctionDecl>(this.declaredFunctions.size() + 1);
                fdList.addAll(this.declaredFunctions);
                fdList.add(fd);
                metadataProvider.setDefaultNamespace(ns);
                LangRewritingContext langRewritingContext = this.createLangRewritingContext(metadataProvider, fdList, null, (IWarningCollector)this.warningCollector, wrappedQuery.getVarCounter());
                this.apiFramework.reWriteQuery(langRewritingContext, (IReturningStatement)wrappedQuery, this.sessionOutput, false, false, Collections.emptyList());
                List dependencies = FunctionUtil.getFunctionDependencies((FunctionDecl)fd, (IQueryRewriter)queryRewriter);
                newInlineTypes = Collections.emptyMap();
                function = new Function(functionSignature, paramNames, null, null, cfs.getFunctionBody(), AbstractFunctionCallExpression.FunctionKind.SCALAR.toString(), this.compilationProvider.getParserFactory().getLanguage(), null, null, null, null, null, null, null, dependencies);
            }
            if (existingFunction == null) {
                for (Datatype newInlineType : newInlineTypes.values()) {
                    MetadataManager.INSTANCE.addDatatype(mdTxnCtx, newInlineType);
                }
                MetadataManager.INSTANCE.addFunction(mdTxnCtx, function);
            } else {
                for (TypeSignature existingInlineType : existingInlineTypes) {
                    Datatype newInlineType;
                    Datatype datatype = newInlineType = newInlineTypes.isEmpty() ? null : (Datatype)newInlineTypes.remove(existingInlineType);
                    if (newInlineType == null) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, existingInlineType.getDatabaseName(), existingInlineType.getDataverseName(), existingInlineType.getName());
                        continue;
                    }
                    MetadataManager.INSTANCE.updateDatatype(mdTxnCtx, newInlineType);
                }
                for (Datatype inlineType : newInlineTypes.values()) {
                    MetadataManager.INSTANCE.addDatatype(mdTxnCtx, inlineType);
                }
                MetadataManager.INSTANCE.updateFunction(mdTxnCtx, function);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Installed function: " + functionSignature);
            }
            return existingFunction != null ? CreateResult.REPLACED : CreateResult.CREATED;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> translateFunctionParameterType(FunctionSignature functionSignature, int paramIdx, TypeExpression paramTypeExpr, SourceLocation sourceLoc, MetadataProvider metadataProvider, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        TypeSignature depTypeSignature;
        TypeSignature paramTypeSignature;
        Datatype paramInlineTypeEntity = null;
        switch (paramTypeExpr.getTypeKind()) {
            case TYPEREFERENCE: {
                String paramTypeDatabaseName;
                DataverseName paramTypeDataverseName;
                TypeReferenceExpression paramTypeRefExpr = (TypeReferenceExpression)paramTypeExpr;
                String paramTypeName = ((Identifier)paramTypeRefExpr.getIdent().second).getValue();
                BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)paramTypeName);
                if (builtinType != null) {
                    paramTypeSignature = new TypeSignature(builtinType);
                    depTypeSignature = null;
                    break;
                }
                Namespace paramTypeRefNamespace = (Namespace)paramTypeRefExpr.getIdent().first;
                if (paramTypeRefNamespace == null) {
                    paramTypeDataverseName = functionSignature.getDataverseName();
                    paramTypeDatabaseName = functionSignature.getDatabaseName();
                } else {
                    paramTypeDataverseName = paramTypeRefNamespace.getDataverseName();
                    paramTypeDatabaseName = paramTypeRefNamespace.getDatabaseName();
                }
                Datatype paramTypeEntity = metadataProvider.findTypeEntity(paramTypeDatabaseName, paramTypeDataverseName, paramTypeName);
                if (paramTypeEntity == null || paramTypeEntity.getIsAnonymous()) {
                    throw new CompilationException(ErrorCode.UNKNOWN_TYPE, sourceLoc, new Serializable[]{paramTypeName});
                }
                paramTypeSignature = depTypeSignature = new TypeSignature(paramTypeDatabaseName, paramTypeDataverseName, paramTypeName);
                break;
            }
            case ORDEREDLIST: 
            case UNORDEREDLIST: {
                DataverseName paramTypeDataverseName = functionSignature.getDataverseName();
                String paramTypeDatabaseName = functionSignature.getDatabaseName();
                String paramTypeName = TypeUtil.createFunctionParameterTypeName((String)functionSignature.getName(), (int)functionSignature.getArity(), (int)paramIdx);
                IAType paramType = this.translateType(paramTypeDatabaseName, paramTypeDataverseName, paramTypeName, paramTypeExpr, mdTxnCtx);
                paramTypeSignature = new TypeSignature(paramTypeDatabaseName, paramTypeDataverseName, paramTypeName);
                depTypeSignature = FunctionUtil.getTypeDependencyFromFunctionParameter((TypeExpression)paramTypeExpr, (String)paramTypeDatabaseName, (DataverseName)paramTypeDataverseName);
                paramInlineTypeEntity = new Datatype(paramTypeDatabaseName, paramTypeDataverseName, paramTypeName, paramType, true);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[0]);
            }
        }
        return new org.apache.hyracks.algebricks.common.utils.Triple((Object)paramTypeSignature, depTypeSignature, paramInlineTypeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFunctionDropStatement(MetadataProvider metadataProvider, Statement stmt, IRequestParameters requestParameters) throws Exception {
        String databaseName;
        DataverseName dataverseName;
        FunctionDropStatement stmtDropFunction = (FunctionDropStatement)stmt;
        FunctionSignature signature = stmtDropFunction.getFunctionSignature();
        DataverseName funDataverse = signature.getDataverseName();
        Namespace funNamespace = signature.getNamespace();
        metadataProvider.validateDatabaseObjectName(funNamespace, signature.getName(), stmtDropFunction.getSourceLocation());
        if (funDataverse == null) {
            dataverseName = this.activeNamespace.getDataverseName();
            databaseName = this.activeNamespace.getDatabaseName();
            signature.setDataverseName(databaseName, dataverseName);
        } else {
            dataverseName = funDataverse;
            databaseName = signature.getDatabaseName();
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropFunctionBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, signature.getName());
        try {
            this.doDropFunction(metadataProvider, stmtDropFunction, signature, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropFunction(MetadataProvider metadataProvider, FunctionDropStatement stmtDropFunction, FunctionSignature signature, IRequestParameters requestParameters) throws Exception {
        DataverseName dataverseName = signature.getDataverseName();
        String databaseName = signature.getDatabaseName();
        SourceLocation sourceLoc = stmtDropFunction.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dataverse == null) {
                if (stmtDropFunction.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
            if (function == null) {
                if (stmtDropFunction.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, sourceLoc, new Serializable[]{signature.toString()});
            }
            List inlineTypes = TypeUtil.getFunctionInlineTypes((Function)function);
            MetadataManager.INSTANCE.dropFunction(mdTxnCtx, signature);
            for (TypeSignature inlineType : inlineTypes) {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, inlineType.getDatabaseName(), inlineType.getDataverseName(), inlineType.getName());
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateAdapterStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateAdapterStatement cas = (CreateAdapterStatement)stmt;
        String adapterName = cas.getAdapterName();
        metadataProvider.validateDatabaseObjectName(cas.getNamespace(), adapterName, cas.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(cas.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        DataverseName libraryDataverseName = cas.getLibraryDataverseName();
        String libraryDatabaseName = cas.getLibraryDatabaseName();
        if (libraryDataverseName == null) {
            libraryDataverseName = dataverseName;
            libraryDatabaseName = databaseName;
        }
        String libraryName = cas.getLibraryName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createAdapterBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, adapterName, libraryDatabaseName, libraryDataverseName, libraryName);
        try {
            this.doCreateAdapter(metadataProvider, databaseName, dataverseName, cas);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateAdapter(MetadataProvider metadataProvider, String databaseName, DataverseName dataverseName, CreateAdapterStatement cas) throws Exception {
        SourceLocation sourceLoc = cas.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            String libraryName;
            Library library;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            String adapterName = cas.getAdapterName();
            DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, databaseName, dataverseName, adapterName);
            if (adapter != null) {
                if (cas.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.ADAPTER_EXISTS, sourceLoc, new Serializable[]{adapterName});
            }
            DataverseName libraryDataverseName = cas.getLibraryDataverseName();
            String libraryDatabaseName = cas.getLibraryDatabaseName();
            if (libraryDataverseName == null) {
                libraryDataverseName = dataverseName;
                libraryDatabaseName = databaseName;
            }
            if ((library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, libraryDatabaseName, libraryDataverseName, libraryName = cas.getLibraryName())) == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_LIBRARY, sourceLoc, new Serializable[]{libraryName});
            }
            ExternalFunctionLanguage language = ExternalFunctionCompilerUtil.getExternalFunctionLanguage((String)library.getLanguage());
            List externalIdentifier = cas.getExternalIdentifier();
            ExternalFunctionCompilerUtil.validateExternalIdentifier((List)externalIdentifier, (ExternalFunctionLanguage)language, (SourceLocation)cas.getSourceLocation());
            if (language != ExternalFunctionLanguage.JAVA) {
                throw new CompilationException(ErrorCode.UNSUPPORTED_ADAPTER_LANGUAGE, cas.getSourceLocation(), new Serializable[]{language.name()});
            }
            String adapterFactoryClass = (String)externalIdentifier.get(0);
            adapter = new DatasourceAdapter(new AdapterIdentifier(databaseName, dataverseName, adapterName), IDataSourceAdapter.AdapterType.EXTERNAL, adapterFactoryClass, libraryDatabaseName, libraryDataverseName, libraryName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Installed adapter: " + adapterName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAdapterDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        AdapterDropStatement stmtDropAdapter = (AdapterDropStatement)stmt;
        SourceLocation sourceLoc = stmtDropAdapter.getSourceLocation();
        String adapterName = stmtDropAdapter.getAdapterName();
        metadataProvider.validateDatabaseObjectName(stmtDropAdapter.getNamespace(), adapterName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDropAdapter.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropAdapterBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, adapterName);
        try {
            this.doDropAdapter(metadataProvider, stmtDropAdapter, databaseName, dataverseName, adapterName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropAdapter(MetadataProvider metadataProvider, AdapterDropStatement stmtDropAdapter, String databaseName, DataverseName dataverseName, String adapterName) throws Exception {
        SourceLocation sourceLoc = stmtDropAdapter.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dataverse == null) {
                if (stmtDropAdapter.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, databaseName, dataverseName, adapterName);
            if (adapter == null) {
                if (stmtDropAdapter.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_ADAPTER, sourceLoc, new Serializable[]{adapterName});
            }
            MetadataManager.INSTANCE.dropAdapter(mdTxnCtx, databaseName, dataverseName, adapterName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateLibraryStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        CreateLibraryStatement cls = (CreateLibraryStatement)stmt;
        metadataProvider.validateDatabaseObjectName(cls.getNamespace(), cls.getLibraryName(), cls.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(cls.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String libraryName = cls.getLibraryName();
        String libraryHash = cls.getHash();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createLibraryBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, libraryName);
        try {
            this.doCreateLibrary(metadataProvider, databaseName, dataverseName, libraryName, libraryHash, cls, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected CreateResult doCreateLibrary(MetadataProvider metadataProvider, String databaseName, DataverseName dataverseName, String libraryName, String libraryHash, CreateLibraryStatement cls, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        boolean prepareJobSuccessful = false;
        JobSpecification abortJobSpec = null;
        Library existingLibrary = null;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        Namespace stmtActiveNamespace = this.getActiveNamespace(cls.getNamespace());
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            ExternalFunctionLanguage language = cls.getLang();
            existingLibrary = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
            if (existingLibrary != null && !cls.getReplaceIfExists()) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"A library with this name " + libraryName + " already exists."});
            }
            Library libraryPendingAdd = new Library(databaseName, dataverseName, libraryName, language.name(), libraryHash, 1);
            if (existingLibrary == null) {
                MetadataManager.INSTANCE.addLibrary(mdTxnCtx, libraryPendingAdd);
            } else {
                MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, libraryPendingAdd);
            }
            org.apache.hyracks.algebricks.common.utils.Triple<JobSpecification, JobSpecification, JobSpecification> jobSpecs = ExternalLibraryJobUtils.buildCreateLibraryJobSpec(stmtActiveNamespace, libraryName, language, cls.getLocation(), cls.getAuthToken(), metadataProvider);
            JobSpecification prepareJobSpec = (JobSpecification)jobSpecs.first;
            JobSpecification commitJobSpec = (JobSpecification)jobSpecs.second;
            abortJobSpec = (JobSpecification)jobSpecs.third;
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, prepareJobSpec, this.jobFlags);
            prepareJobSuccessful = true;
            QueryTranslator.runJob(hcc, commitJobSpec, this.jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            Library newLibrary = new Library(databaseName, dataverseName, libraryName, language.name(), libraryHash, 0);
            MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, newLibrary);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return existingLibrary != null ? CreateResult.REPLACED : CreateResult.CREATED;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                boolean undoFailure = false;
                if (!prepareJobSuccessful) {
                    try {
                        QueryTranslator.runJob(hcc, abortJobSpec, this.jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        undoFailure = true;
                    }
                } else if (existingLibrary == null) {
                    try {
                        JobSpecification dropLibraryJobSpec = ExternalLibraryJobUtils.buildDropLibraryJobSpec(stmtActiveNamespace, libraryName, metadataProvider);
                        QueryTranslator.runJob(hcc, dropLibraryJobSpec, this.jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        undoFailure = true;
                    }
                } else {
                    undoFailure = true;
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    if (existingLibrary == null) {
                        MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
                    } else {
                        MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, existingLibrary);
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending library(" + libraryName + ") couldn't be reverted/removed from the metadata", e);
                }
                if (undoFailure) {
                    throw new IllegalStateException("System is inconsistent state: library(" + libraryName + ") couldn't be deployed", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLibraryDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        LibraryDropStatement stmtDropLibrary = (LibraryDropStatement)stmt;
        String libraryName = stmtDropLibrary.getLibraryName();
        metadataProvider.validateDatabaseObjectName(stmtDropLibrary.getNamespace(), libraryName, stmtDropLibrary.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDropLibrary.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropLibraryBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, libraryName);
        try {
            this.doDropLibrary(metadataProvider, stmtDropLibrary, databaseName, dataverseName, libraryName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropLibrary(MetadataProvider metadataProvider, LibraryDropStatement stmtDropLibrary, String databaseName, DataverseName dataverseName, String libraryName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDropLibrary.getNamespace());
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dataverse == null) {
                if (stmtDropLibrary.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, stmtDropLibrary.getSourceLocation(), new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Library library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
            if (library == null) {
                if (stmtDropLibrary.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_LIBRARY, stmtDropLibrary.getSourceLocation(), new Serializable[]{libraryName});
            }
            MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
            MetadataManager.INSTANCE.addLibrary(mdTxnCtx, new Library(databaseName, dataverseName, libraryName, library.getLanguage(), library.getHash(), 2));
            JobSpecification jobSpec = ExternalLibraryJobUtils.buildDropLibraryJobSpec(stmtActiveNamespace, libraryName, metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, jobSpec, this.jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, databaseName, dataverseName, libraryName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending library(" + libraryName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateSynonymStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateSynonymStatement css = (CreateSynonymStatement)stmt;
        metadataProvider.validateDatabaseObjectName(css.getNamespace(), css.getSynonymName(), css.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(css.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String synonymName = css.getSynonymName();
        Namespace objectNamespace = css.getObjectNamespace() != null ? css.getObjectNamespace() : stmtActiveNamespace;
        String objectName = css.getObjectName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createSynonymBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, synonymName);
        try {
            this.doCreateSynonym(metadataProvider, css, stmtActiveNamespace, synonymName, objectNamespace, objectName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected CreateResult doCreateSynonym(MetadataProvider metadataProvider, CreateSynonymStatement css, Namespace namespace, String synonymName, Namespace objectNamespace, String objectName) throws Exception {
        String databaseName = namespace.getDatabaseName();
        DataverseName dataverseName = namespace.getDataverseName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, css.getSourceLocation(), new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            Synonym synonym = MetadataManager.INSTANCE.getSynonym(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, synonymName);
            if (synonym != null) {
                if (css.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(Warning.of((SourceLocation)css.getSourceLocation(), (IError)ErrorCode.SYNONYM_EXISTS, (Serializable[])new Serializable[]{synonymName}));
                    }
                    return CreateResult.NOOP;
                }
                throw new CompilationException(ErrorCode.SYNONYM_EXISTS, css.getSourceLocation(), new Serializable[]{synonymName});
            }
            synonym = new Synonym(databaseName, dataverseName, synonymName, objectNamespace.getDatabaseName(), objectNamespace.getDataverseName(), objectName);
            MetadataManager.INSTANCE.addSynonym(metadataProvider.getMetadataTxnContext(), synonym);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return CreateResult.CREATED;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDropSynonymStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        SynonymDropStatement stmtSynDrop = (SynonymDropStatement)stmt;
        String synonymName = stmtSynDrop.getSynonymName();
        metadataProvider.validateDatabaseObjectName(stmtSynDrop.getNamespace(), synonymName, stmtSynDrop.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtSynDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.dropSynonymBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, synonymName);
        try {
            this.doDropSynonym(metadataProvider, stmtSynDrop, databaseName, dataverseName, synonymName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropSynonym(MetadataProvider metadataProvider, SynonymDropStatement stmtSynDrop, String databaseName, DataverseName dataverseName, String synonymName) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Synonym synonym = MetadataManager.INSTANCE.getSynonym(mdTxnCtx, databaseName, dataverseName, synonymName);
            if (synonym == null) {
                if (stmtSynDrop.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(ErrorCode.UNKNOWN_SYNONYM, stmtSynDrop.getSourceLocation(), new Serializable[]{synonymName});
            }
            MetadataManager.INSTANCE.dropSynonym(mdTxnCtx, databaseName, dataverseName, synonymName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected void handleLoadStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        LoadStatement loadStmt = (LoadStatement)stmt;
        String datasetName = loadStmt.getDatasetName();
        metadataProvider.validateDatabaseObjectName(loadStmt.getNamespace(), datasetName, loadStmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(loadStmt.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.modifyDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            Map properties = loadStmt.getProperties();
            ExternalDataUtils.normalize((Map)properties);
            ExternalDataUtils.validate((Map)properties);
            CompiledStatements.CompiledLoadFromFileStatement cls = new CompiledStatements.CompiledLoadFromFileStatement(databaseName, dataverseName, loadStmt.getDatasetName(), loadStmt.getAdapter(), properties, loadStmt.dataIsAlreadySorted());
            cls.setSourceLocation(stmt.getSourceLocation());
            JobSpecification spec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, null, 0, null, this.sessionOutput, (CompiledStatements.ICompiledStatement)cls, null, this.responsePrinter, (IWarningCollector)this.warningCollector, null, this.jobFlags);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (spec != null && !this.isCompileOnly()) {
                this.runJob(hcc, spec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected Map<String, String> createExternalDataPropertiesForCopyFromStmt(String databaseName, DataverseName dataverseName, CopyFromStatement copyFromStatement, Datatype itemType, MetadataTransactionContext mdTxnCtx, MetadataProvider md) throws AlgebricksException {
        ExternalDetailsDecl edd = copyFromStatement.getExternalDetails();
        Map properties = copyFromStatement.getExternalDetails().getProperties();
        String path = copyFromStatement.getPath();
        String pathKey = ExternalDataUtils.getPathKey((String)edd.getAdapter());
        properties.put(pathKey, path);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCopyFromStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        block14: {
            CopyFromStatement copyStmt = (CopyFromStatement)stmt;
            String datasetName = copyStmt.getDatasetName();
            metadataProvider.validateDatabaseObjectName(copyStmt.getNamespace(), datasetName, copyStmt.getSourceLocation());
            Namespace stmtActiveNamespace = this.getActiveNamespace(copyStmt.getNamespace());
            DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
            String databaseName = stmtActiveNamespace.getDatabaseName();
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            this.lockUtil.insertDeleteUpsertBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
            JobId jobId = null;
            boolean atomic = false;
            try {
                metadataProvider.setWriteTransaction(true);
                Dataset dataset = metadataProvider.findDataset(databaseName, dataverseName, copyStmt.getDatasetName());
                if (dataset == null) {
                    throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, stmt.getSourceLocation(), new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
                }
                Datatype itemType = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
                if (copyStmt.getTypeExpr() != null) {
                    TypeExpression itemTypeExpr = copyStmt.getTypeExpr();
                    org.apache.hyracks.algebricks.common.utils.Triple<Namespace, String, Boolean> itemTypeQualifiedName = this.extractDatasetItemTypeName(stmtActiveNamespace, datasetName, itemTypeExpr, false, stmt.getSourceLocation());
                    Namespace itemTypeNamespace = (Namespace)itemTypeQualifiedName.first;
                    DataverseName itemTypeDataverseName = itemTypeNamespace.getDataverseName();
                    String itemTypeName = (String)itemTypeQualifiedName.second;
                    String itemTypeDatabaseName = itemTypeNamespace.getDatabaseName();
                    IAType itemTypeEntity = this.translateType(itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, itemTypeExpr, mdTxnCtx);
                    itemType = new Datatype(itemTypeDatabaseName, itemTypeDataverseName, itemTypeName, itemTypeEntity, true);
                }
                ExternalDetailsDecl externalDetails = copyStmt.getExternalDetails();
                Map<String, String> properties = this.createExternalDataPropertiesForCopyFromStmt(databaseName, dataverseName, copyStmt, itemType, mdTxnCtx, metadataProvider);
                ExternalDataUtils.normalize(properties);
                ExternalDataUtils.validate(properties);
                this.validateExternalDatasetProperties(externalDetails, properties, copyStmt.getSourceLocation(), mdTxnCtx, (IApplicationContext)this.appCtx);
                CompiledStatements.CompiledCopyFromFileStatement cls = new CompiledStatements.CompiledCopyFromFileStatement(databaseName, dataverseName, copyStmt.getDatasetName(), itemType, externalDetails.getAdapter(), properties);
                cls.setSourceLocation(stmt.getSourceLocation());
                JobSpecification spec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, null, 0, null, this.sessionOutput, (CompiledStatements.ICompiledStatement)cls, null, this.responsePrinter, (IWarningCollector)this.warningCollector, null, this.jobFlags);
                this.afterCompile();
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                if (spec == null || this.isCompileOnly()) break block14;
                atomic = dataset.isAtomic();
                if (atomic) {
                    int numParticipatingNodes = this.appCtx.getNodeJobTracker().getJobParticipatingNodes(spec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class).size();
                    int numParticipatingPartitions = this.appCtx.getNodeJobTracker().getNumParticipatingPartitions(spec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class);
                    ArrayList<Integer> participatingDatasetIds = new ArrayList<Integer>();
                    participatingDatasetIds.add(dataset.getDatasetId());
                    spec.setProperty("GlobalTxProperty", (Serializable)new GlobalTxInfo(participatingDatasetIds, numParticipatingNodes, numParticipatingPartitions));
                }
                jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, this.jobFlags, (boolean)false);
                IRequestTracker requestTracker = this.appCtx.getRequestTracker();
                ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
                clientRequest.setJobId(jobId);
                String nameBefore = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + jobId);
                    hcc.waitForCompletion(jobId);
                }
                finally {
                    Thread.currentThread().setName(nameBefore);
                }
                if (atomic) {
                    this.globalTxManager.commitTransaction(jobId);
                }
            }
            catch (Exception e) {
                if (atomic && jobId != null) {
                    this.globalTxManager.abortTransaction(jobId);
                }
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
            finally {
                metadataProvider.getLocks().unlock();
            }
        }
    }

    protected void handleCopyToStatement(final MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IResultSet resultSet, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IRequestParameters requestParameters, Map<String, IAObject> stmtParams, IStatementExecutor.Stats stats) throws Exception {
        CopyToStatement copyTo = (CopyToStatement)stmt;
        IRequestTracker requestTracker = this.appCtx.getRequestTracker();
        final ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() throws RuntimeDataException, InterruptedException {
                try {
                    QueryTranslator.this.compilationLock.readLock().lockInterruptibly();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    QueryTranslator.ensureNotCancelled(clientRequest);
                    throw e;
                }
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                QueryTranslator.this.compilationLock.readLock().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            long compileStart = System.nanoTime();
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                ExternalDetailsDecl edd = copyTo.getExternalDetailsDecl();
                edd.setProperties(this.createAndValidateAdapterConfigurationForCopyToStmt(edd, ExternalDataConstants.WRITER_SUPPORTED_ADAPTERS, copyTo.getSourceLocation(), mdTxnCtx, metadataProvider));
                Map<VarIdentifier, IAObject> externalVars = this.createExternalVariables((IReturningStatement)copyTo, stmtParams);
                LangRewritingContext langRewritingContext = this.createLangRewritingContext(metadataProvider, this.declaredFunctions, null, (IWarningCollector)this.warningCollector, copyTo.getVarCounter());
                Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(langRewritingContext, (IReturningStatement)copyTo, this.sessionOutput, true, true, externalVars.keySet());
                CompiledStatements.CompiledCopyToStatement compiledCopyToStatement = new CompiledStatements.CompiledCopyToStatement(copyTo);
                JobSpecification jobSpec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, copyTo.getQuery(), (Integer)rewrittenResult.second, null, this.sessionOutput, (CompiledStatements.ICompiledStatement)compiledCopyToStatement, externalVars, this.responsePrinter, (IWarningCollector)this.warningCollector, requestParameters, this.jobFlags);
                stats.updateTotalWarningsCount(this.warningCollector.getTotalWarningsCount());
                this.afterCompile();
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                stats.setCompileTime(System.nanoTime() - compileStart);
                bActiveTxn = false;
                return this.isCompileOnly() ? null : jobSpec;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), (Throwable)e);
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        this.deliverResult(hcc, resultSet, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, requestParameters, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSpecification handleInsertUpsertStatement(final MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IResultSet resultSet, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, IRequestParameters requestParameters, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws Exception {
        InsertStatement stmtInsertUpsert = (InsertStatement)stmt;
        final String datasetName = stmtInsertUpsert.getDatasetName();
        metadataProvider.validateDatabaseObjectName(stmtInsertUpsert.getNamespace(), datasetName, stmtInsertUpsert.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtInsertUpsert.getNamespace());
        final DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        final String databaseName = stmtActiveNamespace.getDatabaseName();
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() throws AlgebricksException {
                QueryTranslator.this.compilationLock.readLock().lock();
                QueryTranslator.this.lockUtil.insertDeleteUpsertBegin(QueryTranslator.this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                QueryTranslator.this.compilationLock.readLock().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                metadataProvider.setWriteTransaction(true);
                JobSpecification jobSpec = this.rewriteCompileInsertUpsert((IClusterInfoCollector)hcc, metadataProvider, stmtInsertUpsert, stmtParams);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return this.isCompileOnly() ? null : jobSpec;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        if (stmtInsertUpsert.getReturnExpression() != null) {
            this.deliverResult(hcc, resultSet, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, requestParameters, false, stmt);
        } else {
            locker.lock();
            JobId jobId = null;
            boolean atomic = false;
            try {
                JobSpecification jobSpec = compiler.compile();
                if (jobSpec == null) {
                    JobSpecification jobSpecification = jobSpec;
                    return jobSpecification;
                }
                Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
                atomic = ds.isAtomic();
                if (atomic) {
                    int numParticipatingNodes = this.appCtx.getNodeJobTracker().getJobParticipatingNodes(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class).size();
                    int numParticipatingPartitions = this.appCtx.getNodeJobTracker().getNumParticipatingPartitions(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class);
                    ArrayList<Integer> participatingDatasetIds = new ArrayList<Integer>();
                    participatingDatasetIds.add(ds.getDatasetId());
                    jobSpec.setProperty("GlobalTxProperty", (Serializable)new GlobalTxInfo(participatingDatasetIds, numParticipatingNodes, numParticipatingPartitions));
                }
                jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, this.jobFlags, (boolean)false);
                IRequestTracker requestTracker = this.appCtx.getRequestTracker();
                ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
                clientRequest.setJobId(jobId);
                String nameBefore = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + jobId);
                    hcc.waitForCompletion(jobId);
                }
                finally {
                    Thread.currentThread().setName(nameBefore);
                }
                if (atomic) {
                    this.globalTxManager.commitTransaction(jobId);
                }
            }
            catch (Exception e) {
                if (atomic && jobId != null) {
                    this.globalTxManager.abortTransaction(jobId);
                }
                throw e;
            }
            finally {
                locker.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSpecification handleDeleteStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter, IRequestParameters requestParameters) throws Exception {
        DeleteStatement stmtDelete = (DeleteStatement)stmt;
        String datasetName = stmtDelete.getDatasetName();
        metadataProvider.validateDatabaseObjectName(stmtDelete.getNamespace(), datasetName, stmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtDelete.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.insertDeleteUpsertBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        boolean atomic = false;
        JobId jobId = null;
        try {
            metadataProvider.setWriteTransaction(true);
            CompiledStatements.CompiledDeleteStatement clfrqs = new CompiledStatements.CompiledDeleteStatement(stmtDelete.getVariableExpr(), databaseName, dataverseName, datasetName, stmtDelete.getCondition(), stmtDelete.getVarCounter(), stmtDelete.getQuery());
            clfrqs.setSourceLocation(stmt.getSourceLocation());
            JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, clfrqs.getQuery(), (CompiledStatements.ICompiledDmlStatement)clfrqs, stmtParams, null);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (jobSpec != null && !this.isCompileOnly()) {
                Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
                atomic = ds.isAtomic();
                if (atomic) {
                    int numParticipatingNodes = this.appCtx.getNodeJobTracker().getJobParticipatingNodes(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class).size();
                    int numParticipatingPartitions = this.appCtx.getNodeJobTracker().getNumParticipatingPartitions(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class);
                    ArrayList<Integer> participatingDatasetIds = new ArrayList<Integer>();
                    participatingDatasetIds.add(ds.getDatasetId());
                    jobSpec.setProperty("GlobalTxProperty", (Serializable)new GlobalTxInfo(participatingDatasetIds, numParticipatingNodes, numParticipatingPartitions));
                }
                jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, this.jobFlags, (boolean)false);
                IRequestTracker requestTracker = this.appCtx.getRequestTracker();
                ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
                clientRequest.setJobId(jobId);
                String nameBefore = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + jobId);
                    hcc.waitForCompletion(jobId);
                }
                finally {
                    Thread.currentThread().setName(nameBefore);
                }
                if (atomic) {
                    this.globalTxManager.commitTransaction(jobId);
                }
            }
            JobSpecification jobSpecification = jobSpec;
            return jobSpecification;
        }
        catch (Exception e) {
            if (atomic && jobId != null) {
                this.globalTxManager.abortTransaction(jobId);
            }
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public JobSpecification rewriteCompileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, CompiledStatements.ICompiledDmlStatement stmt, Map<String, IAObject> stmtParams, IRequestParameters requestParameters) throws AlgebricksException, ACIDException {
        Map<VarIdentifier, IAObject> externalVars = this.createExternalVariables((IReturningStatement)query, stmtParams);
        LangRewritingContext langRewritingContext = this.createLangRewritingContext(metadataProvider, this.declaredFunctions, null, (IWarningCollector)this.warningCollector, query.getVarCounter());
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(langRewritingContext, (IReturningStatement)query, this.sessionOutput, true, true, externalVars.keySet());
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, (Query)rewrittenResult.first, (Integer)rewrittenResult.second, stmt == null ? null : stmt.getDatasetName(), this.sessionOutput, (CompiledStatements.ICompiledStatement)stmt, externalVars, this.responsePrinter, (IWarningCollector)this.warningCollector, requestParameters, this.jobFlags);
    }

    protected JobSpecification rewriteCompileInsertUpsert(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, InsertStatement insertUpsert, Map<String, IAObject> stmtParams) throws AlgebricksException, ACIDException {
        CompiledStatements.CompiledInsertStatement clfrqs;
        SourceLocation sourceLoc = insertUpsert.getSourceLocation();
        Map<VarIdentifier, IAObject> externalVars = this.createExternalVariables((IReturningStatement)insertUpsert, stmtParams);
        LangRewritingContext langRewritingContext = this.createLangRewritingContext(metadataProvider, this.declaredFunctions, null, (IWarningCollector)this.warningCollector, insertUpsert.getVarCounter());
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(langRewritingContext, (IReturningStatement)insertUpsert, this.sessionOutput, true, true, externalVars.keySet());
        InsertStatement rewrittenInsertUpsert = (InsertStatement)rewrittenResult.first;
        Namespace stmtActiveNamespace = this.getActiveNamespace(rewrittenInsertUpsert.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = rewrittenInsertUpsert.getDatasetName();
        switch (insertUpsert.getKind()) {
            case INSERT: {
                clfrqs = new CompiledStatements.CompiledInsertStatement(databaseName, dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                clfrqs.setSourceLocation(insertUpsert.getSourceLocation());
                break;
            }
            case UPSERT: {
                clfrqs = new CompiledStatements.CompiledUpsertStatement(databaseName, dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                clfrqs.setSourceLocation(insertUpsert.getSourceLocation());
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unsupported statement type " + rewrittenInsertUpsert.getKind()});
            }
        }
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, rewrittenInsertUpsert.getQuery(), (Integer)rewrittenResult.second, datasetName, this.sessionOutput, (CompiledStatements.ICompiledStatement)clfrqs, externalVars, this.responsePrinter, (IWarningCollector)this.warningCollector, null, this.jobFlags);
    }

    protected void handleCreateFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFeedStatement cfs = (CreateFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        String feedName = cfs.getFeedName().getValue();
        metadataProvider.validateDatabaseObjectName(cfs.getNamespace(), feedName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(cfs.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.createFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, feedName);
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, feedName);
            if (feed != null) {
                if (cfs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"A feed with this name " + feedName + " already exists."});
            }
            Map configuration = cfs.getConfiguration();
            ExternalDataUtils.normalize((Map)configuration);
            ExternalDataUtils.validate((Map)configuration);
            feed = new Feed(databaseName, dataverseName, feedName, configuration);
            FeedMetadataUtil.validateFeed((Feed)feed, (MetadataTransactionContext)mdTxnCtx, (ICcApplicationContext)this.appCtx, (IWarningCollector)this.warningCollector);
            MetadataManager.INSTANCE.addFeed(metadataProvider.getMetadataTxnContext(), feed);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws AlgebricksException, HyracksDataException {
        MetadataTransactionContext mdTxnCtx = null;
        CreateFeedPolicyStatement cfps = (CreateFeedPolicyStatement)stmt;
        SourceLocation sourceLoc = cfps.getSourceLocation();
        String policyName = cfps.getPolicyName();
        metadataProvider.validateDatabaseObjectName(null, policyName, sourceLoc);
        DataverseName dataverseName = this.activeNamespace.getDataverseName();
        String databaseName = this.activeNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.createFeedPolicyBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, policyName);
        try {
            FeedPolicyEntity newPolicy;
            String description;
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, policyName);
            if (feedPolicy != null) {
                if (cfps.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"A policy with this name " + policyName + " already exists."});
            }
            boolean extendingExisting = cfps.getSourcePolicyName() != null;
            String string = description = cfps.getDescription() == null ? "" : cfps.getDescription();
            if (extendingExisting) {
                FeedPolicyEntity sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, cfps.getSourcePolicyName());
                if (sourceFeedPolicy == null && (sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), "System", MetadataConstants.METADATA_DATAVERSE_NAME, cfps.getSourcePolicyName())) == null) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unknown policy " + cfps.getSourcePolicyName()});
                }
                Map policyProperties = sourceFeedPolicy.getProperties();
                policyProperties.putAll(cfps.getProperties());
                newPolicy = new FeedPolicyEntity(databaseName, dataverseName, policyName, description, policyProperties);
            } else {
                Properties prop = new Properties();
                try {
                    FileInputStream stream = new FileInputStream(cfps.getSourcePolicyFile());
                    prop.load(stream);
                }
                catch (Exception e) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unable to read policy file" + cfps.getSourcePolicyFile(), e});
                }
                HashMap policyProperties = new HashMap();
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> policyProperties.put((String)key, (String)value)));
                newPolicy = new FeedPolicyEntity(databaseName, dataverseName, policyName, description, policyProperties);
            }
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, newPolicy);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (RemoteException | ACIDException e) {
            QueryTranslator.abort((Exception)e, (Exception)e, mdTxnCtx);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDropFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        FeedDropStatement stmtFeedDrop = (FeedDropStatement)stmt;
        SourceLocation sourceLoc = stmtFeedDrop.getSourceLocation();
        String feedName = stmtFeedDrop.getFeedName().getValue();
        metadataProvider.validateDatabaseObjectName(stmtFeedDrop.getNamespace(), feedName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtFeedDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.dropFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, feedName);
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, databaseName, dataverseName, feedName);
            if (feed == null) {
                if (!stmtFeedDrop.getIfExists()) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"There is no feed with this name " + feedName + "."});
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            this.doDropFeed(hcc, metadataProvider, feed, sourceLoc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doDropFeed(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Feed feed, SourceLocation sourceLoc) throws Exception {
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        EntityId feedId = feed.getFeedId();
        ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeNotificationHandler.getListener(feedId);
        if (listener != null && listener.getState() != ActivityState.STOPPED) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Feed " + feedId + " is currently active and connected to the following " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + "\n" + listener});
        }
        if (listener != null) {
            listener.unregister();
        }
        JobSpecification spec = FeedOperations.buildRemoveFeedStorageJob(metadataProvider, MetadataManager.INSTANCE.getFeed(mdTxnCtx, feedId.getDatabaseName(), feedId.getDataverseName(), feedId.getEntityName()));
        this.runJob(hcc, spec);
        MetadataManager.INSTANCE.dropFeed(mdTxnCtx, feed.getDatabaseName(), feed.getDataverseName(), feed.getFeedName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Removed feed " + feedId);
        }
    }

    protected void handleDropFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        FeedPolicyDropStatement stmtFeedPolicyDrop = (FeedPolicyDropStatement)stmt;
        SourceLocation sourceLoc = stmtFeedPolicyDrop.getSourceLocation();
        String policyName = stmtFeedPolicyDrop.getPolicyName().getValue();
        metadataProvider.validateDatabaseObjectName(stmtFeedPolicyDrop.getNamespace(), policyName, sourceLoc);
        Namespace stmtActiveNamespace = this.getActiveNamespace(stmtFeedPolicyDrop.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.dropFeedPolicyBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, policyName);
        try {
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(mdTxnCtx, databaseName, dataverseName, policyName);
            if (feedPolicy == null) {
                if (!stmtFeedPolicyDrop.getIfExists()) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unknown policy " + policyName + " in " + IdentifierUtil.dataverse() + " " + dataverseName});
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            MetadataManager.INSTANCE.dropFeedPolicy(mdTxnCtx, databaseName, dataverseName, policyName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleStartFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        StartFeedStatement sfs = (StartFeedStatement)stmt;
        SourceLocation sourceLoc = sfs.getSourceLocation();
        Namespace stmtActiveNamespace = this.getActiveNamespace(sfs.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String feedName = sfs.getFeedName().getValue();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean committed = false;
        this.lockUtil.startFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, feedName);
        try {
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            EntityId entityId = new EntityId("Feed", databaseName, dataverseName, feedName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((String)databaseName, (DataverseName)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            List feedConnections = MetadataManager.INSTANCE.getFeedConections(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, feedName);
            if (feedConnections.isEmpty()) {
                throw new CompilationException(ErrorCode.FEED_START_FEED_WITHOUT_CONNECTION, sourceLoc, new Serializable[]{feedName});
            }
            for (FeedConnection feedConnection : feedConnections) {
                this.lockManager.acquireDatasetReadLock(metadataProvider.getLocks(), feedConnection.getDatabaseName(), feedConnection.getDataverseName(), feedConnection.getDatasetName());
            }
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
            if (listener == null) {
                ArrayList<Dataset> datasets = new ArrayList<Dataset>();
                for (FeedConnection connection : feedConnections) {
                    Dataset ds = metadataProvider.findDataset(connection.getDatabaseName(), connection.getDataverseName(), connection.getDatasetName());
                    datasets.add(ds);
                }
                listener = new FeedEventsListener(this, metadataProvider.getApplicationContext(), hcc, entityId, datasets, null, FeedIntakeOperatorNodePushable.class.getSimpleName(), (IRetryPolicyFactory)NoRetryPolicyFactory.INSTANCE, feed, feedConnections, this.compilationProvider.getLanguage());
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            committed = true;
            listener.start(metadataProvider);
        }
        catch (Exception e) {
            if (!committed) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStopFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        StopFeedStatement sfst = (StopFeedStatement)stmt;
        SourceLocation sourceLoc = sfst.getSourceLocation();
        Namespace stmtActiveNamespace = this.getActiveNamespace(sfst.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String feedName = sfst.getFeedName().getValue();
        EntityId entityId = new EntityId("Feed", databaseName, dataverseName, feedName);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
        if (listener == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Feed " + feedName + " is not started."});
        }
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.stopFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, feedName);
        try {
            listener.stop(metadataProvider);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleConnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        ConnectFeedStatement cfs = (ConnectFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        Namespace stmtActiveNamespace = this.getActiveNamespace(cfs.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String feedName = cfs.getFeedName();
        String datasetName = cfs.getDatasetName().getValue();
        String policyName = cfs.getPolicy();
        String whereClauseBody = cfs.getWhereClauseBody();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        this.lockUtil.connectFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName, feedName);
        try {
            Dataset dataset = FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)databaseName, (DataverseName)dataverseName, (String)datasetName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((String)databaseName, (DataverseName)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            FeedEventsListener listener = (FeedEventsListener)activeEventHandler.getListener(feed.getFeedId());
            if (listener != null && listener.isActive()) {
                throw new CompilationException(ErrorCode.FEED_CHANGE_FEED_CONNECTIVITY_ON_ALIVE_FEED, sourceLoc, new Serializable[]{feedName});
            }
            ARecordType outputType = FeedMetadataUtil.getOutputType((IFeed)feed, (String)((String)feed.getConfiguration().get("type-name")));
            List appliedFunctions = cfs.getAppliedFunctions();
            for (FunctionSignature func : appliedFunctions) {
                if (MetadataManager.INSTANCE.getFunction(mdTxnCtx, func) != null) continue;
                throw new CompilationException(ErrorCode.FEED_CONNECT_FEED_APPLIED_INVALID_FUNCTION, sourceLoc, new Serializable[]{func.getName()});
            }
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, feedName, datasetName);
            if (fc != null) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Feed" + feedName + " is already connected to " + IdentifierUtil.dataset() + " " + datasetName});
            }
            fc = new FeedConnection(databaseName, dataverseName, feedName, datasetName, appliedFunctions, policyName, whereClauseBody, outputType.getTypeName());
            MetadataManager.INSTANCE.addFeedConnection(metadataProvider.getMetadataTxnContext(), fc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.add(dataset);
                listener.addFeedConnection(fc);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDisconnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DisconnectFeedStatement cfs = (DisconnectFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        Namespace stmtActiveNamespace = this.getActiveNamespace(cfs.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = cfs.getDatasetName().getValue();
        String feedName = cfs.getFeedName().getValue();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.disconnectFeedBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName, feedName);
        try {
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(new EntityId("Feed", databaseName, dataverseName, feedName));
            if (listener != null && listener.isActive()) {
                throw new CompilationException(ErrorCode.FEED_CHANGE_FEED_CONNECTIVITY_ON_ALIVE_FEED, sourceLoc, new Serializable[]{feedName});
            }
            FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)databaseName, (DataverseName)dataverseName, (String)cfs.getDatasetName().getValue());
            FeedMetadataUtil.validateIfFeedExists((String)databaseName, (DataverseName)dataverseName, (String)cfs.getFeedName().getValue(), (MetadataTransactionContext)mdTxnCtx);
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, feedName, datasetName);
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (fc == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Feed " + feedName + " is currently not connected to " + cfs.getDatasetName().getValue() + ". Invalid operation!"});
            }
            MetadataManager.INSTANCE.dropFeedConnection(mdTxnCtx, databaseName, dataverseName, feedName, datasetName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.remove(ds);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAnalyzeStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        AnalyzeStatement analyzeStatement = (AnalyzeStatement)stmt;
        metadataProvider.validateDatabaseObjectName(analyzeStatement.getNamespace(), analyzeStatement.getDatasetName(), analyzeStatement.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(analyzeStatement.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = analyzeStatement.getDatasetName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.analyzeDatasetBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            this.doAnalyzeDataset(metadataProvider, analyzeStatement, databaseName, dataverseName, datasetName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doAnalyzeDataset(MetadataProvider metadataProvider, AnalyzeStatement stmtAnalyze, String databaseName, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtAnalyze.getSourceLocation();
        JobUtils.ProgressState progressNewIndexCreate = JobUtils.ProgressState.NO_PROGRESS;
        JobUtils.ProgressState progressExistingIndexDrop = JobUtils.ProgressState.NO_PROGRESS;
        Dataset ds = null;
        Index existingIndex = null;
        Index newIndexPendingAdd = null;
        JobSpecification existingIndexDropSpec = null;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            String newIndexName;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, databaseName, dataverseName);
            if (dv == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (ds.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
                throw new CompilationException(ErrorCode.OPERATION_NOT_SUPPORTED, sourceLoc, new Serializable[0]);
            }
            this.validateDatasetState(metadataProvider, ds, sourceLoc);
            DatasetConfig.IndexType sampleIndexType = DatasetConfig.IndexType.SAMPLE;
            Pair sampleIndexNames = IndexUtil.getSampleIndexNames((String)datasetName);
            existingIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, (String)sampleIndexNames.first);
            if (existingIndex != null) {
                newIndexName = (String)sampleIndexNames.second;
            } else {
                existingIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, (String)sampleIndexNames.second);
                newIndexName = (String)sampleIndexNames.first;
            }
            InternalDatasetDetails dsDetails = (InternalDatasetDetails)ds.getDatasetDetails();
            int sampleCardinalityTarget = stmtAnalyze.getSampleSize();
            long sampleSeed = stmtAnalyze.getOrCreateSampleSeed();
            Index.SampleIndexDetails newIndexDetailsPendingAdd = new Index.SampleIndexDetails(dsDetails.getPrimaryKey(), dsDetails.getKeySourceIndicator(), dsDetails.getPrimaryKeyType(), sampleCardinalityTarget, 0L, 0, sampleSeed, Collections.emptyMap());
            newIndexPendingAdd = new Index(databaseName, dataverseName, datasetName, newIndexName, sampleIndexType, (Index.IIndexDetails)newIndexDetailsPendingAdd, false, false, 1);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), newIndexPendingAdd);
            JobSpecification spec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)ds, (Index)newIndexPendingAdd, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            if (spec == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Failed to create job spec for creating index '" + ds.getDatasetName() + "." + newIndexPendingAdd.getIndexName() + "'"});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progressNewIndexCreate = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            this.runJob(hcc, spec);
            FlushDatasetUtil.flushDataset(hcc, metadataProvider, databaseName, dataverseName, datasetName);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            spec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)ds, (Index)newIndexPendingAdd, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            List<IOperatorStats> opStats = QueryTranslator.runJob(hcc, spec, this.jobFlags, Collections.singletonList("Sample.DatasetStats"));
            if (opStats == null || opStats.size() == 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{"", sourceLoc});
            }
            DatasetStreamStats stats = new DatasetStreamStats(opStats.get(0));
            Index.SampleIndexDetails newIndexDetailsFinal = new Index.SampleIndexDetails(dsDetails.getPrimaryKey(), dsDetails.getKeySourceIndicator(), dsDetails.getPrimaryKeyType(), sampleCardinalityTarget, stats.getCardinality(), stats.getAvgTupleSize(), sampleSeed, stats.getIndexesStats());
            Index newIndexFinal = new Index(databaseName, dataverseName, datasetName, newIndexName, sampleIndexType, (Index.IIndexDetails)newIndexDetailsFinal, false, false, 0);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), newIndexPendingAdd.getDatabaseName(), newIndexPendingAdd.getDataverseName(), newIndexPendingAdd.getDatasetName(), newIndexPendingAdd.getIndexName());
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), newIndexFinal);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progressNewIndexCreate = JobUtils.ProgressState.NO_PROGRESS;
            if (existingIndex != null) {
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), existingIndex.getDatabaseName(), existingIndex.getDataverseName(), existingIndex.getDatasetName(), existingIndex.getIndexName());
                existingIndex.setPendingOp(2);
                MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), existingIndex);
                existingIndexDropSpec = IndexUtil.buildDropIndexJobSpec((Index)existingIndex, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                progressExistingIndexDrop = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                bActiveTxn = false;
                this.runJob(hcc, existingIndexDropSpec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), existingIndex.getDatabaseName(), existingIndex.getDataverseName(), existingIndex.getDatasetName(), existingIndex.getIndexName());
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progressExistingIndexDrop = JobUtils.ProgressState.NO_PROGRESS;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to analyze dataset; executing compensating operations", (Throwable)e);
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progressExistingIndexDrop == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    this.runJob(hcc, existingIndexDropSpec);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), existingIndex.getDatabaseName(), existingIndex.getDataverseName(), existingIndex.getDatasetName(), existingIndex.getIndexName());
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending index(" + existingIndex.getDataverseName() + "." + existingIndex.getDatasetName() + "." + existingIndex.getIndexName() + ") couldn't be removed from the metadata", e);
                }
            }
            if (progressNewIndexCreate == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block21: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = IndexUtil.buildDropIndexJobSpec(newIndexPendingAdd, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        this.runJob(hcc, jobSpec);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block21;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), newIndexPendingAdd.getDatabaseName(), newIndexPendingAdd.getDataverseName(), newIndexPendingAdd.getDatasetName(), newIndexPendingAdd.getIndexName());
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is in inconsistent state: pending index(" + newIndexPendingAdd.getDataverseName() + "." + newIndexPendingAdd.getDatasetName() + "." + newIndexPendingAdd.getIndexName() + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAnalyzeDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParams) throws Exception {
        AnalyzeDropStatement analyzeDropStmt = (AnalyzeDropStatement)stmt;
        metadataProvider.validateDatabaseObjectName(analyzeDropStmt.getNamespace(), analyzeDropStmt.getDatasetName(), analyzeDropStmt.getSourceLocation());
        Namespace stmtActiveNamespace = this.getActiveNamespace(analyzeDropStmt.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = analyzeDropStmt.getDatasetName();
        if (this.isCompileOnly()) {
            return;
        }
        this.lockUtil.analyzeDatasetDropBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            this.doAnalyzeDatasetDrop(metadataProvider, analyzeDropStmt, databaseName, dataverseName, datasetName, hcc, requestParams);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doAnalyzeDatasetDrop(MetadataProvider metadataProvider, AnalyzeDropStatement stmtIndexDrop, String databaseName, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParams) throws Exception {
        SourceLocation sourceLoc = stmtIndexDrop.getSourceLocation();
        Pair sampleIndexNames = IndexUtil.getSampleIndexNames((String)datasetName);
        String indexName1 = (String)sampleIndexNames.first;
        String indexName2 = (String)sampleIndexNames.second;
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        boolean index1Exists = false;
        boolean index2Exists = false;
        try {
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            if (ds.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
                throw new CompilationException(ErrorCode.OPERATION_NOT_SUPPORTED, sourceLoc, new Serializable[0]);
            }
            Index index1 = MetadataManager.INSTANCE.getIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName1);
            Index index2 = MetadataManager.INSTANCE.getIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName2);
            index1Exists = index1 != null;
            boolean bl = index2Exists = index2 != null;
            if (!index1Exists && !index2Exists) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return false;
            }
            this.ensureNonPrimaryIndexesDrop(index1, index2, sourceLoc);
            this.validateDatasetState(metadataProvider, ds, sourceLoc);
            this.prepareIndexDrop(metadataProvider, databaseName, dataverseName, datasetName, sourceLoc, indexName1, jobsToExecute, mdTxnCtx, ds, index1);
            this.prepareIndexDrop(metadataProvider, databaseName, dataverseName, datasetName, sourceLoc, indexName2, jobsToExecute, mdTxnCtx, ds, index2);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            if (index1Exists) {
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName1);
            }
            if (index2Exists) {
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName2);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    if (index1Exists) {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, indexName1);
                    }
                    if (index2Exists) {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName, datasetName, indexName2);
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    String msg = String.format("System is in inconsistent state: pending index %1$s.%2$s.%3$s and/or %1$s.%2$s.%4$s couldn't be removed from the metadata", dataverseName, datasetName, indexName1, indexName2);
                    throw new IllegalStateException(msg, e);
                }
            }
            throw e;
        }
    }

    private void ensureNonPrimaryIndexesDrop(Index index1, Index index2, SourceLocation sourceLoc) throws AlgebricksException {
        if (index1 != null) {
            this.ensureNonPrimaryIndexDrop(index1, sourceLoc);
        }
        if (index2 != null) {
            this.ensureNonPrimaryIndexDrop(index2, sourceLoc);
        }
    }

    private void prepareIndexDrop(MetadataProvider metadataProvider, String databaseName, DataverseName dataverseName, String datasetName, SourceLocation sourceLoc, String indexName, List<JobSpecification> jobsToExecute, MetadataTransactionContext mdTxnCtx, Dataset ds, Index index) throws AlgebricksException {
        if (index != null) {
            jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc));
            MetadataManager.INSTANCE.dropIndex(mdTxnCtx, databaseName, dataverseName, datasetName, indexName);
            MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(databaseName, dataverseName, datasetName, indexName, index.getIndexType(), index.getIndexDetails(), index.isEnforced(), index.isPrimaryIndex(), 2));
        }
    }

    protected void handleCompactStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        CompactStatement compactStatement = (CompactStatement)stmt;
        SourceLocation sourceLoc = compactStatement.getSourceLocation();
        Namespace stmtActiveNamespace = this.getActiveNamespace(compactStatement.getNamespace());
        DataverseName dataverseName = stmtActiveNamespace.getDataverseName();
        String databaseName = stmtActiveNamespace.getDatabaseName();
        String datasetName = compactStatement.getDatasetName().getValue();
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        this.lockUtil.compactBegin(this.lockManager, metadataProvider.getLocks(), databaseName, dataverseName, datasetName);
        try {
            Dataset ds = metadataProvider.findDataset(databaseName, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
            }
            List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, databaseName, dataverseName, datasetName);
            if (indexes.isEmpty()) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Cannot compact the external " + IdentifierUtil.dataset() + " " + datasetName + " because it has no indexes"});
            }
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), databaseName, dataverseName);
            jobsToExecute.add(DatasetUtil.compactDatasetJobSpec((Dataverse)dataverse, (String)datasetName, (MetadataProvider)metadataProvider));
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                for (Index index : indexes) {
                    if (!index.isSecondaryIndex() || index.isSampleIndex()) continue;
                    jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc));
                }
            } else {
                this.prepareCompactJobsForExternalDataset(indexes, ds, jobsToExecute, metadataProvider, sourceLoc);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void prepareCompactJobsForExternalDataset(List<Index> indexes, Dataset ds, List<JobSpecification> jobsToExecute, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        for (int j = 0; j < indexes.size(); ++j) {
            jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)indexes.get(j), (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc));
        }
    }

    protected void handleQuery(final MetadataProvider metadataProvider, Query query, IHyracksClientConnection hcc, IResultSet resultSet, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, IRequestParameters requestParameters, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws Exception {
        IRequestTracker requestTracker = this.appCtx.getRequestTracker();
        final ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() throws RuntimeDataException, InterruptedException {
                try {
                    QueryTranslator.this.compilationLock.readLock().lockInterruptibly();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    QueryTranslator.ensureNotCancelled(clientRequest);
                    throw e;
                }
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                QueryTranslator.this.compilationLock.readLock().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            long compileStart = System.nanoTime();
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, query, null, stmtParams, requestParameters);
                stats.updateTotalWarningsCount(this.warningCollector.getTotalWarningsCount());
                this.afterCompile();
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                stats.setCompileTime(System.nanoTime() - compileStart);
                bActiveTxn = false;
                return query.isExplain() || this.isCompileOnly() ? null : jobSpec;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), (Throwable)e);
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        this.deliverResult(hcc, resultSet, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, requestParameters, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResult(IHyracksClientConnection hcc, IResultSet resultSet, IStatementCompiler compiler, MetadataProvider metadataProvider, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, IRequestParameters requestParameters, boolean cancellable, Statement atomicStmt) throws Exception {
        ResultSetId resultSetId = metadataProvider.getResultSetId();
        switch (resultDelivery) {
            case ASYNC: {
                MutableBoolean printed = new MutableBoolean(false);
                this.executorService.submit(() -> this.asyncCreateAndRunJob(hcc, compiler, locker, resultDelivery, requestParameters, cancellable, resultSetId, printed, metadataProvider, atomicStmt));
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    while (!printed.booleanValue()) {
                        printed.wait();
                    }
                    break;
                }
            }
            case IMMEDIATE: {
                this.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    ResultReader resultReader = new ResultReader(resultSet, id, resultSetId);
                    this.updateJobStats(id, stats, metadataProvider.getResultSetId());
                    this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultsPrinter((IApplicationContext)this.appCtx, resultReader, metadataProvider.findOutputRecordType(), stats, this.sessionOutput));
                    this.responsePrinter.printResults();
                }, requestParameters, cancellable, this.appCtx, metadataProvider, atomicStmt);
                break;
            }
            case DEFERRED: {
                this.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    this.updateJobStats(id, stats, metadataProvider.getResultSetId());
                    this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultHandlePrinter(this.sessionOutput, new ResultHandle(id, resultSetId)));
                    this.responsePrinter.printResults();
                    if (outMetadata != null) {
                        outMetadata.getResultSets().add(Triple.of((Object)id, (Object)resultSetId, (Object)metadataProvider.findOutputRecordType()));
                    }
                }, requestParameters, cancellable, this.appCtx, metadataProvider, atomicStmt);
                break;
            }
        }
    }

    private void updateJobStats(JobId jobId, IStatementExecutor.Stats stats, ResultSetId rsId) throws HyracksDataException {
        ClusterControllerService controllerService = (ClusterControllerService)this.appCtx.getServiceContext().getControllerService();
        ResultMetadata resultMetadata = (ResultMetadata)controllerService.getResultDirectoryService().getResultMetadata(jobId, rsId);
        stats.setProcessedObjects(resultMetadata.getProcessedObjects());
        stats.setQueueWaitTime(resultMetadata.getQueueWaitTimeInNanos());
        stats.setBufferCacheHitRatio(resultMetadata.getBufferCacheHitRatio());
        stats.setBufferCachePageReadCount(resultMetadata.getBufferCachePageReadCount());
        if (this.jobFlags.contains(JobFlag.PROFILE_RUNTIME)) {
            stats.setJobProfile(resultMetadata.getJobProfile());
            this.apiFramework.generateOptimizedLogicalPlanWithProfile(resultMetadata.getJobProfile());
        }
        stats.updateTotalWarningsCount(resultMetadata.getTotalWarningsCount());
        WarningUtil.mergeWarnings((Collection)resultMetadata.getWarnings(), (IWarningCollector)this.warningCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncCreateAndRunJob(IHyracksClientConnection hcc, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IRequestParameters requestParameters, boolean cancellable, ResultSetId resultSetId, MutableBoolean printed, MetadataProvider metadataProvider, Statement atomicStmt) {
        MutableObject jobId = new MutableObject((Object)JobId.INVALID);
        try {
            this.createAndRunJob(hcc, this.jobFlags, (Mutable<JobId>)jobId, compiler, locker, resultDelivery, id -> {
                ResultHandle handle = new ResultHandle(id, resultSetId);
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new StatusPrinter(AbstractQueryApiServlet.ResultStatus.RUNNING));
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultHandlePrinter(this.sessionOutput, handle));
                this.responsePrinter.printResults();
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    printed.setTrue();
                    printed.notify();
                }
            }, requestParameters, cancellable, this.appCtx, metadataProvider, atomicStmt);
        }
        catch (Exception e) {
            if (Objects.equals(JobId.INVALID, jobId.getValue())) {
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new StatusPrinter(AbstractQueryApiServlet.ResultStatus.FAILED));
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ErrorsPrinter(Collections.singletonList(ExecutionError.of(e))));
                try {
                    this.responsePrinter.printResults();
                }
                catch (HyracksDataException ex) {
                    LOGGER.error("failed to print result", (Throwable)ex);
                }
            } else {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, resultDelivery.name() + " job with id " + jobId.getValue() + " failed", (Throwable)e);
            }
        }
        finally {
            MutableBoolean mutableBoolean = printed;
            synchronized (mutableBoolean) {
                if (printed.isFalse()) {
                    printed.setTrue();
                    printed.notify();
                }
            }
        }
    }

    private void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec) throws Exception {
        QueryTranslator.runJob(hcc, jobSpec, this.jobFlags);
    }

    private static void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)true);
    }

    private static List<IOperatorStats> runJob(IHyracksClientConnection hcc, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags, List<String> statOperatorNames) throws Exception {
        Pair p = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)true, statOperatorNames);
        return (List)p.second;
    }

    private void createAndRunJob(IHyracksClientConnection hcc, EnumSet<JobFlag> jobFlags, Mutable<JobId> jId, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IResultPrinter printer, IRequestParameters requestParameters, boolean cancellable, ICcApplicationContext appCtx, MetadataProvider metadataProvider, Statement atomicStatement) throws Exception {
        IRequestTracker requestTracker = appCtx.getRequestTracker();
        ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
        if (cancellable) {
            clientRequest.markCancellable();
        }
        locker.lock();
        JobId jobId = null;
        boolean atomic = false;
        try {
            Dataset ds;
            JobSpecification jobSpec = compiler.compile();
            if (jobSpec == null) {
                return;
            }
            SchedulableClientRequest schedulableRequest = SchedulableClientRequest.of((IClientRequest)clientRequest, (ICommonRequestParameters)requestParameters, (IMetadataProvider)metadataProvider, (JobSpecification)jobSpec);
            appCtx.getReceptionist().ensureSchedulable((ISchedulableClientRequest)schedulableRequest);
            QueryTranslator.ensureNotCancelled(clientRequest);
            if (atomicStatement != null && (atomic = (ds = metadataProvider.findDataset(((InsertStatement)atomicStatement).getDatabaseName(), ((InsertStatement)atomicStatement).getDataverseName(), ((InsertStatement)atomicStatement).getDatasetName())).isAtomic())) {
                int numParticipatingNodes = appCtx.getNodeJobTracker().getJobParticipatingNodes(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class).size();
                int numParticipatingPartitions = appCtx.getNodeJobTracker().getNumParticipatingPartitions(jobSpec, LSMTreeIndexInsertUpdateDeleteOperatorDescriptor.class);
                ArrayList<Integer> participatingDatasetIds = new ArrayList<Integer>();
                participatingDatasetIds.add(ds.getDatasetId());
                jobSpec.setProperty("GlobalTxProperty", (Serializable)new GlobalTxInfo(participatingDatasetIds, numParticipatingNodes, numParticipatingPartitions));
            }
            jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)false);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Created job {} for query uuid:{}, clientContextID:{}", (Object)jobId, (Object)requestParameters.getRequestReference().getUuid(), (Object)requestParameters.getClientContextId());
            }
            clientRequest.setJobId(jobId);
            if (jId != null) {
                jId.setValue((Object)jobId);
            }
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                printer.print(jobId);
                hcc.waitForCompletion(jobId);
            } else {
                hcc.waitForCompletion(jobId);
                QueryTranslator.ensureNotCancelled(clientRequest);
                printer.print(jobId);
            }
            if (atomic) {
                this.globalTxManager.commitTransaction(jobId);
            }
        }
        catch (Exception e) {
            if (atomic && jobId != null) {
                this.globalTxManager.abortTransaction(jobId);
            }
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeDataException(ErrorCode.REQUEST_CANCELLED, new Serializable[]{clientRequest.getId()});
            }
            throw e;
        }
        finally {
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                requestTracker.complete(clientRequest.getId());
            }
            locker.unlock();
        }
    }

    protected void handleCreateNodeGroupStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodegroupDecl stmtCreateNodegroup = (NodegroupDecl)stmt;
        SourceLocation sourceLoc = stmtCreateNodegroup.getSourceLocation();
        String ngName = stmtCreateNodegroup.getNodegroupName().getValue();
        metadataProvider.validateDatabaseObjectName(null, ngName, sourceLoc);
        if (this.isCompileOnly()) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), ngName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, ngName);
            if (ng != null) {
                if (!stmtCreateNodegroup.getIfNotExists()) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"A nodegroup with this name " + ngName + " already exists."});
                }
            } else {
                List ncIdentifiers = stmtCreateNodegroup.getNodeControllerNames();
                ArrayList<String> ncNames = new ArrayList<String>(ncIdentifiers.size());
                for (Identifier id : ncIdentifiers) {
                    ncNames.add(id.getValue());
                }
                MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(ngName, ncNames));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public Namespace getActiveNamespace(Namespace namespace) {
        return namespace != null ? namespace : this.activeNamespace;
    }

    public ExecutionPlans getExecutionPlans() {
        return this.apiFramework.getExecutionPlans();
    }

    public IResponsePrinter getResponsePrinter() {
        return this.responsePrinter;
    }

    public void getWarnings(Collection<? super Warning> outWarnings, long maxWarnings) {
        this.warningCollector.getWarnings(outWarnings, maxWarnings);
    }

    public static void abort(Exception rootE, Exception parentE, MetadataTransactionContext mdTxnCtx) {
        boolean interrupted = Thread.interrupted();
        try {
            if (mdTxnCtx != null) {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
        }
        catch (Exception e2) {
            parentE.addSuppressed(e2);
            throw new IllegalStateException(rootE);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void rewriteStatement(Statement stmt, IStatementRewriter rewriter, MetadataProvider metadataProvider) throws CompilationException, RemoteException {
        if (!rewriter.isRewritable(stmt.getKind())) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            rewriter.rewrite(stmt, metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private void ensureNonPrimaryIndexDrop(Index index, SourceLocation sourceLoc) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            throw new MetadataException(ErrorCode.CANNOT_DROP_INDEX, sourceLoc, new Serializable[]{index.getIndexName(), index.getDatasetName()});
        }
    }

    protected void afterCompile() {
        if (this.sessionOutput.config().is("format-html")) {
            ExecutionPlansHtmlPrintUtil.print((PrintWriter)this.sessionOutput.out(), (ExecutionPlans)this.getExecutionPlans());
        }
    }

    protected void trackRequest(IRequestParameters requestParameters) throws HyracksDataException {
        IClientRequest clientRequest = this.appCtx.getReceptionist().requestReceived((ICommonRequestParameters)requestParameters);
        this.appCtx.getRequestTracker().track(clientRequest);
    }

    protected void validateStatements(IRequestParameters requestParameters) throws AlgebricksException, HyracksDataException {
        QueryTranslator.validateStatements(this.statements, requestParameters.isMultiStatement(), requestParameters.getStatementCategoryRestrictionMask());
        DataverseDecl requestDataverseDecl = this.getRequestDataverseDecl(requestParameters);
        if (requestDataverseDecl != null) {
            this.statements.add(0, (Statement)requestDataverseDecl);
        }
    }

    public static void validateStatements(List<Statement> statements, boolean allowMultiStatement, int stmtCategoryRestrictionMask) throws CompilationException {
        if (!allowMultiStatement && statements.stream().filter(QueryTranslator::isNotAllowedMultiStatement).count() > 1L) {
            throw new CompilationException(ErrorCode.UNSUPPORTED_MULTIPLE_STATEMENTS, new Serializable[0]);
        }
        if (stmtCategoryRestrictionMask != 0) {
            for (Statement stmt : statements) {
                if (!QueryTranslator.isNotAllowedStatementCategory(stmt, stmtCategoryRestrictionMask)) continue;
                throw new CompilationException(ErrorCode.PROHIBITED_STATEMENT_CATEGORY, stmt.getSourceLocation(), new Serializable[]{stmt.getKind()});
            }
        }
    }

    protected static boolean isNotAllowedMultiStatement(Statement statement) {
        switch (statement.getKind()) {
            case SET: 
            case DATAVERSE_DECL: 
            case FUNCTION_DECL: {
                return false;
            }
        }
        return true;
    }

    private static boolean isNotAllowedStatementCategory(Statement statement, int categoryRestrictionMask) {
        byte category = statement.getCategory();
        if (category <= 0) {
            throw new IllegalArgumentException(String.valueOf(category));
        }
        int i = category & categoryRestrictionMask;
        return i == 0;
    }

    private Map<VarIdentifier, IAObject> createExternalVariables(IReturningStatement stmt, Map<String, IAObject> stmtParams) throws CompilationException {
        if (!this.isCompileOnly()) {
            if (stmtParams == null || stmtParams.isEmpty()) {
                return Collections.emptyMap();
            }
            IQueryRewriter queryRewriter = this.rewriterFactory.createQueryRewriter();
            HashMap<VarIdentifier, IAObject> result = new HashMap<VarIdentifier, IAObject>();
            for (Map.Entry<String, IAObject> me : stmtParams.entrySet()) {
                result.put(queryRewriter.toExternalVariableName(me.getKey()), me.getValue());
            }
            return result;
        }
        IQueryRewriter queryRewriter = this.rewriterFactory.createQueryRewriter();
        Set extVars = queryRewriter.getExternalVariables(stmt.getBody());
        if (extVars.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<VarIdentifier, IAObject> result = new HashMap<VarIdentifier, IAObject>();
        for (VariableExpr extVar : extVars) {
            result.put(extVar.getVar(), (IAObject)ANull.NULL);
        }
        return result;
    }

    protected boolean isCompileOnly() {
        return !this.sessionConfig.isExecuteQuery();
    }

    protected void validateDatasetState(MetadataProvider metadataProvider, Dataset dataset, SourceLocation sourceLoc) throws Exception {
        QueryTranslator.validateIfResourceIsActiveInFeed(metadataProvider.getApplicationContext(), dataset, sourceLoc);
    }

    private static void ensureNotCancelled(ClientRequest clientRequest) throws RuntimeDataException {
        if (clientRequest.isCancelled()) {
            throw new RuntimeDataException(ErrorCode.REQUEST_CANCELLED, new Serializable[]{clientRequest.getId()});
        }
    }

    protected void validateExternalDatasetProperties(ExternalDetailsDecl externalDetails, Map<String, String> properties, SourceLocation srcLoc, MetadataTransactionContext mdTxnCtx, IApplicationContext appCtx) throws AlgebricksException, HyracksDataException {
        String adapter = externalDetails.getAdapter();
        HashMap<String, String> details = new HashMap<String, String>(properties);
        details.put("type", adapter);
        this.validateAdapterSpecificProperties(details, srcLoc, appCtx);
    }

    protected Map<String, String> createAndValidateAdapterConfigurationForCopyToStmt(ExternalDetailsDecl externalDetailsDecl, Set<String> supportedAdapters, SourceLocation sourceLocation, MetadataTransactionContext mdTxnCtx, MetadataProvider md) throws AlgebricksException {
        String adapterName = externalDetailsDecl.getAdapter();
        Map properties = externalDetailsDecl.getProperties();
        WriterValidationUtil.validateWriterConfiguration((String)adapterName, supportedAdapters, (Map)properties, (SourceLocation)sourceLocation);
        return properties;
    }

    protected void validateAdapterSpecificProperties(Map<String, String> configuration, SourceLocation srcLoc, IApplicationContext appCtx) throws CompilationException {
        ExternalDataUtils.validateAdapterSpecificProperties(configuration, (SourceLocation)srcLoc, (IWarningCollector)this.warningCollector, (IApplicationContext)appCtx);
    }

    private List<Dataset> prepareDatabaseDropJobs(MetadataProvider metadataProvider, SourceLocation sourceLoc, String databaseName, MetadataTransactionContext mdTxnCtx, List<FeedEventsListener> feedsToStop, List<JobSpecification> jobsToExecute) throws AlgebricksException {
        this.addFeedDropJob(metadataProvider, databaseName, feedsToStop, jobsToExecute);
        List<Dataset> datasets = QueryTranslator.addDatasetDropJob(metadataProvider, sourceLoc, databaseName, mdTxnCtx, jobsToExecute);
        List libraries = MetadataManager.INSTANCE.getDatabaseLibraries(mdTxnCtx, databaseName);
        for (Library library : libraries) {
            jobsToExecute.add(ExternalLibraryJobUtils.buildDropLibraryJobSpec(new Namespace(library.getDatabaseName(), library.getDataverseName()), library.getName(), metadataProvider));
        }
        jobsToExecute.add(DataverseUtil.dropDatabaseJobSpec(databaseName, metadataProvider));
        return datasets;
    }

    private static List<Dataset> addDatasetDropJob(MetadataProvider metadataProvider, SourceLocation sourceLoc, String databaseName, MetadataTransactionContext mdTxnCtx, List<JobSpecification> jobsToExecute) throws AlgebricksException {
        List datasets = MetadataManager.INSTANCE.getDatabaseDatasets(mdTxnCtx, databaseName);
        block3: for (Dataset dataset : datasets) {
            String datasetName = dataset.getDatasetName();
            DatasetConfig.DatasetType dsType = dataset.getDatasetType();
            switch (dsType) {
                case INTERNAL: {
                    List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, databaseName, dataset.getDataverseName(), datasetName);
                    for (Index index : indexes) {
                        jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, (SourceLocation)sourceLoc));
                    }
                    continue block3;
                }
            }
        }
        return datasets;
    }

    private void addFeedDropJob(MetadataProvider metadataProvider, String databaseName, List<FeedEventsListener> feedsToStop, List<JobSpecification> jobsToExecute) throws AlgebricksException {
        IActiveEntityEventsListener[] activeListeners;
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        for (IActiveEntityEventsListener listener : activeListeners = activeEventHandler.getEventListeners()) {
            EntityId activeEntityId = listener.getEntityId();
            if (!activeEntityId.getExtensionName().equals("Feed") || !activeEntityId.getDatabaseName().equals(databaseName)) continue;
            FeedEventsListener feedListener = (FeedEventsListener)listener;
            feedsToStop.add(feedListener);
            jobsToExecute.add(FeedOperations.buildRemoveFeedStorageJob(metadataProvider, feedListener.getFeed()));
        }
    }

    private void runDropJobs(MetadataProvider mdProvider, IHyracksClientConnection hcc, List<FeedEventsListener> feedsToStop, List<JobSpecification> jobsToExecute) throws Exception {
        for (FeedEventsListener feedListener : feedsToStop) {
            if (feedListener.getState() != ActivityState.STOPPED) {
                feedListener.stop(mdProvider);
            }
            feedListener.unregister();
        }
        for (JobSpecification jobSpec : jobsToExecute) {
            this.runJob(hcc, jobSpec);
        }
    }

    protected static enum CreateResult {
        NOOP,
        CREATED,
        REPLACED;

    }

    private static interface IStatementCompiler {
        public JobSpecification compile() throws AlgebricksException, RemoteException, ACIDException;
    }

    private static interface IMetadataLocker {
        public void lock() throws HyracksDataException, AlgebricksException, InterruptedException;

        public void unlock() throws HyracksDataException, AlgebricksException;
    }

    private static interface IResultPrinter {
        public void print(JobId var1) throws HyracksDataException, AlgebricksException;
    }
}

