/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CopyToStatement
extends AbstractStatement
implements IReturningStatement {
    private final String datasetName;
    private final VariableExpr sourceVariable;
    private final ExternalDetailsDecl externalDetailsDecl;
    private final Map<Integer, VariableExpr> partitionsVariables;
    private final List<OrderbyClause.OrderModifier> orderByModifiers;
    private final List<OrderbyClause.NullOrderModifier> orderByNullModifierList;
    private final List<Expression> keyExpressions;
    private final boolean autogenerated;
    private Namespace namespace;
    private Query query;
    private List<Expression> pathExpressions;
    private List<Expression> partitionExpressions;
    private List<Expression> orderByList;
    private int varCounter;

    public CopyToStatement(Namespace namespace, String datasetName, Query query, VariableExpr sourceVariable, ExternalDetailsDecl externalDetailsDecl, int varCounter, List<Expression> keyExpressions, boolean autogenerated) {
        this(namespace, datasetName, query, sourceVariable, externalDetailsDecl, new ArrayList<Expression>(), new ArrayList<Expression>(), new HashMap<Integer, VariableExpr>(), new ArrayList<Expression>(), new ArrayList<OrderbyClause.OrderModifier>(), new ArrayList<OrderbyClause.NullOrderModifier>(), varCounter, keyExpressions, autogenerated);
    }

    public CopyToStatement(Namespace namespace, String datasetName, Query query, VariableExpr sourceVariable, ExternalDetailsDecl externalDetailsDecl, List<Expression> pathExpressions, List<Expression> partitionExpressions, Map<Integer, VariableExpr> partitionsVariables, List<Expression> orderbyList, List<OrderbyClause.OrderModifier> orderByModifiers, List<OrderbyClause.NullOrderModifier> orderByNullModifierList, int varCounter) {
        this(namespace, datasetName, query, sourceVariable, externalDetailsDecl, pathExpressions, partitionExpressions, partitionsVariables, orderbyList, orderByModifiers, orderByNullModifierList, varCounter, new ArrayList<Expression>(), false);
    }

    private CopyToStatement(Namespace namespace, String datasetName, Query query, VariableExpr sourceVariable, ExternalDetailsDecl externalDetailsDecl, List<Expression> pathExpressions, List<Expression> partitionExpressions, Map<Integer, VariableExpr> partitionsVariables, List<Expression> orderbyList, List<OrderbyClause.OrderModifier> orderByModifiers, List<OrderbyClause.NullOrderModifier> orderByNullModifierList, int varCounter, List<Expression> keyExpressions, boolean autogenerated) {
        this.namespace = namespace;
        this.datasetName = datasetName;
        this.query = query;
        this.sourceVariable = sourceVariable;
        this.externalDetailsDecl = externalDetailsDecl;
        this.pathExpressions = pathExpressions;
        this.partitionExpressions = partitionExpressions;
        this.partitionsVariables = partitionsVariables;
        this.orderByList = orderbyList;
        this.orderByModifiers = orderByModifiers;
        this.orderByNullModifierList = orderByNullModifierList;
        this.varCounter = varCounter;
        this.keyExpressions = keyExpressions;
        this.autogenerated = autogenerated;
        if (pathExpressions.isEmpty()) {
            pathExpressions.add(new LiteralExpr(new StringLiteral("")));
        }
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.COPY_TO;
    }

    @Override
    public byte getCategory() {
        return 1;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    public VariableExpr getSourceVariable() {
        return this.sourceVariable;
    }

    public ExternalDetailsDecl getExternalDetailsDecl() {
        return this.externalDetailsDecl;
    }

    public List<Expression> getPathExpressions() {
        return this.pathExpressions;
    }

    public void setPathExpressions(List<Expression> pathExpressions) {
        if (pathExpressions.isEmpty()) {
            pathExpressions.add(new LiteralExpr(new StringLiteral("")));
        }
        this.pathExpressions = pathExpressions;
    }

    public List<Expression> getPartitionExpressions() {
        return this.partitionExpressions;
    }

    public void setPartitionExpressions(List<Expression> partitionExpressions) {
        this.partitionExpressions = partitionExpressions;
    }

    public Map<Integer, VariableExpr> getPartitionsVariables() {
        return this.partitionsVariables;
    }

    public List<Expression> getOrderByList() {
        return this.orderByList;
    }

    public void setOrderByList(List<Expression> orderbyList) {
        this.orderByList = orderbyList;
    }

    public List<OrderbyClause.OrderModifier> getOrderByModifiers() {
        return this.orderByModifiers;
    }

    public List<OrderbyClause.NullOrderModifier> getOrderByNullModifierList() {
        return this.orderByNullModifierList;
    }

    public boolean hasOverClause() {
        return this.hasPartitionClause() || this.hasOrderClause();
    }

    public boolean hasPartitionClause() {
        return !this.partitionExpressions.isEmpty();
    }

    public boolean hasOrderClause() {
        return !this.orderByList.isEmpty();
    }

    @Override
    public int getVarCounter() {
        return this.varCounter;
    }

    @Override
    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public List<Expression> getDirectlyEnclosedExpressions() {
        ArrayList<Expression> topLevelExpressions = new ArrayList<Expression>();
        topLevelExpressions.add(this.query.getBody());
        topLevelExpressions.addAll(this.pathExpressions);
        topLevelExpressions.addAll(this.partitionExpressions);
        topLevelExpressions.addAll(this.orderByList);
        return topLevelExpressions;
    }

    @Override
    public Expression getBody() {
        return this.query.getBody();
    }

    @Override
    public void setBody(Expression expr) {
        this.query.setBody(expr);
    }

    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public boolean isSinkFileStore() {
        return this.keyExpressions.isEmpty() && !this.autogenerated;
    }

    public boolean isSinkDatabaseWithKey() {
        return !this.keyExpressions.isEmpty() || this.autogenerated;
    }
}

