/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmObjectNode;

public class CopyFromStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String datasetName;
    private final String path;
    private final TypeExpression typeExpr;
    private final ExternalDetailsDecl externalDetails;
    private final AdmObjectNode withObjectNode;

    public CopyFromStatement(Namespace namespace, String datasetName, TypeExpression typeExpr, ExternalDetailsDecl externalDetails, RecordConstructor withRecord) throws CompilationException {
        this(namespace, datasetName, null, typeExpr, externalDetails, withRecord);
    }

    public CopyFromStatement(Namespace namespace, String datasetName, String path, TypeExpression typeExpr, ExternalDetailsDecl externalDetails) throws CompilationException {
        this(namespace, datasetName, path, typeExpr, externalDetails, null);
    }

    private CopyFromStatement(Namespace namespace, String datasetName, String path, TypeExpression typeExpr, ExternalDetailsDecl externalDetails, RecordConstructor withRecord) throws CompilationException {
        this.namespace = namespace;
        this.datasetName = datasetName;
        this.path = path;
        this.typeExpr = typeExpr;
        this.externalDetails = externalDetails;
        this.withObjectNode = withRecord == null ? new AdmObjectNode() : ExpressionUtils.toNode(withRecord);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.COPY_FROM;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public ExternalDetailsDecl getExternalDetails() {
        return this.externalDetails;
    }

    public AdmObjectNode getWithObjectNode() {
        return this.withObjectNode;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public byte getCategory() {
        return 2;
    }

    public TypeExpression getTypeExpr() {
        return this.typeExpr;
    }
}

