/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INodeJobTracker;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.expressions.ConstantExpression;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;

public class NodeJobTracker
implements INodeJobTracker {
    private final Map<String, Set<JobId>> nodeJobs = new HashMap<String, Set<JobId>>();

    public synchronized void notifyJobCreation(JobId jobId, JobSpecification spec) {
        this.getJobParticipatingNodes(spec, null).stream().map(this.nodeJobs::get).forEach(jobsSet -> jobsSet.add(jobId));
    }

    public synchronized void notifyJobStart(JobId jobId) {
    }

    public synchronized void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) {
        this.nodeJobs.values().forEach(jobsSet -> jobsSet.remove(jobId));
    }

    public synchronized void notifyNodeJoin(String nodeId, Map<IOption, Object> ncConfiguration) {
        this.nodeJobs.computeIfAbsent(nodeId, key -> new HashSet());
    }

    public synchronized void notifyNodeFailure(Collection<String> deadNodeIds) {
        deadNodeIds.forEach(this.nodeJobs::remove);
    }

    public synchronized Set<JobId> getPendingJobs(String nodeId) {
        return this.nodeJobs.containsKey(nodeId) ? Collections.unmodifiableSet(this.nodeJobs.get(nodeId)) : Collections.emptySet();
    }

    public Set<String> getJobParticipatingNodes(JobSpecification spec, Class<? extends IOperatorDescriptor> operatorClass) {
        if (operatorClass != null) {
            List operatorDescriptorIds = spec.getOperatorMap().entrySet().stream().filter(op -> operatorClass.isInstance(op.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            return spec.getUserConstraints().stream().filter(ce -> ce.getLValue().getTag() == ConstraintExpression.ExpressionTag.PARTITION_LOCATION && operatorDescriptorIds.contains(((PartitionLocationExpression)ce.getLValue()).getOperatorDescriptorId())).map(Constraint::getRValue).map(ConstantExpression.class::cast).map(ConstantExpression::getValue).map(Object::toString).filter(this.nodeJobs::containsKey).collect(Collectors.toSet());
        }
        return spec.getUserConstraints().stream().map(Constraint::getRValue).filter(ce -> ce.getTag() == ConstraintExpression.ExpressionTag.CONSTANT).map(ConstantExpression.class::cast).map(ConstantExpression::getValue).map(Object::toString).filter(this.nodeJobs::containsKey).collect(Collectors.toSet());
    }

    public int getNumParticipatingPartitions(JobSpecification spec, Class<? extends IOperatorDescriptor> operatorClass) {
        if (operatorClass != null) {
            List operatorDescriptorIds = spec.getOperatorMap().entrySet().stream().filter(op -> operatorClass.isInstance(op.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            return spec.getUserConstraints().stream().filter(ce -> ce.getLValue().getTag() == ConstraintExpression.ExpressionTag.PARTITION_COUNT && operatorDescriptorIds.contains(((PartitionCountExpression)ce.getLValue()).getOperatorDescriptorId())).map(Constraint::getRValue).map(ConstantExpression.class::cast).map(ConstantExpression::getValue).map(Object::toString).map(Integer::parseInt).max(Integer::compare).get();
        }
        return spec.getUserConstraints().stream().filter(ce -> ce.getLValue().getTag() == ConstraintExpression.ExpressionTag.PARTITION_COUNT).map(Constraint::getRValue).map(ConstantExpression.class::cast).map(ConstantExpression::getValue).map(Object::toString).map(Integer::parseInt).max(Integer::compare).get();
    }
}

