/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.ComparatorUtil;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractMinMaxAggregateFunction
extends AbstractAggregateFunction {
    private static final String FUN_NAME = "min/max";
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IPointable inputVal = new VoidPointable();
    private final ArrayBackedValueStorage outputVal = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage tempValForCasting = new ArrayBackedValueStorage();
    private final TaggedValueReference value1 = new TaggedValueReference();
    private final TaggedValueReference value2 = new TaggedValueReference();
    private final IScalarEvaluator eval;
    private final boolean isMin;
    private final IAType aggFieldType;
    protected final Type type;
    protected final IEvaluatorContext context;
    protected ATypeTag aggType;
    private ILogicalBinaryComparator cmp;

    AbstractMinMaxAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, boolean isMin, SourceLocation sourceLoc, Type type, IAType aggFieldType) throws HyracksDataException {
        super(sourceLoc);
        this.context = context;
        this.eval = args[0].createScalarEvaluator(context);
        this.isMin = isMin;
        this.aggFieldType = aggFieldType;
        this.type = type;
    }

    public void init() throws HyracksDataException {
        this.aggType = ATypeTag.SYSTEM_NULL;
        this.tempValForCasting.reset();
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.skipStep()) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull();
        } else if (typeTag == ATypeTag.SYSTEM_NULL) {
            if (this.type == Type.LOCAL) {
                throw new UnsupportedItemTypeException(this.sourceLoc, FUN_NAME, ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            }
        } else if (this.aggType == ATypeTag.SYSTEM_NULL) {
            if (ILogicalBinaryComparator.inequalityUndefined((ATypeTag)typeTag)) {
                this.handleUnsupportedInput(typeTag);
                return;
            }
            this.aggType = typeTag;
            this.cmp = ComparatorUtil.createLogicalComparator((IAType)this.aggFieldType, (IAType)this.aggFieldType, (boolean)false);
            this.outputVal.assign((IValueReference)this.inputVal);
        } else if (!ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)this.aggType)) {
            this.handleIncompatibleInput(typeTag);
        } else {
            if (this.aggType == typeTag) {
                this.compareAndUpdate(this.cmp, this.inputVal, this.outputVal, typeTag);
                return;
            }
            if (ATypeHierarchy.canPromote((ATypeTag)this.aggType, (ATypeTag)typeTag)) {
                AbstractMinMaxAggregateFunction.castValue(ATypeHierarchy.getTypePromoteComputer((ATypeTag)this.aggType, (ATypeTag)typeTag), (IPointable)this.outputVal, this.tempValForCasting);
                this.outputVal.assign((IValueReference)this.tempValForCasting);
                this.compareAndUpdate(this.cmp, this.inputVal, this.outputVal, typeTag);
                this.aggType = typeTag;
            } else {
                AbstractMinMaxAggregateFunction.castValue(ATypeHierarchy.getTypePromoteComputer((ATypeTag)typeTag, (ATypeTag)this.aggType), this.inputVal, this.tempValForCasting);
                this.compareAndUpdate(this.cmp, (IPointable)this.tempValForCasting, this.outputVal, typeTag);
            }
        }
    }

    public void finish(IPointable result) throws HyracksDataException {
        this.finish(result, false);
    }

    public void finishPartial(IPointable result) throws HyracksDataException {
        this.finish(result, true);
    }

    private void finish(IPointable result, boolean isPartial) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            switch (this.aggType) {
                case NULL: {
                    this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                case SYSTEM_NULL: {
                    if (this.type == Type.LOCAL || this.type == Type.INTERMEDIATE || isPartial) {
                        this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
                    } else {
                        this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    }
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                default: {
                    result.set((IValueReference)this.outputVal);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract void processNull();

    private boolean skipStep() {
        return this.aggType == ATypeTag.NULL;
    }

    private void handleIncompatibleInput(ATypeTag typeTag) {
        ExceptionUtil.warnIncompatibleType((IEvaluatorContext)this.context, (SourceLocation)this.sourceLoc, (String)FUN_NAME, (ATypeTag)this.aggType, (ATypeTag)typeTag);
        this.aggType = ATypeTag.NULL;
    }

    private void handleUnsupportedInput(ATypeTag typeTag) {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.context, (SourceLocation)this.sourceLoc, (String)FUN_NAME, (ATypeTag)typeTag);
        this.aggType = ATypeTag.NULL;
    }

    private void compareAndUpdate(ILogicalBinaryComparator c, IPointable newVal, ArrayBackedValueStorage currentVal, ATypeTag typeTag) throws HyracksDataException {
        byte[] newValByteArray = newVal.getByteArray();
        int newValStartOffset = newVal.getStartOffset();
        byte[] currentValByteArray = currentVal.getByteArray();
        int currentValStartOffset = currentVal.getStartOffset();
        this.value1.set(newValByteArray, newValStartOffset + 1, newVal.getLength() - 1, ATypeTag.VALUE_TYPE_MAPPING[newValByteArray[newValStartOffset]]);
        this.value2.set(currentValByteArray, currentValStartOffset + 1, currentVal.getLength() - 1, ATypeTag.VALUE_TYPE_MAPPING[newValByteArray[newValStartOffset]]);
        ILogicalBinaryComparator.Result result = c.compare(this.value1, this.value2);
        switch (result) {
            case LT: {
                if (!this.isMin) break;
                currentVal.assign((IValueReference)newVal);
                break;
            }
            case GT: {
                if (this.isMin) break;
                currentVal.assign((IValueReference)newVal);
                break;
            }
            case MISSING: 
            case NULL: {
                this.aggType = ATypeTag.NULL;
                return;
            }
            case INCOMPARABLE: {
                this.handleIncompatibleInput(typeTag);
                return;
            }
        }
    }

    private static void castValue(ITypeConvertComputer typeConverter, IPointable inputValue, ArrayBackedValueStorage tempValForCasting) throws HyracksDataException {
        tempValForCasting.reset();
        try {
            typeConverter.convertType(inputValue.getByteArray(), inputValue.getStartOffset() + 1, inputValue.getLength() - 1, tempValForCasting.getDataOutput());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    static enum Type {
        LOCAL,
        INTERMEDIATE,
        GLOBAL,
        ONE_STEP;

    }
}

