/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.ITuplePartitioner;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.util.ResourceReleaseUtils;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class IndexInsertUpdateDeleteOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IHyracksTaskContext ctx;
    protected final RecordDescriptor inputRecDesc;
    protected final IndexOperation op;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected FrameTupleAccessor accessor;
    protected FrameTupleReference frameTuple;
    protected IFrame writeBuffer;
    protected ITupleFilter tupleFilter;
    protected final IIndex[] indexes;
    protected final IIndexAccessor[] indexAccessors;
    protected final IIndexDataflowHelper[] indexHelpers;
    protected final boolean[] indexHelpersOpen;
    protected final IModificationOperationCallback[] modCallbacks;
    protected final IModificationOperationCallbackFactory modOpCallbackFactory;
    protected final ITupleFilterFactory tupleFilterFactory;
    protected final ITuplePartitioner tuplePartitioner;
    protected final int[] partitions;
    protected final Int2IntMap storagePartitionId2Index;
    protected boolean writerOpen;
    protected boolean failed;

    public IndexInsertUpdateDeleteOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, IModificationOperationCallbackFactory modOpCallbackFactory, ITupleFilterFactory tupleFilterFactory, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        this.ctx = ctx;
        this.partitions = partitionsMap[partition];
        this.indexes = new IIndex[this.partitions.length];
        this.indexAccessors = new IIndexAccessor[this.partitions.length];
        this.modCallbacks = new IModificationOperationCallback[this.partitions.length];
        this.storagePartitionId2Index = new Int2IntOpenHashMap();
        this.indexHelpers = new IIndexDataflowHelper[this.partitions.length];
        this.indexHelpersOpen = new boolean[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.storagePartitionId2Index.put(this.partitions[i], i);
            this.indexHelpers[i] = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), this.partitions[i]);
        }
        this.modOpCallbackFactory = modOpCallbackFactory;
        this.tupleFilterFactory = tupleFilterFactory;
        this.inputRecDesc = inputRecDesc;
        this.op = op;
        this.tuple.setFieldPermutation(fieldPermutation);
        this.tuplePartitioner = tuplePartitionerFactory.createPartitioner(ctx);
        this.failed = false;
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        try {
            for (int i = 0; i < this.indexHelpers.length; ++i) {
                IIndexDataflowHelper indexHelper = this.indexHelpers[i];
                this.indexHelpersOpen[i] = true;
                indexHelper.open();
                this.indexes[i] = indexHelper.getIndexInstance();
                LocalResource resource = indexHelper.getResource();
                this.modCallbacks[i] = this.modOpCallbackFactory.createModificationOperationCallback(resource, this.ctx, (IOperatorNodePushable)this);
                IndexAccessParameters iap = new IndexAccessParameters(this.modCallbacks[i], NoOpOperationCallback.INSTANCE);
                this.indexAccessors[i] = this.indexes[i].createAccessor((IIndexAccessParameters)iap);
            }
            this.writer.open();
            this.writerOpen = true;
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        block13: for (int i = 0; i < tupleCount; ++i) {
            try {
                if (this.tupleFilter != null) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                }
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, i);
                int storageIdx = this.storagePartitionId2Index.get(storagePartition);
                IIndexAccessor indexAccessor = this.indexAccessors[storageIdx];
                switch (this.op) {
                    case INSERT: {
                        try {
                            indexAccessor.insert((ITupleReference)this.tuple);
                            break;
                        }
                        catch (HyracksDataException e) {
                            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) continue block13;
                            throw e;
                        }
                    }
                    case UPDATE: {
                        indexAccessor.update((ITupleReference)this.tuple);
                        break;
                    }
                    case UPSERT: {
                        indexAccessor.upsert((ITupleReference)this.tuple);
                        break;
                    }
                    case DELETE: {
                        try {
                            indexAccessor.delete((ITupleReference)this.tuple);
                            break;
                        }
                        catch (HyracksDataException e) {
                            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) continue block13;
                            throw e;
                        }
                    }
                    default: {
                        throw new HyracksDataException("Unsupported operation " + this.op + " in tree index InsertUpdateDelete operator");
                    }
                }
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
        Throwable failure = null;
        try {
            if (this.writerOpen) {
                this.writer.close();
            }
        }
        catch (Throwable th) {
            failure = th;
        }
        finally {
            failure = this.closeIndexHelpers(failure);
        }
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        if (this.writerOpen) {
            this.writer.fail();
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }

    protected Throwable closeIndexHelpers(Throwable failure) {
        for (int i = 0; i < this.indexHelpers.length; ++i) {
            if (!this.indexHelpersOpen[i]) continue;
            failure = ResourceReleaseUtils.close(this.indexHelpers[i], failure);
        }
        return failure;
    }
}

