/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.result;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.IResultSerializer;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.dataflow.common.comm.io.FrameOutputStream;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;

public class ResultWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final ResultSetId rsId;
    private final IResultMetadata metadata;
    private final boolean asyncMode;
    private final IResultSerializerFactory resultSerializerFactory;
    private final long maxReads;

    public ResultWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, ResultSetId rsId, IResultMetadata metadata, boolean asyncMode, IResultSerializerFactory resultSerializerFactory, long maxReads) throws IOException {
        super(spec, 1, 0);
        this.rsId = rsId;
        this.metadata = metadata;
        this.asyncMode = asyncMode;
        this.resultSerializerFactory = resultSerializerFactory;
        this.maxReads = maxReads;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
        final IResultPartitionManager resultPartitionManager = ctx.getResultPartitionManager();
        VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        final FrameOutputStream frameOutputStream = new FrameOutputStream(ctx.getInitialFrameSize());
        frameOutputStream.reset((IFrame)frame, true);
        PrintStream printStream = new PrintStream((OutputStream)frameOutputStream);
        RecordDescriptor outRecordDesc = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
        final IResultSerializer resultSerializer = this.resultSerializerFactory.createResultSerializer(outRecordDesc, printStream);
        final FrameTupleAccessor frameTupleAccessor = new FrameTupleAccessor(outRecordDesc);
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private IFrameWriter resultPartitionWriter;
            private boolean failed = false;

            public void open() throws HyracksDataException {
                try {
                    this.resultPartitionWriter = resultPartitionManager.createResultPartitionWriter(ctx, ResultWriterOperatorDescriptor.this.rsId, ResultWriterOperatorDescriptor.this.metadata, ResultWriterOperatorDescriptor.this.asyncMode, partition, nPartitions, ResultWriterOperatorDescriptor.this.maxReads);
                    this.resultPartitionWriter.open();
                    resultSerializer.init();
                }
                catch (HyracksException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                frameTupleAccessor.reset(buffer);
                for (int tIndex = 0; tIndex < frameTupleAccessor.getTupleCount(); ++tIndex) {
                    resultSerializer.appendTuple((IFrameTupleAccessor)frameTupleAccessor, tIndex);
                    if (!frameOutputStream.appendTuple()) {
                        frameOutputStream.flush(this.resultPartitionWriter);
                        if (!frameOutputStream.appendTuple()) {
                            throw HyracksDataException.create((ErrorCode)ErrorCode.TUPLE_CANNOT_FIT_INTO_EMPTY_FRAME, (Serializable[])new Serializable[]{Integer.valueOf(frameOutputStream.getLength())});
                        }
                    }
                    frameOutputStream.reset();
                }
            }

            public void fail() throws HyracksDataException {
                this.failed = true;
                if (this.resultPartitionWriter != null) {
                    this.resultPartitionWriter.fail();
                }
            }

            public void close() throws HyracksDataException {
                if (this.resultPartitionWriter != null) {
                    try {
                        if (!this.failed && frameOutputStream.getTupleCount() > 0) {
                            frameOutputStream.flush(this.resultPartitionWriter);
                        }
                    }
                    catch (Exception e) {
                        this.resultPartitionWriter.fail();
                        throw e;
                    }
                    finally {
                        this.resultPartitionWriter.close();
                    }
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("{ ");
                sb.append("\"rsId\": \"").append(ResultWriterOperatorDescriptor.this.rsId).append("\", ");
                sb.append("\"metadata\": ").append(ResultWriterOperatorDescriptor.this.metadata).append(", ");
                sb.append("\"asyncMode\": ").append(ResultWriterOperatorDescriptor.this.asyncMode).append(", ");
                sb.append("\"maxReads\": ").append(ResultWriterOperatorDescriptor.this.maxReads).append(" }");
                return sb.toString();
            }

            @Override
            public String getDisplayName() {
                return "Result Writer";
            }
        };
    }
}

