/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.ant.antunit.AntUnitExecutionNotifier;
import org.apache.ant.antunit.AntUnitListener;
import org.apache.ant.antunit.AntUnitScriptRunner;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.ProjectFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class AntUnit
extends Task {
    public static final String ERROR_TESTS_FAILED = "Tests failed with ";
    public static final String ERROR_NO_TESTS = "You must specify build files to test.";
    public static final String ERROR_NON_FILES = "Only file system resources are supported.";
    private Union buildFiles;
    private AntUnitExecutionNotifier notifier = new AntUnitExecutionNotifier(){

        public void fireEndTest(String targetName) {
            AntUnit.this.fireEndTest(targetName);
        }

        public void fireError(String targetName, Throwable t) {
            AntUnit.this.fireError(targetName, t);
        }

        public void fireFail(String targetName, AssertionFailedException ae) {
            AntUnit.this.fireFail(targetName, ae);
        }

        public void fireStartTest(String targetName) {
            AntUnit.this.fireStartTest(targetName);
        }
    };
    private AntUnitScriptRunner scriptRunner;
    private ArrayList listeners = new ArrayList();
    private ArrayList propertySets = new ArrayList();
    private ArrayList referenceSets = new ArrayList();
    private int failures = 0;
    private int errors = 0;
    private boolean failOnError = true;
    private String errorProperty = null;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void add(ResourceCollection rc) {
        if (this.buildFiles == null) {
            this.buildFiles = new Union();
        }
        this.buildFiles.add(rc);
    }

    public void add(AntUnitListener al) {
        this.listeners.add(al);
        al.setParentTask(this);
    }

    public void addPropertySet(PropertySet ps) {
        this.propertySets.add(ps);
    }

    public ReferenceSet createReferenceSet() {
        ReferenceSet set = new ReferenceSet();
        set.setProject(this.getProject());
        this.referenceSets.add(set);
        return set;
    }

    public void addReference(Reference reference) {
        this.createReferenceSet().addReference(reference);
    }

    public void setErrorProperty(String s) {
        this.errorProperty = s;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() {
        if (this.buildFiles == null) {
            throw new BuildException(ERROR_NO_TESTS);
        }
        this.doResourceCollection((ResourceCollection)this.buildFiles);
        if (this.failures > 0 || this.errors > 0) {
            if (this.errorProperty != null) {
                this.getProject().setNewProperty(this.errorProperty, "true");
            }
            if (this.failOnError) {
                throw new BuildException(ERROR_TESTS_FAILED + this.failures + " failure" + (this.failures != 1 ? "s" : "") + " and " + this.errors + " error" + (this.errors != 1 ? "s" : ""));
            }
        }
    }

    private void doResourceCollection(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException(ERROR_NON_FILES);
        }
        Iterator i = rc.iterator();
        while (i.hasNext()) {
            FileResource r = (FileResource)i.next();
            if (r.isExists()) {
                this.doFile(r.getFile());
                continue;
            }
            this.log("Skipping " + r + " since it doesn't exist", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFile(final File f) {
        this.log("Running tests in build file " + f, 4);
        ProjectFactory prjFactory = new ProjectFactory(){

            public Project createProject() {
                return AntUnit.this.createProjectForFile(f);
            }
        };
        try {
            this.scriptRunner = new AntUnitScriptRunner(prjFactory);
            List testTargets = this.scriptRunner.getTestTartgets();
            this.scriptRunner.runSuite(testTargets, this.notifier);
        }
        finally {
            this.scriptRunner = null;
        }
    }

    public void handleOutput(String outputToHandle) {
        if (this.scriptRunner != null) {
            this.scriptRunner.getCurrentProject().demuxOutput(outputToHandle, false);
        } else {
            super.handleOutput(outputToHandle);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.scriptRunner != null) {
            return this.scriptRunner.getCurrentProject().demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String toFlush) {
        if (this.scriptRunner != null) {
            this.scriptRunner.getCurrentProject().demuxFlush(toFlush, false);
        } else {
            super.handleFlush(toFlush);
        }
    }

    public void handleErrorOutput(String errorOutputToHandle) {
        if (this.scriptRunner != null) {
            this.scriptRunner.getCurrentProject().demuxOutput(errorOutputToHandle, true);
        } else {
            super.handleErrorOutput(errorOutputToHandle);
        }
    }

    public void handleErrorFlush(String errorOutputToFlush) {
        if (this.scriptRunner != null) {
            this.scriptRunner.getCurrentProject().demuxFlush(errorOutputToFlush, true);
        } else {
            super.handleErrorFlush(errorOutputToFlush);
        }
    }

    private Project createProjectForFile(File f) {
        Object set;
        Project p = new Project();
        p.setDefaultInputStream(this.getProject().getDefaultInputStream());
        p.initProperties();
        p.setInputHandler(this.getProject().getInputHandler());
        this.getProject().initSubProject(p);
        Iterator outer = this.propertySets.iterator();
        while (outer.hasNext()) {
            set = (PropertySet)outer.next();
            Properties props = set.getProperties();
            Iterator keys = props.keySet().iterator();
            while (keys.hasNext()) {
                Object value;
                String key = keys.next().toString();
                if ("basedir".equals(key) || "ant.file".equals(key) || (value = props.get(key)) == null || !(value instanceof String) || p.getProperty(key) != null) continue;
                p.setNewProperty(key, (String)value);
            }
        }
        for (int i = 0; i < this.referenceSets.size(); ++i) {
            set = (ReferenceSet)((Object)this.referenceSets.get(i));
            ((ReferenceSet)((Object)set)).copyReferencesInto(p);
        }
        p.setUserProperty("ant.file", f.getAbsolutePath());
        this.attachListeners(f, p);
        ProjectHelper.configureProject((Project)p, (File)f);
        return p;
    }

    private void attachListeners(File buildFile, Project p) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            p.addBuildListener((BuildListener)new BuildToAntUnitListener(buildFile.getAbsolutePath(), al));
            al.setCurrentTestProject(p);
        }
    }

    private void fireStartTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.startTest(targetName);
        }
    }

    private void fireFail(String targetName, AssertionFailedException ae) {
        ++this.failures;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addFailure(targetName, ae);
        }
    }

    private void fireError(String targetName, Throwable t) {
        ++this.errors;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addError(targetName, t);
        }
    }

    private void fireEndTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.endTest(targetName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BuildToAntUnitListener
    implements BuildListener {
        private String buildFile;
        private AntUnitListener a;

        BuildToAntUnitListener(String buildFile, AntUnitListener a) {
            this.buildFile = buildFile;
            this.a = a;
        }

        public void buildStarted(BuildEvent event) {
            this.a.startTestSuite(event.getProject(), this.buildFile);
        }

        public void buildFinished(BuildEvent event) {
            this.a.endTestSuite(event.getProject(), this.buildFile);
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }
    }

    public static class Reference
    extends Ant.Reference {
        private String regex;
        private RegexpMatcher matcher;

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
            RegexpMatcherFactory matchMaker = new RegexpMatcherFactory();
            this.matcher = matchMaker.newRegexpMatcher();
            this.matcher.setPattern(regex);
        }

        public void addMatchingReferences(Hashtable src, Collection dest) {
            String id = this.getRefId();
            if (id != null) {
                if (src.containsKey(id)) {
                    dest.add(id);
                }
            } else if (this.matcher != null) {
                Iterator it = src.keySet().iterator();
                while (it.hasNext()) {
                    String refid = (String)it.next();
                    if (!this.matcher.matches(refid)) continue;
                    dest.add(refid);
                }
            } else {
                throw new BuildException("either the refid or regex attribute is required for reference elements");
            }
        }
    }

    public static class ReferenceSet
    extends ProjectComponent {
        private ArrayList references = new ArrayList();
        private Mapper mapper;

        public void addReference(Reference reference) {
            this.references.add(reference);
        }

        public Mapper createMapper() {
            if (this.mapper == null) {
                this.mapper = new Mapper(this.getProject());
                return this.mapper;
            }
            throw new BuildException("Only one mapper element is allowed per referenceSet", this.getLocation());
        }

        public void setMapper(String typeName, String from, String to) {
            Mapper mapper = this.createMapper();
            Mapper.MapperType type = new Mapper.MapperType();
            type.setValue(typeName);
            mapper.setType(type);
            mapper.setFrom(from);
            mapper.setTo(to);
        }

        public void copyReferencesInto(Project newProject) {
            FileNameMapper mapper = this.mapper == null ? null : this.mapper.getImplementation();
            HashSet matches = new HashSet();
            Hashtable src = this.getProject().getReferences();
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)((Object)it.next());
                matches.clear();
                ref.addMatchingReferences(src, matches);
                Iterator ids = matches.iterator();
                while (ids.hasNext()) {
                    String[] mapped;
                    String refid = (String)ids.next();
                    String toRefid = ref.getToRefid();
                    if (mapper != null && toRefid == null && (mapped = mapper.mapFileName(refid)) != null) {
                        toRefid = mapped[0];
                    }
                    if (toRefid == null) {
                        toRefid = refid;
                    }
                    this.copyReference(refid, newProject, toRefid);
                }
            }
        }

        private void copyReference(String oldKey, Project newProject, String newKey) {
            Object orig = this.getProject().getReference(oldKey);
            if (orig == null) {
                this.log("No object referenced by " + oldKey + ". Can't copy to " + newKey, 1);
                return;
            }
            Class<?> c = orig.getClass();
            Object copy = orig;
            try {
                Method cloneM = c.getMethod("clone", new Class[0]);
                if (cloneM != null) {
                    copy = cloneM.invoke(orig, new Object[0]);
                    this.log("Adding clone of reference " + oldKey, 4);
                }
            }
            catch (Exception cloneM) {
                // empty catch block
            }
            if (copy instanceof ProjectComponent) {
                ((ProjectComponent)copy).setProject(newProject);
            } else {
                try {
                    Method setProjectM = c.getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntUnit.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                    if (setProjectM != null) {
                        setProjectM.invoke(copy, newProject);
                    }
                }
                catch (NoSuchMethodException setProjectM) {
                }
                catch (Exception e2) {
                    String msg = "Error setting new project instance for reference with id " + oldKey;
                    throw new BuildException(msg, (Throwable)e2, this.getLocation());
                }
            }
            newProject.addReference(newKey, copy);
        }
    }
}

