/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileInputFilter<K, V>
extends SequenceFileInputFormat<K, V> {
    private static final String FILTER_CLASS = "sequencefile.filter.class";
    private static final String FILTER_FREQUENCY = "sequencefile.filter.frequency";
    private static final String FILTER_REGEX = "sequencefile.filter.regex";

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new FilterRecordReader(job, (FileSplit)split);
    }

    public static void setFilterClass(Configuration conf, Class filterClass) {
        conf.set(FILTER_CLASS, filterClass.getName());
    }

    private static class FilterRecordReader<K, V>
    extends SequenceFileRecordReader<K, V> {
        private Filter filter;

        public FilterRecordReader(Configuration conf, FileSplit split) throws IOException {
            super(conf, split);
            this.filter = (Filter)ReflectionUtils.newInstance(conf.getClass(SequenceFileInputFilter.FILTER_CLASS, PercentFilter.class), conf);
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            while (this.next(key)) {
                if (!this.filter.accept(key)) continue;
                this.getCurrentValue(value);
                return true;
            }
            return false;
        }
    }

    public static class MD5Filter
    extends FilterBase {
        private int frequency;
        private static final MessageDigest DIGESTER;
        public static final int MD5_LEN = 16;
        private byte[] digest = new byte[16];

        public static void setFrequency(Configuration conf, int frequency) {
            if (frequency <= 0) {
                throw new IllegalArgumentException("Negative sequencefile.filter.frequency: " + frequency);
            }
            conf.setInt(SequenceFileInputFilter.FILTER_FREQUENCY, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.frequency = conf.getInt(SequenceFileInputFilter.FILTER_FREQUENCY, 10);
            if (this.frequency <= 0) {
                throw new RuntimeException("Negative sequencefile.filter.frequency: " + this.frequency);
            }
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            try {
                long hashcode;
                if (key instanceof Text) {
                    hashcode = this.MD5Hashcode((Text)key);
                } else if (key instanceof BytesWritable) {
                    hashcode = this.MD5Hashcode((BytesWritable)key);
                } else {
                    ByteBuffer bb = Text.encode(key.toString());
                    hashcode = this.MD5Hashcode(bb.array(), 0, bb.limit());
                }
                if (hashcode / (long)this.frequency * (long)this.frequency == hashcode) {
                    return true;
                }
            }
            catch (Exception e) {
                FileInputFormat.LOG.warn(e);
                throw new RuntimeException(e);
            }
            return false;
        }

        private long MD5Hashcode(Text key) throws DigestException {
            return this.MD5Hashcode(key.getBytes(), 0, key.getLength());
        }

        private long MD5Hashcode(BytesWritable key) throws DigestException {
            return this.MD5Hashcode(key.getBytes(), 0, key.getLength());
        }

        private synchronized long MD5Hashcode(byte[] bytes, int start, int length) throws DigestException {
            DIGESTER.update(bytes, 0, length);
            DIGESTER.digest(this.digest, 0, 16);
            long hashcode = 0L;
            for (int i = 0; i < 8; ++i) {
                hashcode |= ((long)this.digest[i] & 0xFFL) << 8 * (7 - i);
            }
            return hashcode;
        }

        static {
            try {
                DIGESTER = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PercentFilter
    extends FilterBase {
        private int frequency;
        private int count;

        public static void setFrequency(Configuration conf, int frequency) {
            if (frequency <= 0) {
                throw new IllegalArgumentException("Negative sequencefile.filter.frequency: " + frequency);
            }
            conf.setInt(SequenceFileInputFilter.FILTER_FREQUENCY, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.frequency = conf.getInt(SequenceFileInputFilter.FILTER_FREQUENCY, 10);
            if (this.frequency <= 0) {
                throw new RuntimeException("Negative sequencefile.filter.frequency: " + this.frequency);
            }
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            boolean accepted = false;
            if (this.count == 0) {
                accepted = true;
            }
            if (++this.count == this.frequency) {
                this.count = 0;
            }
            return accepted;
        }
    }

    public static class RegexFilter
    extends FilterBase {
        private Pattern p;

        public static void setPattern(Configuration conf, String regex) throws PatternSyntaxException {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid pattern: " + regex);
            }
            conf.set(SequenceFileInputFilter.FILTER_REGEX, regex);
        }

        @Override
        public void setConf(Configuration conf) {
            String regex = conf.get(SequenceFileInputFilter.FILTER_REGEX);
            if (regex == null) {
                throw new RuntimeException("sequencefile.filter.regexnot set");
            }
            this.p = Pattern.compile(regex);
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            return this.p.matcher(key.toString()).matches();
        }
    }

    public static abstract class FilterBase
    implements Filter {
        Configuration conf;

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }

    public static interface Filter
    extends Configurable {
        public boolean accept(Object var1);
    }
}

