/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] name, long posNom, TypeReference tr, int modifiers) {
        super(name, (int)(posNom >>> 32), (int)posNom);
        this.declarationSourceEnd = (int)posNom;
        this.modifiers = modifiers;
        this.type = tr;
        this.bits |= 0x40000000;
    }

    public void bind(MethodScope scope, TypeBinding typeBinding, boolean used) {
        int modifierFlag = this.modifiers;
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (existingVariable != null && existingVariable.isValidBinding()) {
            if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                scope.problemReporter().redefineArgument(this);
                return;
            }
            boolean isSpecialArgument = false;
            if (existingVariable instanceof FieldBinding) {
                if (scope.isInsideConstructor()) {
                    isSpecialArgument = true;
                } else {
                    AbstractMethodDeclaration methodDecl = scope.referenceMethod();
                    if (methodDecl != null && CharOperation.prefixEquals(SET, methodDecl.selector)) {
                        isSpecialArgument = true;
                    }
                }
            }
            scope.problemReporter().localVariableHiding(this, existingVariable, isSpecialArgument);
        }
        this.binding = new LocalVariableBinding(this, typeBinding, modifierFlag, true);
        scope.addLocalVariable(this.binding);
        Argument.resolveAnnotations(scope, this.annotations, this.binding);
        this.binding.declaration = this;
        this.binding.useFlag = used ? 1 : 0;
    }

    public int getKind() {
        return 5;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        Argument.printIndent(indent, output);
        Argument.printModifiers(this.modifiers, output);
        if (this.annotations != null) {
            Argument.printAnnotations(this.annotations, output);
        }
        if (this.type == null) {
            output.append("<no type> ");
        } else {
            this.type.print(0, output).append(' ');
        }
        return output.append(this.name);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope scope) {
        TypeBinding exceptionType = this.type.resolveType(scope, true);
        if (exceptionType == null) {
            return null;
        }
        if (exceptionType.isGenericType() || exceptionType.isBoundParameterizedType()) {
            scope.problemReporter().invalidParameterizedExceptionType(exceptionType, this);
            return null;
        }
        if (exceptionType.isTypeVariable()) {
            scope.problemReporter().invalidTypeVariableAsException(exceptionType, this);
            return null;
        }
        ReferenceBinding throwable = scope.getJavaLangThrowable();
        if (!exceptionType.isCompatibleWith(throwable)) {
            scope.problemReporter().typeMismatchError(exceptionType, throwable, this);
            return null;
        }
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (existingVariable != null && existingVariable.isValidBinding()) {
            if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                scope.problemReporter().redefineArgument(this);
                return null;
            }
            scope.problemReporter().localVariableHiding(this, existingVariable, false);
        }
        this.binding = new LocalVariableBinding(this, exceptionType, this.modifiers, false);
        Argument.resolveAnnotations(scope, this.annotations, this.binding);
        scope.addLocalVariable(this.binding);
        this.binding.setConstant(NotAConstant);
        return exceptionType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

