#  Licensed to the Apache Software Foundation (ASF) under one
#  or more contributor license agreements. See the NOTICE file
#  distributed with this work for additional information
#  regarding copyright ownership. The ASF licenses this file
#  to you under the Apache License, Version 2.0 (the
#  "License"); you may not use this file except in compliance
#  with the License. You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing,
#   software distributed under the License is distributed on an
#   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#   KIND, either express or implied. See the License for the
#   specific language governing permissions and limitations
#   under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

import custos.server.core.IdentityService_pb2 as IdentityService__pb2
from google.protobuf import struct_pb2 as google_dot_protobuf_dot_struct__pb2


class IdentityServiceStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.authenticate = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/authenticate',
                request_serializer=IdentityService__pb2.AuthenticationRequest.SerializeToString,
                response_deserializer=IdentityService__pb2.AuthToken.FromString,
                )
        self.isAuthenticated = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/isAuthenticated',
                request_serializer=IdentityService__pb2.AuthToken.SerializeToString,
                response_deserializer=IdentityService__pb2.IsAuthenticatedResponse.FromString,
                )
        self.getUser = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getUser',
                request_serializer=IdentityService__pb2.AuthToken.SerializeToString,
                response_deserializer=IdentityService__pb2.User.FromString,
                )
        self.getUserManagementServiceAccountAccessToken = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getUserManagementServiceAccountAccessToken',
                request_serializer=IdentityService__pb2.GetUserManagementSATokenRequest.SerializeToString,
                response_deserializer=IdentityService__pb2.AuthToken.FromString,
                )
        self.getToken = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getToken',
                request_serializer=IdentityService__pb2.GetTokenRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_struct__pb2.Struct.FromString,
                )
        self.getAuthorizeEndpoint = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getAuthorizeEndpoint',
                request_serializer=IdentityService__pb2.GetAuthorizationEndpointRequest.SerializeToString,
                response_deserializer=IdentityService__pb2.AuthorizationResponse.FromString,
                )
        self.getOIDCConfiguration = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getOIDCConfiguration',
                request_serializer=IdentityService__pb2.GetOIDCConfiguration.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_struct__pb2.Struct.FromString,
                )
        self.getTokenByPasswordGrantType = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getTokenByPasswordGrantType',
                request_serializer=IdentityService__pb2.GetTokenRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_struct__pb2.Struct.FromString,
                )
        self.getTokenByRefreshTokenGrantType = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getTokenByRefreshTokenGrantType',
                request_serializer=IdentityService__pb2.GetTokenRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_struct__pb2.Struct.FromString,
                )
        self.getJWKS = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/getJWKS',
                request_serializer=IdentityService__pb2.GetJWKSRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_struct__pb2.Struct.FromString,
                )
        self.endSession = channel.unary_unary(
                '/org.apache.custos.identity.service.IdentityService/endSession',
                request_serializer=IdentityService__pb2.EndSessionRequest.SerializeToString,
                response_deserializer=IdentityService__pb2.OperationStatus.FromString,
                )


class IdentityServiceServicer(object):
    """Missing associated documentation comment in .proto file."""

    def authenticate(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def isAuthenticated(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getUser(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getUserManagementServiceAccountAccessToken(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getToken(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getAuthorizeEndpoint(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getOIDCConfiguration(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTokenByPasswordGrantType(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTokenByRefreshTokenGrantType(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getJWKS(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def endSession(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_IdentityServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'authenticate': grpc.unary_unary_rpc_method_handler(
                    servicer.authenticate,
                    request_deserializer=IdentityService__pb2.AuthenticationRequest.FromString,
                    response_serializer=IdentityService__pb2.AuthToken.SerializeToString,
            ),
            'isAuthenticated': grpc.unary_unary_rpc_method_handler(
                    servicer.isAuthenticated,
                    request_deserializer=IdentityService__pb2.AuthToken.FromString,
                    response_serializer=IdentityService__pb2.IsAuthenticatedResponse.SerializeToString,
            ),
            'getUser': grpc.unary_unary_rpc_method_handler(
                    servicer.getUser,
                    request_deserializer=IdentityService__pb2.AuthToken.FromString,
                    response_serializer=IdentityService__pb2.User.SerializeToString,
            ),
            'getUserManagementServiceAccountAccessToken': grpc.unary_unary_rpc_method_handler(
                    servicer.getUserManagementServiceAccountAccessToken,
                    request_deserializer=IdentityService__pb2.GetUserManagementSATokenRequest.FromString,
                    response_serializer=IdentityService__pb2.AuthToken.SerializeToString,
            ),
            'getToken': grpc.unary_unary_rpc_method_handler(
                    servicer.getToken,
                    request_deserializer=IdentityService__pb2.GetTokenRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_struct__pb2.Struct.SerializeToString,
            ),
            'getAuthorizeEndpoint': grpc.unary_unary_rpc_method_handler(
                    servicer.getAuthorizeEndpoint,
                    request_deserializer=IdentityService__pb2.GetAuthorizationEndpointRequest.FromString,
                    response_serializer=IdentityService__pb2.AuthorizationResponse.SerializeToString,
            ),
            'getOIDCConfiguration': grpc.unary_unary_rpc_method_handler(
                    servicer.getOIDCConfiguration,
                    request_deserializer=IdentityService__pb2.GetOIDCConfiguration.FromString,
                    response_serializer=google_dot_protobuf_dot_struct__pb2.Struct.SerializeToString,
            ),
            'getTokenByPasswordGrantType': grpc.unary_unary_rpc_method_handler(
                    servicer.getTokenByPasswordGrantType,
                    request_deserializer=IdentityService__pb2.GetTokenRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_struct__pb2.Struct.SerializeToString,
            ),
            'getTokenByRefreshTokenGrantType': grpc.unary_unary_rpc_method_handler(
                    servicer.getTokenByRefreshTokenGrantType,
                    request_deserializer=IdentityService__pb2.GetTokenRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_struct__pb2.Struct.SerializeToString,
            ),
            'getJWKS': grpc.unary_unary_rpc_method_handler(
                    servicer.getJWKS,
                    request_deserializer=IdentityService__pb2.GetJWKSRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_struct__pb2.Struct.SerializeToString,
            ),
            'endSession': grpc.unary_unary_rpc_method_handler(
                    servicer.endSession,
                    request_deserializer=IdentityService__pb2.EndSessionRequest.FromString,
                    response_serializer=IdentityService__pb2.OperationStatus.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'org.apache.custos.identity.service.IdentityService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class IdentityService(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def authenticate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/authenticate',
            IdentityService__pb2.AuthenticationRequest.SerializeToString,
            IdentityService__pb2.AuthToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def isAuthenticated(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/isAuthenticated',
            IdentityService__pb2.AuthToken.SerializeToString,
            IdentityService__pb2.IsAuthenticatedResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getUser',
            IdentityService__pb2.AuthToken.SerializeToString,
            IdentityService__pb2.User.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getUserManagementServiceAccountAccessToken(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getUserManagementServiceAccountAccessToken',
            IdentityService__pb2.GetUserManagementSATokenRequest.SerializeToString,
            IdentityService__pb2.AuthToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getToken(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getToken',
            IdentityService__pb2.GetTokenRequest.SerializeToString,
            google_dot_protobuf_dot_struct__pb2.Struct.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getAuthorizeEndpoint(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getAuthorizeEndpoint',
            IdentityService__pb2.GetAuthorizationEndpointRequest.SerializeToString,
            IdentityService__pb2.AuthorizationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getOIDCConfiguration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getOIDCConfiguration',
            IdentityService__pb2.GetOIDCConfiguration.SerializeToString,
            google_dot_protobuf_dot_struct__pb2.Struct.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTokenByPasswordGrantType(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getTokenByPasswordGrantType',
            IdentityService__pb2.GetTokenRequest.SerializeToString,
            google_dot_protobuf_dot_struct__pb2.Struct.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTokenByRefreshTokenGrantType(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getTokenByRefreshTokenGrantType',
            IdentityService__pb2.GetTokenRequest.SerializeToString,
            google_dot_protobuf_dot_struct__pb2.Struct.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getJWKS(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/getJWKS',
            IdentityService__pb2.GetJWKSRequest.SerializeToString,
            google_dot_protobuf_dot_struct__pb2.Struct.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def endSession(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.identity.service.IdentityService/endSession',
            IdentityService__pb2.EndSessionRequest.SerializeToString,
            IdentityService__pb2.OperationStatus.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
