/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.management;

import io.grpc.Context;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.credential.store.api.CredentialMetadata;
import org.apache.custos.core.credential.store.api.Credentials;
import org.apache.custos.core.credential.store.api.GetCredentialRequest;
import org.apache.custos.core.identity.api.AuthToken;
import org.apache.custos.core.identity.api.AuthenticationRequest;
import org.apache.custos.core.identity.api.Claim;
import org.apache.custos.core.identity.api.GetAuthorizationEndpointRequest;
import org.apache.custos.core.identity.api.GetOIDCConfiguration;
import org.apache.custos.core.identity.api.GetTokenRequest;
import org.apache.custos.core.identity.api.GetUserManagementSATokenRequest;
import org.apache.custos.core.identity.api.IsAuthenticatedResponse;
import org.apache.custos.core.identity.api.OIDCConfiguration;
import org.apache.custos.core.identity.api.OperationStatus;
import org.apache.custos.core.identity.api.TokenResponse;
import org.apache.custos.core.identity.api.User;
import org.apache.custos.core.identity.management.api.AuthorizationRequest;
import org.apache.custos.core.identity.management.api.AuthorizationResponse;
import org.apache.custos.core.identity.management.api.EndSessionRequest;
import org.apache.custos.core.identity.management.api.GetCredentialsRequest;
import org.apache.custos.core.tenant.profile.api.GetTenantRequest;
import org.apache.custos.core.tenant.profile.api.GetTenantResponse;
import org.apache.custos.core.tenant.profile.api.Tenant;
import org.apache.custos.core.user.profile.api.UserProfile;
import org.apache.custos.core.user.profile.api.UserProfileRequest;
import org.apache.custos.service.auth.TokenService;
import org.apache.custos.service.credential.store.CredentialStoreService;
import org.apache.custos.service.exceptions.InternalServerException;
import org.apache.custos.service.identity.IdentityService;
import org.apache.custos.service.profile.TenantProfileService;
import org.apache.custos.service.profile.UserProfileService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IdentityManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityManagementService.class);
    private final IdentityService identityService;
    private final TenantProfileService tenantProfileService;
    private final CredentialStoreService credentialStoreService;
    private final UserProfileService userProfileService;
    private final TokenService tokenService;

    public IdentityManagementService(IdentityService identityService, TenantProfileService tenantProfileService, CredentialStoreService credentialStoreService, UserProfileService userProfileService, TokenService tokenService) {
        this.identityService = identityService;
        this.tenantProfileService = tenantProfileService;
        this.credentialStoreService = credentialStoreService;
        this.userProfileService = userProfileService;
        this.tokenService = tokenService;
    }

    public AuthToken authenticate(AuthenticationRequest request) {
        try {
            LOGGER.debug("Request received to authenticate for " + request.getUsername());
            return this.identityService.authenticate(request);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while authentication " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public User getUser(AuthToken request) {
        try {
            LOGGER.debug("Request received for getUser");
            return this.identityService.getUser(request);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while fetching user " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public AuthToken getUserManagementServiceAccountAccessToken(GetUserManagementSATokenRequest request) {
        try {
            LOGGER.debug("Request received to authenticate for " + request.getTenantId());
            return this.identityService.getUserManagementServiceAccountAccessToken(request);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while fetching service account " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public IsAuthenticatedResponse isAuthenticated(AuthToken request) {
        try {
            LOGGER.debug("Request received to isAuthenticated ");
            return this.identityService.isAuthenticated(request);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while fetching authenticated status " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public AuthorizationResponse authorize(AuthorizationRequest request) {
        try {
            LOGGER.debug("Request received  to authorize " + request.getClientId());
            GetCredentialRequest req = GetCredentialRequest.newBuilder().setId(request.getClientId()).build();
            CredentialMetadata metadata = this.credentialStoreService.getCustosCredentialFromClientId(req);
            GetTenantRequest tenantRequest = GetTenantRequest.newBuilder().setTenantId(metadata.getOwnerId()).build();
            GetTenantResponse tenantResponse = this.tenantProfileService.getTenant(tenantRequest);
            Tenant tenant = tenantResponse.getTenant();
            if (tenant.getRedirectUrisCount() == 0) {
                LOGGER.error("No redirect_uri has been associated with the Tenant, tenant Id: {}", (Object)tenant.getTenantId());
                throw new IllegalArgumentException("No redirect_uri has been associated with the Tenant, tenant Id: " + tenant.getTenantId());
            }
            boolean matched = false;
            for (String redirectURI : tenant.getRedirectUrisList()) {
                if (!request.getRedirectUri().equals(redirectURI)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                LOGGER.error("No matching redirect_uri is found for the Tenant with the Id: {}", (Object)tenant.getTenantId());
                throw new IllegalArgumentException("No matching redirect_uri is found for the Tenant with the Id: " + tenant.getTenantId());
            }
            GetAuthorizationEndpointRequest getAuthorizationEndpointRequest = GetAuthorizationEndpointRequest.newBuilder().setTenantId(metadata.getOwnerId()).build();
            org.apache.custos.core.identity.api.AuthorizationResponse response = this.identityService.getAuthorizeEndpoint(getAuthorizationEndpointRequest);
            String endpoint = response.getAuthorizationEndpoint();
            String query = "client_id=" + this.encode(metadata.getId()) + "&redirect_uri=" + this.encode(request.getRedirectUri()) + "&response_type=" + this.encode("code") + "&scope=" + this.encode((String)(request.getScope().contains("openid") ? request.getScope() : request.getScope() + " openid")) + "&state=" + this.encode(request.getState()) + "&kc_idp_hint=oidc";
            if (StringUtils.isNotBlank((CharSequence)request.getCodeChallenge()) && StringUtils.isNotBlank((CharSequence)request.getCodeChallengeMethod())) {
                query = query + "&code_challenge=" + this.encode(request.getCodeChallenge()) + "&code_challenge_method=" + this.encode(request.getCodeChallengeMethod());
            }
            String loginURL = endpoint + "?" + query;
            return AuthorizationResponse.newBuilder().setRedirectUri(loginURL).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while formulating the redirect uri " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    private String encode(String part) {
        return URLEncoder.encode(part, StandardCharsets.UTF_8);
    }

    public TokenResponse token(GetTokenRequest request) {
        try {
            LOGGER.debug("Request received  to token endpoint " + request.getTenantId());
            TokenResponse response = this.identityService.getToken(request);
            Context ctx = Context.current().fork();
            ctx.run(() -> {
                long tenantId = request.getTenantId();
                if (StringUtils.isNotBlank((CharSequence)response.getAccessToken())) {
                    LOGGER.debug(response.getAccessToken());
                    String clientId = request.getClientId();
                    AuthToken authToken = AuthToken.newBuilder().setAccessToken(response.getAccessToken()).addClaims(Claim.newBuilder().setKey("clientId").setValue(clientId).build()).addClaims(Claim.newBuilder().setKey("username").setValue("custos-auth-user")).addClaims(Claim.newBuilder().setKey("tenantId").setValue(String.valueOf(tenantId)).build()).build();
                    User user = this.identityService.getUser(authToken);
                    LOGGER.debug("User" + user.getUsername());
                    UserProfile userProfile = UserProfile.newBuilder().setUsername(user.getUsername()).setFirstName(user.getFirstName()).setLastName(user.getLastName()).setEmail(user.getEmailAddress()).build();
                    UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(userProfile).build();
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("param:username", user.getUsername());
                    values.put("param:first_name", user.getFirstName());
                    values.put("param:last_name", user.getLastName());
                    values.put("param:email", user.getEmailAddress());
                    values.put("param:tenant_id", request.getClientId());
                    this.userProfileService.createUserProfile(req);
                    GetTenantRequest tenantReq = GetTenantRequest.newBuilder().setTenantId(request.getTenantId()).build();
                    GetTenantResponse tenantResponse = this.tenantProfileService.getTenant(tenantReq);
                    values.put("param:tenant_name", tenantResponse.getTenant().getClientName());
                }
            });
            String s = this.tokenService.generateWithCustomClaims(response.getAccessToken(), request.getTenantId());
            return response.toBuilder().setAccessToken(s).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while fetching access token " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OIDCConfiguration getOIDCConfiguration(GetOIDCConfiguration request) {
        try {
            LOGGER.debug("Request received  to fetch OIDC configuration " + request.getTenantId());
            return this.identityService.getOIDCConfiguration(request);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving OIDC configuration " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public Credentials getCredentials(GetCredentialsRequest request) {
        try {
            LOGGER.debug("Request received to get Credentials for token " + request.getCredentials().getCustosClientId());
            if (request.getClientId().equals(request.getCredentials().getCustosClientId())) {
                return request.getCredentials();
            }
            LOGGER.error("No matching credential found for the defined client Id: {}", (Object)request.getCredentials().getCustosClientId());
            throw new IllegalArgumentException("No matching credential found for the defined client Id: " + request.getCredentials().getCustosClientId());
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving Credentials " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus endUserSession(EndSessionRequest request) {
        try {
            LOGGER.debug("Request received to endUserSession endpoint " + request.getBody().getTenantId());
            return this.identityService.endSession(request.getBody());
        }
        catch (Exception ex) {
            String msg = "Exception occurred while fetching agent access token " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public JSONObject introspectToken(String clientId, String clientSecret, String tenantId, String token) {
        try {
            String kcToken = this.tokenService.getKCToken(token);
            if (kcToken == null) {
                JSONObject json = new JSONObject();
                json.put("active", false);
                return json;
            }
            return this.identityService.tokenIntrospection(clientId, clientSecret, tenantId, kcToken);
        }
        catch (ParseException e) {
            String msg = "Error while extracting initial KC token";
            LOGGER.error(msg, (Throwable)e);
            throw new InternalServerException(msg, e);
        }
    }
}

