/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;

public class CryptoEnvironmentImpl
implements CryptoEnvironment {
    private final CryptoEnvironment.Scope scope;
    private final TableId tableId;
    private final byte[] decryptionParams;

    public CryptoEnvironmentImpl(CryptoEnvironment.Scope scope, @Nullable TableId tableId, @Nullable byte[] decryptionParams) {
        this.scope = Objects.requireNonNull(scope);
        this.tableId = tableId;
        this.decryptionParams = decryptionParams;
    }

    public CryptoEnvironmentImpl(CryptoEnvironment.Scope scope) {
        this.scope = scope;
        this.tableId = null;
        this.decryptionParams = null;
    }

    @Override
    public CryptoEnvironment.Scope getScope() {
        return this.scope;
    }

    @Override
    public Optional<TableId> getTableId() {
        return Optional.ofNullable(this.tableId);
    }

    @Override
    public Optional<byte[]> getDecryptionParams() {
        return Optional.ofNullable(this.decryptionParams);
    }

    public String toString() {
        String str = String.valueOf((Object)this.scope) + " tableId=" + String.valueOf(this.tableId) + " decryptParams.length=";
        str = this.decryptionParams == null ? str + "0" : str + this.decryptionParams.length;
        return str;
    }
}

