/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.spi.metrics.MeterRegistryFactory;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.metrics.MeterRegistryEnvPropImpl;
import org.apache.hadoop.util.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsInfoImpl
implements MetricsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsInfoImpl.class);
    private final ServerContext context;
    private List<Tag> commonTags = null;
    private JvmGcMetrics jvmGcMetrics;
    private AutoCloseable logMetrics;
    private final boolean metricsEnabled;
    private final List<MetricsProducer> producers = new ArrayList<MetricsProducer>();

    public MetricsInfoImpl(ServerContext context) {
        this.context = context;
        this.metricsEnabled = context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_ENABLED);
        this.printMetricsConfig();
    }

    private void printMetricsConfig() {
        boolean jvmMetricsEnabled = this.context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED);
        LOG.info("micrometer metrics enabled: {}", (Object)this.metricsEnabled);
        if (!this.metricsEnabled) {
            return;
        }
        if (jvmMetricsEnabled) {
            LOG.info("detailed jvm metrics enabled: {}", (Object)jvmMetricsEnabled);
        }
        LOG.info("metrics registry factories: {}", (Object)this.context.getConfiguration().get(Property.GENERAL_MICROMETER_FACTORY));
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public synchronized void addMetricsProducers(MetricsProducer ... producer) {
        if (!this.metricsEnabled) {
            return;
        }
        if (producer.length == 0) {
            LOG.debug("called addMetricsProducers() without providing at least one producer - this has no effect");
            return;
        }
        if (this.commonTags == null) {
            this.producers.addAll(Arrays.asList(producer));
        } else {
            Arrays.stream(producer).forEach(p -> p.registerMetrics((MeterRegistry)Metrics.globalRegistry));
        }
    }

    public synchronized void init(Collection<Tag> tags) {
        String loggingMetrics;
        Objects.requireNonNull(tags);
        if (!this.metricsEnabled) {
            ThreadPools.getServerThreadPools().disableThreadPoolMetrics();
            LOG.info("Metrics not initialized, metrics are disabled.");
            return;
        }
        if (this.commonTags != null) {
            LOG.warn("metrics registry has already been initialized");
            return;
        }
        this.commonTags = List.copyOf(tags);
        LOG.info("Metrics initialization. common tags: {}", this.commonTags);
        Metrics.globalRegistry.config().commonTags(this.commonTags);
        boolean jvmMetricsEnabled = this.context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED);
        MeterFilter replicationFilter = new MeterFilter(){

            public DistributionStatisticConfig configure(Meter.Id id, @NonNull DistributionStatisticConfig config) {
                if (id.getName().equals("replicationQueue")) {
                    return DistributionStatisticConfig.builder().percentiles(new double[]{0.5, 0.75, 0.9, 0.95, 0.99}).expiry(Duration.ofMinutes(10L)).build().merge(config);
                }
                return config;
            }
        };
        String userRegistryFactories = this.context.getConfiguration().get(Property.GENERAL_MICROMETER_FACTORY);
        for (String factoryName : StringUtils.getTrimmedStrings((String)userRegistryFactories)) {
            try {
                MeterRegistry registry = MetricsInfoImpl.getRegistryFromFactory(factoryName, this.context);
                registry.config().meterFilter(replicationFilter);
                registry.config().commonTags(this.commonTags);
                Metrics.globalRegistry.add(registry);
            }
            catch (ReflectiveOperationException ex) {
                LOG.warn("Could not load registry {}", (Object)factoryName, (Object)ex);
            }
        }
        ThreadPools.getServerThreadPools().setMeterRegistry((MeterRegistry)Metrics.globalRegistry);
        if (jvmMetricsEnabled) {
            LOG.info("enabling detailed jvm, classloader, jvm gc and process metrics");
            new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            this.jvmGcMetrics = new JvmGcMetrics();
            this.jvmGcMetrics.bindTo((MeterRegistry)Metrics.globalRegistry);
            new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        switch (loggingMetrics = this.context.getConfiguration().get(Property.GENERAL_MICROMETER_LOG_METRICS)) {
            case "none": {
                LOG.info("Log metrics are disabled.");
                break;
            }
            case "log4j2": {
                Log4j2Metrics l2m = new Log4j2Metrics();
                l2m.bindTo((MeterRegistry)Metrics.globalRegistry);
                this.logMetrics = l2m;
                break;
            }
            case "logback": {
                LogbackMetrics lb = new LogbackMetrics();
                lb.bindTo((MeterRegistry)Metrics.globalRegistry);
                this.logMetrics = lb;
                break;
            }
            default: {
                LOG.info("Log metrics misconfigured, valid values for {} are 'none', 'log4j2' or 'logback'", (Object)Property.GENERAL_MICROMETER_LOG_METRICS.getKey());
            }
        }
        LOG.info("Metrics initialization. Register producers: {}", this.producers);
        this.producers.forEach(p -> p.registerMetrics((MeterRegistry)Metrics.globalRegistry));
    }

    @VisibleForTesting
    static MeterRegistry getRegistryFromFactory(String factoryName, ServerContext context) throws ReflectiveOperationException {
        try {
            LOG.info("look for meter spi registry factory {}", (Object)factoryName);
            Class clazz = ClassLoaderUtil.loadClass((String)factoryName, MeterRegistryFactory.class);
            MeterRegistryFactory factory = (MeterRegistryFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MeterRegistryEnvPropImpl initParameters = new MeterRegistryEnvPropImpl(context);
            return factory.create((MeterRegistryFactory.InitParameters)initParameters);
        }
        catch (ClassCastException clazz) {
            try {
                LOG.info("find legacy meter registry factory {}", (Object)factoryName);
                Class clazz2 = ClassLoaderUtil.loadClass((String)factoryName, org.apache.accumulo.core.metrics.MeterRegistryFactory.class);
                org.apache.accumulo.core.metrics.MeterRegistryFactory factory = (org.apache.accumulo.core.metrics.MeterRegistryFactory)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return factory.create();
            }
            catch (ClassCastException classCastException) {
                throw new ClassNotFoundException("Could not find appropriate class implementing a MetricsFactory for: " + factoryName);
            }
        }
    }

    public synchronized void close() {
        LOG.info("Closing metrics registry");
        if (this.jvmGcMetrics != null) {
            this.jvmGcMetrics.close();
            this.jvmGcMetrics = null;
        }
        if (this.logMetrics != null) {
            try {
                this.logMetrics.close();
            }
            catch (Exception e) {
                LOG.info("Exception when closing log metrics", (Throwable)e);
            }
        }
        Metrics.globalRegistry.close();
    }

    public synchronized String toString() {
        return "MetricsCommonTags{tags=" + String.valueOf(this.commonTags) + "}";
    }
}

