/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeFixedProperties {
    private static final Logger log = LoggerFactory.getLogger(RuntimeFixedProperties.class);
    private final Map<String, String> fixed = new HashMap<String, String>();
    private final Map<String, String> origStored = new HashMap<String, String>();
    private final Set<Property> wasSetByUser = new HashSet<Property>();

    public RuntimeFixedProperties(Map<String, String> storedProps, SiteConfiguration siteConfig) {
        Objects.requireNonNull(siteConfig, "a site configuration must be provided");
        Objects.requireNonNull(storedProps, "stored property map must be provided");
        Property.FIXED_PROPERTIES.forEach(prop -> {
            String key = prop.getKey();
            String value = (String)storedProps.get(key);
            if (value != null) {
                this.origStored.put(key, value);
                this.wasSetByUser.add((Property)prop);
            } else {
                value = siteConfig.get(prop);
                if (siteConfig.isPropertySet(prop)) {
                    this.wasSetByUser.add((Property)prop);
                }
            }
            this.fixed.put(key, value);
            log.trace("fixed property name: {} = {}", (Object)key, (Object)value);
        });
    }

    public @Nullable String get(Property property) {
        return this.fixed.get(property.getKey());
    }

    public boolean wasPropertySet(Property property) {
        return this.wasSetByUser.contains(property);
    }

    @VisibleForTesting
    Map<String, String> getAll() {
        return Collections.unmodifiableMap(this.fixed);
    }

    @VisibleForTesting
    boolean hasChanged(Map<String, String> current) {
        for (Property prop : Property.FIXED_PROPERTIES) {
            String key = prop.getKey();
            if (!(current.containsKey(key) ? !current.get(key).equals(this.fixed.get(key)) : this.origStored.containsKey(key))) continue;
            return true;
        }
        return false;
    }
}

